/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.domain.Group;
import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.Formatter;
import biz.papercut.pcng.util.IPAddressChecker;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.server.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class BarclaycardPlugin
implements UserLinkPlugin,
WebServerPlugin,
SpringContextPlugin,
EnableablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(BarclaycardPlugin.class);
    public static final String RETURN_URL_PATH = "/rpc/gateway/barclaycard/";
    private static final String POSTBACK_URL_PATH = "/rpc/gateway/barclaycard/*";
    private static final String CHARGE_TYPE_IMMEDIATE = "Auth";
    private static final String ORDER_STATUS_SUCCESS = "Success";
    private static final String CONFIG_PREFIX = "barclaycard.";
    public static final String CONFIG_ENABLED = "barclaycard.enabled";
    public static final String CONFIG_CLIENT_ID = "barclaycard.client-id";
    public static final String CONFIG_CSC_REQUIRED = "barclaycard.csc-required";
    public static final String CONFIG_EPDQ_PASSPHRASE = "barclaycard.epdq-passphrase";
    public static final String CONFIG_SECURITY_TOKEN = "barclaycard.security-token";
    public static final String CONFIG_MERCHANT_NAME = "barclaycard.merchant-name";
    public static final String CONFIG_CURRENCY_CODE = "barclaycard.currency-code";
    public static final String CONFIG_PAGE_TITLE = "barclaycard.page-title";
    public static final String CONFIG_PAGE_HEADING = "barclaycard.page-heading";
    public static final String CONFIG_ALLOWED_GROUPS = "barclaycard.allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "barclaycard.allowed-amounts";
    public static final String CONFIG_POSTBACK_ENABLE_PORT_80 = "barclaycard.postback-enable-port-80";
    public static final String CONFIG_POSTBACK_ALLOWED_IP = "barclaycard.postback-allowed-ip";
    public static final String CONFIG_EPDQ_ENCRYPTION_TOOL_URL = "barclaycard.epdq-encryption-tool-url";
    public static final String CONFIG_EPDQ_CPI_PAYMENT_PAGE_URL = "barclaycard.epdq-payment-page-url";
    private static final List<String> PAGES = List.of("ExtnBarclaycard");
    @Nullable
    private ApplicationContext _applicationContext;
    private final Map<String, BarclaycardOrder> _barclaycardOrders = Collections.synchronizedMap(new HashMap());
    @Nullable
    private Connector _connector;
    @Nullable
    private WebAppContext _context;

    public boolean isPluginEnabled() {
        Boolean enabled = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-barclaycard");
    }

    @CheckForNull
    public String getIsConfigured() {
        URL paymentPageURL;
        URL encryptionToolURL;
        Integer clientId;
        GatewayConfig conf = GatewayConfig.getInstance();
        String errorSuffix = "  Please check the payment gateway config file.";
        try {
            clientId = conf.getInteger(CONFIG_CLIENT_ID);
        }
        catch (NumberFormatException nfe) {
            clientId = null;
        }
        if (clientId == null || clientId <= 0) {
            EventLog.getInstance().logEvent("Invalid client ID: " + clientId + ".");
            return "Invalid client ID." + errorSuffix;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_EPDQ_PASSPHRASE))) {
            EventLog.getInstance().logEvent("ePDQ passphrase not provided.");
            return "ePDQ passphrase not provided." + errorSuffix;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_ALLOWED_AMOUNTS))) {
            EventLog.getInstance().logEvent("Must specify at least one allowed payment amount.");
            return "Must specify at least one allowed payment amount." + errorSuffix;
        }
        try {
            encryptionToolURL = conf.getURL(CONFIG_EPDQ_ENCRYPTION_TOOL_URL);
        }
        catch (MalformedURLException murle) {
            encryptionToolURL = null;
        }
        if (encryptionToolURL == null) {
            EventLog.getInstance().logEvent("Invalid ePDQ encryption tool URL: " + conf.getString(CONFIG_EPDQ_ENCRYPTION_TOOL_URL) + ".");
            return "Invalid PDQ encryption tool URL." + errorSuffix;
        }
        try {
            paymentPageURL = conf.getURL(CONFIG_EPDQ_ENCRYPTION_TOOL_URL);
        }
        catch (MalformedURLException murle) {
            paymentPageURL = null;
        }
        if (paymentPageURL == null) {
            EventLog.getInstance().logEvent("Invalid ePDQ CPI payment page URL: " + conf.getString(CONFIG_EPDQ_CPI_PAYMENT_PAGE_URL) + ".");
            return "Invalid ePDQ CPI payment page URL." + errorSuffix;
        }
        return null;
    }

    public boolean isAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        User u = null;
        if (StringUtils.isNotBlank((String)username)) {
            u = this.getUserManager().getUser(username);
        }
        if (u == null) {
            logger.debug("Unable to find user: {}", (Object)username);
            return false;
        }
        GatewayConfig conf = GatewayConfig.getInstance();
        List<String> allowedGroups = conf.getStringList(CONFIG_ALLOWED_GROUPS);
        if (allowedGroups.isEmpty()) {
            return true;
        }
        for (Group group : u.getGroups()) {
            for (String allowedGroup : allowedGroups) {
                if (!allowedGroup.equalsIgnoreCase(group.getGroupName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_PAGE_TITLE));
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        Boolean enablePort80;
        if (!this.isPluginEnabled()) {
            return;
        }
        if (SystemUtils.IS_OS_WINDOWS && ((enablePort80 = GatewayConfig.getInstance().getBoolean(CONFIG_POSTBACK_ENABLE_PORT_80)) == null || enablePort80.booleanValue())) {
            server.listenOnPort(80);
        }
        server.addServlet(BarclaycardCallbackServlet.class, POSTBACK_URL_PATH);
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private boolean isIPAddressValid(String address) {
        String allowed = GatewayConfig.getInstance().getString(CONFIG_POSTBACK_ALLOWED_IP);
        if (StringUtils.isNotBlank((String)allowed) && !"*".equals(allowed)) {
            return IPAddressChecker.isAddressInRange((String)allowed, (String)address);
        }
        return true;
    }

    @CheckForNull
    public String getEncryptedDataInputTag(String orderId, double amount) {
        URLConnection urlConn;
        URL encryptionToolURL;
        StringBuilder response = new StringBuilder();
        GatewayConfig conf = GatewayConfig.getInstance();
        try {
            encryptionToolURL = conf.getURL(CONFIG_EPDQ_ENCRYPTION_TOOL_URL);
        }
        catch (Exception e) {
            String msg = "Invalid ePDQ encryption tool URL in config file.";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            return null;
        }
        String clientId = conf.getString(CONFIG_CLIENT_ID);
        String passphrase = conf.getString(CONFIG_EPDQ_PASSPHRASE);
        String currencyCode = conf.getString(CONFIG_CURRENCY_CODE);
        String amountStr = Formatter.formatNumber((double)amount, (int)2, (Locale)Locale.US);
        Boolean cscRequired = conf.getBoolean(CONFIG_CSC_REQUIRED);
        if (cscRequired == null) {
            cscRequired = false;
        }
        StringBuilder data = new StringBuilder();
        try {
            data.append("clientid=").append(URLEncoder.encode(clientId, StandardCharsets.UTF_8));
            data.append("&oid=").append(URLEncoder.encode(orderId, StandardCharsets.UTF_8));
            data.append("&password=").append(URLEncoder.encode(passphrase, StandardCharsets.UTF_8));
            data.append("&chargetype=").append(URLEncoder.encode(CHARGE_TYPE_IMMEDIATE, StandardCharsets.UTF_8));
            data.append("&currencycode=").append(URLEncoder.encode(currencyCode, StandardCharsets.UTF_8));
            data.append("&total=").append(URLEncoder.encode(amountStr, StandardCharsets.UTF_8));
            data.append("&mandatecsc=").append(cscRequired != false ? "1" : "2");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GatewayUtils.LogHelper.logDebug(logger, "Getting order validation code for order " + orderId + " from Barclaycard Encryption Tool...");
        try {
            urlConn = encryptionToolURL.openConnection();
        }
        catch (Exception e) {
            String msg = "Error connecting to encryption tool: " + e.getMessage();
            EventLog.getInstance().logEvent(msg);
            logger.error(msg, (Throwable)e);
            return null;
        }
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setRequestProperty("Content-length", String.valueOf(data.length()));
        try {
            String line;
            DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
            printout.writeBytes(data.toString());
            printout.flush();
            printout.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
        }
        catch (Exception e) {
            String msg = "Error communicating with encryption tool: " + e.getMessage();
            EventLog.getInstance().logEvent(msg);
            logger.error(msg, (Throwable)e);
            return null;
        }
        GatewayUtils.LogHelper.logDebug(logger, "Order validation code for order " + orderId + " successfully retrieved.");
        return response.toString();
    }

    public void processPostback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token = GatewayConfig.getInstance().getString(CONFIG_SECURITY_TOKEN);
        if (StringUtils.isNotBlank((String)token) && !request.getRequestURI().contains(token)) {
            String msg = "Postback URL contains an invalid or missing security token.";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendError(403, "Invalid request");
            return;
        }
        if (!this.isIPAddressValid(request.getRemoteAddr())) {
            String msg = "Invalid IP address (" + request.getRemoteAddr() + ") accessing Barclaycard postback URL: " + request.getRequestURI();
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendError(403, "Invalid request");
            return;
        }
        String transactionStatus = request.getParameter("transactionstatus");
        String amountStr = request.getParameter("total");
        String clientId = request.getParameter("clientid");
        String orderId = request.getParameter("oid");
        String chargeType = request.getParameter("chargetype");
        String orderSubmissionTime = request.getParameter("datetime");
        if (StringUtils.isEmpty((String)orderId)) {
            String msg = "Invalid Barclaycard post data. Missing order id.";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendError(500, "Unexpected post data");
            return;
        }
        if (!GatewayConfig.getInstance().getString(CONFIG_CLIENT_ID).equals(clientId)) {
            String msg = "Barclaycard reported transaction for client id '" + clientId + "' which did not match the configured client id.  Check configuration.";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
        }
        double amountAdded = 0.0;
        try {
            amountAdded = Double.parseDouble(amountStr);
        }
        catch (NumberFormatException nfe) {
            String msg = "Invalid Barclaycard post data. Invalid amount: " + StringUtils.trimToEmpty((String)amountStr);
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendError(500, "Unexpected post data");
            return;
        }
        if (!CHARGE_TYPE_IMMEDIATE.equalsIgnoreCase(chargeType)) {
            String msg = "Barclaycard reported a charge type of: '" + chargeType + "', indicating payment has not been finalized.  Only immediate payments are supported.  ePDQ must be configured to only allow payments of type Auth (immediate payment).";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendError(500, "Delayed shipment not supported");
            return;
        }
        BarclaycardOrder bo = this._barclaycardOrders.get(orderId);
        boolean orderSuccess = ORDER_STATUS_SUCCESS.equalsIgnoreCase(transactionStatus);
        String msg = orderSuccess ? "Barclaycard reported successful transaction for order id " + orderId + ", completing order.  Remote address: " + request.getRemoteAddr() : "Barclaycard reported failed transaction for order id " + orderId + ", cancelling order.  Remote address: " + request.getRemoteAddr();
        EventLog.getInstance().logEvent(msg);
        logger.info(msg);
        if (bo != null) {
            this._barclaycardOrders.put(orderId, new BarclaycardOrder(bo.getReturnRedirectURL(), orderSuccess));
        }
        if (orderSuccess) {
            CreditCardGatewayPlugin.OrderResponse orderResponse = BarclaycardPlugin.getCreditCardGatewayPlugin().confirmOrder(orderId, amountAdded);
            if (orderResponse.isSuccess()) {
                EventLog.getInstance().logEvent("Order " + orderId + " confirmed.  Order was submitted at: " + orderSubmissionTime);
            } else {
                String errorMsg = "Could not confirm order " + orderId + ", message: " + orderResponse.getMessage();
                EventLog.getInstance().logEvent(errorMsg);
                logger.error(errorMsg);
                response.sendError(500, "Unexpected post data");
            }
        }
    }

    public void processReturn(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String orderId = request.getParameter("oid");
        BarclaycardOrder bo = this._barclaycardOrders.remove(orderId);
        if (bo == null) {
            String msg = "User accessed Barclaycard callback URL with the invalid order id " + orderId + ".  Redirecting user to the login page.";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendRedirect("/");
            return;
        }
        boolean success = false;
        Boolean s = bo.getSuccessful();
        if (s != null && s.booleanValue()) {
            success = true;
        }
        String redirectURL = bo.getReturnRedirectURL() + "&success=" + success;
        String msg = "Barclaycard server returned user after payment processing, order id: " + orderId + ", successful: " + success + ".  Redirecting user to: " + redirectURL;
        EventLog.getInstance().logEvent(msg);
        logger.debug(msg);
        response.sendRedirect(redirectURL);
    }

    static PluginManager getPluginManager() {
        return PluginManager.getInstance();
    }

    static CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)BarclaycardPlugin.getPluginManager().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    static BarclaycardPlugin getBarclaycardPlugin() {
        return (BarclaycardPlugin)BarclaycardPlugin.getPluginManager().getPluginByClass(BarclaycardPlugin.class);
    }

    public String createNewOrder(String username, double amount, String returnURL) {
        String orderId = BarclaycardPlugin.getCreditCardGatewayPlugin().createNewOrder(username, amount);
        BarclaycardOrder bo = new BarclaycardOrder(returnURL, null);
        this._barclaycardOrders.put(orderId, bo);
        return orderId;
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    public static class BarclaycardCallbackServlet
    extends HttpServlet {
        private static final Logger logger = LoggerFactory.getLogger(BarclaycardCallbackServlet.class);

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            BarclaycardPlugin.getBarclaycardPlugin().processPostback(request, response);
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            if (StringUtils.isNotBlank((String)request.getParameter("oid"))) {
                BarclaycardPlugin.getBarclaycardPlugin().processReturn(request, response);
                return;
            }
            response.getWriter().write("<html><body><h1>The Barclaycard ePDQ Postback URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. that the Barclaycard server has access)</p></body></html>");
        }

        private void debugLogRequest(HttpServletRequest request) {
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Callback servlet accessed via ").append(request.getMethod());
                msg.append(", URL: ").append(request.getRequestURL());
                msg.append(", from: ").append(request.getRemoteAddr());
                msg.append(", params: ");
                for (Map.Entry e : request.getParameterMap().entrySet()) {
                    String value = ((String[])e.getValue()).length > 1 ? ArrayUtils.toString(e.getValue()) : ((String[])e.getValue())[0];
                    msg.append((String)e.getKey()).append('=').append(value).append(',');
                }
                logger.debug(msg.toString());
            }
        }
    }

    public static class BarclaycardOrder {
        private final String _returnRedirectURL;
        @CheckForNull
        private final Boolean _successful;

        public BarclaycardOrder(String returnRedirectURL, @Nullable Boolean successful) {
            this._returnRedirectURL = returnRedirectURL;
            this._successful = successful;
        }

        public String getReturnRedirectURL() {
            return this._returnRedirectURL;
        }

        @CheckForNull
        public Boolean getSuccessful() {
            return this._successful;
        }
    }
}

