/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.domain.Group;
import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.IPAddressChecker;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class BasePaymentGatewayPlugin
implements UserLinkPlugin,
SpringContextPlugin,
EnableablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(BasePaymentGatewayPlugin.class);
    public static final String CONFIG_ENABLED = "enabled";
    public static final String CONFIG_PAGE_TITLE = "page-title";
    public static final String CONFIG_PAGE_HEADING = "page-heading";
    public static final String CONFIG_ALLOWED_GROUPS = "allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "allowed-amounts";
    private static final String DEFAULT_PAGE_HEADING = "Add credit using a credit card";
    private ApplicationContext _applicationContext;

    public abstract String getConfigPrefix();

    public abstract boolean isLicensed();

    public String getUserErrorMessage() {
        return this.getGatewayConfig().getUserErrorMessage();
    }

    public boolean isPluginEnabled() {
        Boolean enabled = this.getGatewayConfig().getBoolean(this.getConfigPrefix() + CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        User u = null;
        if (StringUtils.isNotBlank((String)username)) {
            u = this.getUserManager().getUser(username);
        }
        if (u == null) {
            logger.debug("Unable to find user: {}", (Object)username);
            return false;
        }
        List<String> allowedGroups = this.getGatewayConfig().getStringList(this.getConfigPrefix() + CONFIG_ALLOWED_GROUPS);
        if (allowedGroups.isEmpty()) {
            return true;
        }
        for (Group group : u.getGroups()) {
            for (String allowedGroup : allowedGroups) {
                if (!allowedGroup.equalsIgnoreCase(group.getGroupName())) continue;
                return true;
            }
        }
        return false;
    }

    public String getPageTitle() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(this.getConfigPrefix() + CONFIG_PAGE_TITLE));
    }

    public String getPageHeading() {
        String heading = StringUtils.trimToNull((String)this.getGatewayConfig().getString(this.getConfigPrefix() + CONFIG_PAGE_HEADING));
        if (heading == null) {
            heading = DEFAULT_PAGE_HEADING;
        }
        return heading;
    }

    public String getAllowedAmounts() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(this.getConfigPrefix() + CONFIG_ALLOWED_AMOUNTS));
    }

    protected boolean isIPAddressValid(String address, String allowedIPMask) {
        if (StringUtils.isNotBlank((String)allowedIPMask) && !"*".equals(allowedIPMask)) {
            if (StringUtils.contains((String)allowedIPMask, (String)",")) {
                return IPAddressChecker.isAddressMatchInSet((String)address, (String[])StringUtils.split((String)allowedIPMask, (String)","));
            }
            return IPAddressChecker.isAddressInRange((String)allowedIPMask, (String)address);
        }
        return true;
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    protected GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    protected CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)PluginManager.getInstance().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    protected ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    protected UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }
}

