/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.ext.paymentgateway.CountryRepository;
import biz.papercut.pcng.util.Messages;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry.form.IPropertySelectionModel;

public class CountriesPropertySelectionModel
implements IPropertySelectionModel {
    private final List<CountryRepository.Country> countries;
    private final Locale locale;
    private final CountryRepository.Country defaultCountry;

    public CountriesPropertySelectionModel(List<CountryRepository.Country> countries, CountryRepository.Country defaultCountry) {
        this(countries, Locale.ENGLISH, defaultCountry);
    }

    public CountriesPropertySelectionModel(List<CountryRepository.Country> countries, Locale locale, CountryRepository.Country defaultCountry) {
        this.countries = countries;
        this.locale = locale;
        this.defaultCountry = defaultCountry;
    }

    public String getLabel(int index) {
        if (index == 0) {
            if (this.defaultCountry != null) {
                return this.defaultCountry.getName();
            }
            return Messages.getString(this.getClass(), (Locale)this.locale, (String)"CountriesPropertySelectionModel.select-the-country", (String[])new String[0]);
        }
        return this.countries.get(index - 1).getName();
    }

    public Object getOption(int index) {
        if (index == 0) {
            if (this.defaultCountry != null) {
                return this.defaultCountry.getCode();
            }
            return null;
        }
        return this.countries.get(index - 1).getCode();
    }

    public int getOptionCount() {
        return this.countries.size() + 1;
    }

    public String getValue(int index) {
        return String.valueOf(index);
    }

    public Object translateValue(String value) {
        return this.getOption(Integer.parseInt(value));
    }
}

