/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.CreditUtilities;
import biz.papercut.pcng.service.UserManager;
import com.papercut.server.lang.service.TransactionHelper;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CreditCardGatewayPlugin
implements SpringContextPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CreditCardGatewayPlugin.class);
    private static final int DEFAULT_MAX_ORDER_LIFE_SECONDS = 7200;
    @GuardedBy(value="this")
    private static long _currentOrderID = System.currentTimeMillis();
    private final Map<String, CreditCardOrder> _orders = Collections.synchronizedMap(new HashMap());
    private ApplicationContext _ctx;

    public static synchronized long getUniqueOrderID() {
        return _currentOrderID++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanUpOldOrders() {
        Calendar cal = Calendar.getInstance();
        cal.add(13, -7200);
        Date oldestDate = cal.getTime();
        Map<String, CreditCardOrder> map = this._orders;
        synchronized (map) {
            Iterator<CreditCardOrder> i = this._orders.values().iterator();
            while (i.hasNext()) {
                CreditCardOrder o = i.next();
                if (o == null || !o.getCreationDate().before(oldestDate)) continue;
                EventLog.getInstance().logEvent("Order timeout reached! Removing order " + o.getOrderID() + " from cache.");
                i.remove();
            }
        }
    }

    public String createNewOrder(String username, double amount) {
        return this.createNewOrder(username, amount, -1);
    }

    public String createNewOrder(String username, double amount, int maxOrderIdLength) {
        this.cleanUpOldOrders();
        String uniqueOrderId = String.valueOf(CreditCardGatewayPlugin.getUniqueOrderID());
        String safeUsername = GatewayUtils.retainAlphanumericASCII(username);
        String orderID = safeUsername + uniqueOrderId;
        if (maxOrderIdLength > 0 && orderID.length() > maxOrderIdLength) {
            int remainingChars = maxOrderIdLength - uniqueOrderId.length();
            if (remainingChars < 0) {
                remainingChars = 0;
            }
            String trimmedUsername = StringUtils.left((String)safeUsername, (int)remainingChars);
            orderID = trimmedUsername + uniqueOrderId;
        }
        CreditCardOrder order = new CreditCardOrder(username, amount, orderID);
        this._orders.put(order.getOrderID(), order);
        String msg = "Created a new order for user " + username + ", order id: " + order.getOrderID();
        if (order.getAmount() > 0.0) {
            msg = msg + ", amount: " + order.getAmount();
        }
        EventLog.getInstance().logEvent(msg);
        logger.debug(msg);
        return order.getOrderID();
    }

    public boolean isOrderExists(String orderId) {
        return this._orders.get(orderId) != null;
    }

    @Nullable
    public OrderResponse getExistingOrderReponse(String orderId) {
        CreditCardOrder order = this._orders.get(orderId);
        if (order == null) {
            return null;
        }
        return order.getResponse();
    }

    public OrderResponse confirmOrder(String orderId) {
        return this.confirmOrder(orderId, -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderResponse confirmOrder(String orderId, @Nullable String paymentReference, double amountAdded) {
        OrderResponse response;
        this.cleanUpOldOrders();
        Map<String, CreditCardOrder> map = this._orders;
        synchronized (map) {
            double difference;
            CreditCardOrder order = this._orders.get(orderId);
            if (order == null) {
                return new OrderResponse(false, "Unknown Order number: " + orderId);
            }
            if (order.getResponse() != null) {
                return new OrderResponse(false, "Unknown Order number: " + orderId);
            }
            if (amountAdded > 0.0 && order.getAmount() > 0.0 && (difference = Math.abs(order.getAmount() - amountAdded)) > 0.01) {
                OrderResponse response2 = new OrderResponse(false, "Unexpected order amount. Expected " + this.getCreditUtilities().formatCost(order.getAmount(), null) + " but gateway returned " + this.getCreditUtilities().formatCost(amountAdded, null));
                order.setResponse(response2);
                return response2;
            }
            double amount = Math.max(amountAdded, order.getAmount());
            String transactionComment = this.getTransactionComment(orderId);
            logger.debug("Getting the user and accountId in a transaction");
            Optional accountId = (Optional)this.getTransactionHelper().runInTransaction(() -> this.resolveAccountId(order));
            if (accountId.isEmpty()) {
                OrderResponse response3 = new OrderResponse(false, "Unknown user " + order.getUsername());
                order.setResponse(response3);
                return response3;
            }
            logger.debug("Fetched accountId of the user: {}", (Object)accountId);
            GatewayUtils.addCreditToUserTxn((Long)accountId.get(), this.getCreditSourceManager(), amount, transactionComment);
            logger.debug("Balance added to the account. Clearing off the Session");
            this.getUserManager().clearSession();
            EventLog.getInstance().logTransaction(order.getUsername(), order.getOrderID(), amount, "Credit Card", paymentReference);
            response = new OrderResponse(true, "");
            order.setResponse(response);
        }
        return response;
    }

    private Optional<Long> resolveAccountId(CreditCardOrder order) {
        User user = this.getUserManager().getUser(order.getUsername());
        if (user == null) {
            return Optional.empty();
        }
        return GatewayUtils.getPaymentAccountId(this.getAccountManager(), user);
    }

    public OrderResponse confirmOrder(String orderId, double amountAdded) {
        return this.confirmOrder(orderId, null, amountAdded);
    }

    private String getTransactionComment(String orderId) {
        String configComment = GatewayConfig.getInstance().getTransactionComment();
        String commentTemplate = StringUtils.isBlank((String)configComment) ? "External funds added by payment gateway" : configComment;
        return StringUtils.replaceEach((String)commentTemplate, (String[])new String[]{"%id%"}, (String[])new String[]{orderId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderResponse confirmOrderReentrant(String orderId, double amountAdded) {
        OrderResponse response;
        Map<String, CreditCardOrder> map = this._orders;
        synchronized (map) {
            CreditCardOrder order = this._orders.get(orderId);
            if (order == null) {
                return new OrderResponse(false, "Unknown Order number: " + orderId);
            }
            if (order.getResponse() != null) {
                response = order.getResponse();
                response.setAlreadyProcessed(true);
            } else {
                response = this.confirmOrder(orderId, amountAdded);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelOrder(String orderId) {
        Map<String, CreditCardOrder> map = this._orders;
        synchronized (map) {
            CreditCardOrder order = this._orders.get(orderId);
            if (order != null) {
                order.setResponse(new OrderResponse(false, "Order was cancelled"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreditCardOrder getOrderReadOnly(String orderId) {
        Map<String, CreditCardOrder> map = this._orders;
        synchronized (map) {
            return this._orders.get(orderId);
        }
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private CreditUtilities getCreditUtilities() {
        return (CreditUtilities)this._ctx.getBean("creditUtilities", CreditUtilities.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this._ctx.getBean("userManager", UserManager.class);
    }

    private AccountManager getAccountManager() {
        return (AccountManager)this._ctx.getBean("accountManager", AccountManager.class);
    }

    private CreditSourceManager getCreditSourceManager() {
        return (CreditSourceManager)this._ctx.getBean("creditSourceManager", CreditSourceManager.class);
    }

    private TransactionHelper getTransactionHelper() {
        return (TransactionHelper)this._ctx.getBean("transactionHelper", TransactionHelper.class);
    }

    public static class CreditCardOrder {
        private final String _username;
        private final double _amount;
        private final String _orderID;
        private final Date _creationDate;
        private OrderResponse _response;

        public CreditCardOrder(String username, double amount, String orderID) {
            this._username = username;
            this._amount = amount;
            this._orderID = orderID;
            this._creationDate = new Date();
        }

        public double getAmount() {
            return this._amount;
        }

        public Date getCreationDate() {
            return new Date(this._creationDate.getTime());
        }

        public String getOrderID() {
            return this._orderID;
        }

        public String getUsername() {
            return this._username;
        }

        @Nullable
        public synchronized OrderResponse getResponse() {
            return this._response;
        }

        public synchronized void setResponse(OrderResponse response) {
            this._response = response;
        }
    }

    public static class OrderResponse {
        private final boolean _success;
        private final String _message;
        private volatile boolean _alreadyProcessed;

        public OrderResponse(boolean success, String message) {
            this._success = success;
            this._message = message;
        }

        public String getMessage() {
            return this._message;
        }

        public boolean isSuccess() {
            return this._success;
        }

        public boolean isAlreadyProcessed() {
            return this._alreadyProcessed;
        }

        public void setAlreadyProcessed(boolean alreadyProcessed) {
            this._alreadyProcessed = alreadyProcessed;
        }
    }
}

