/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.server.ServerConfig;
import biz.papercut.pcng.util.Formatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventLog {
    private static final Logger logger = LoggerFactory.getLogger(EventLog.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd\th:mm:ss a", Locale.US);
    private static final String EVENT_LOG_NAME = "event.log";
    private static final String TRANSACTION_LOG_NAME = "transaction.log";
    private static EventLog _instance;
    private BufferedWriter _eventLogWriter;
    private BufferedWriter _transactionLogWriter;

    private EventLog() {
        File logFile;
        File logHome = new File(ServerConfig.getInstance().getServerLogsDir(), "payment-gateway");
        logHome.mkdirs();
        try {
            logFile = new File(logHome, EVENT_LOG_NAME);
            this._eventLogWriter = new BufferedWriter(new FileWriter(logFile, true));
        }
        catch (Exception e) {
            logger.error("Unable to open payment gateway event log.", (Throwable)e);
        }
        try {
            logFile = new File(logHome, TRANSACTION_LOG_NAME);
            this._transactionLogWriter = new BufferedWriter(new FileWriter(logFile, true));
        }
        catch (Exception e) {
            logger.error("Unable to open payment gateway transaction log.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventLog getInstance() {
        if (_instance != null) return _instance;
        Class<EventLog> clazz = EventLog.class;
        synchronized (EventLog.class) {
            if (_instance != null) return _instance;
            _instance = new EventLog();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEvent(String msg) {
        if (this._eventLogWriter == null) {
            return;
        }
        BufferedWriter bufferedWriter = this._eventLogWriter;
        synchronized (bufferedWriter) {
            try {
                SimpleDateFormat simpleDateFormat = DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    this._eventLogWriter.write(DATE_FORMAT.format(new Date()));
                }
                this._eventLogWriter.write("\t");
                this._eventLogWriter.write(msg);
                this._eventLogWriter.write(SystemUtils.LINE_SEPARATOR);
                this._eventLogWriter.flush();
            }
            catch (IOException e) {
                logger.error("Unable to write to payment gateway event log.", (Throwable)e);
                logger.error("Missed msg: {}", (Object)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logTransaction(String username, String transactionID, Double amount, String source, Object ... additionalData) {
        BufferedWriter bufferedWriter = this._transactionLogWriter;
        synchronized (bufferedWriter) {
            try {
                Object[] objectArray = DATE_FORMAT;
                synchronized (DATE_FORMAT) {
                    this._transactionLogWriter.write(DATE_FORMAT.format(new Date()));
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    this._transactionLogWriter.write("\t");
                    this._transactionLogWriter.write(transactionID);
                    this._transactionLogWriter.write("\t");
                    this._transactionLogWriter.write(StringUtils.trimToEmpty((String)username));
                    this._transactionLogWriter.write("\t");
                    this._transactionLogWriter.write(Formatter.formatNumber((double)amount, (int)2, null));
                    this._transactionLogWriter.write("\t");
                    this._transactionLogWriter.write(source);
                    if (additionalData != null) {
                        for (Object o : additionalData) {
                            this._transactionLogWriter.write("\t");
                            if (o == null) continue;
                            this._transactionLogWriter.write(o.toString());
                        }
                    }
                    this._transactionLogWriter.write(SystemUtils.LINE_SEPARATOR);
                    this._transactionLogWriter.flush();
                }
            }
            catch (IOException e) {
                logger.error("Unable to write to payment gateway transaction log.", (Throwable)e);
                logger.error("Missed msg: {}, {}, {}, {}", new Object[]{username, transactionID, amount, source});
            }
            {
            }
        }
    }

    public void logTransaction(String username, String transactionID, Double amount, String source) {
        this.logTransaction(username, transactionID, amount, source, null);
    }
}

