/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.domain.Group;
import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.ExternalCreditSourceProvider;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.MyStudentAccountProvider;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ExternalCreditSourcePlugin
implements UserLinkPlugin,
SpringContextPlugin,
EnableablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(ExternalCreditSourcePlugin.class);
    private static final String CONFIG_PREFIX = "external-credit-source.";
    private static final String CONFIG_ENABLED = "external-credit-source.enabled";
    private static final String CONFIG_ALLOWED_GROUPS = "external-credit-source.allowed-groups";
    private static final String CONFIG_PAGE_TITLE = "external-credit-source.page-title";
    @AESProperty
    public static final String NOT_USE_MY_STUDENT_FIELD_SERVER_PASSWD = "my-student-account.server-password";
    private static final List<String> PAGES = new ArrayList<String>(1);
    private ApplicationContext _ctx = null;

    public boolean isPluginEnabled() {
        Boolean enabled = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isLicensed(ExternalCreditSourceProvider provider) {
        if (provider instanceof MyStudentAccountProvider) {
            LicenseManager lm = (LicenseManager)this._ctx.getBean("licenseManager", LicenseManager.class);
            return GatewayUtils.isLicensed(lm, "payment-gateways-my-student-account");
        }
        return true;
    }

    public boolean userHasAccess(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        User u = null;
        if (username != null) {
            u = this.getUserManager().getUser(username);
        }
        if (u == null) {
            logger.debug("Unable to find user: {}", (Object)username);
            return false;
        }
        GatewayConfig conf = GatewayConfig.getInstance();
        List<String> allowedGroups = conf.getStringList(CONFIG_ALLOWED_GROUPS);
        if (allowedGroups.isEmpty()) {
            return true;
        }
        List userGroups = u.getGroups();
        for (Group group : userGroups) {
            for (String allowedGroup : allowedGroups) {
                if (!allowedGroup.equalsIgnoreCase(group.getGroupName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.userHasAccess(username)) {
            return PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_PAGE_TITLE));
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private UserManager getUserManager() {
        return (UserManager)this._ctx.getBean("userManager", UserManager.class);
    }

    static {
        PAGES.add("ExtnAddCredit");
    }
}

