/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin4;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeTopupPlugin
implements TopupAccountOnDemandPlugin4 {
    private static final Logger logger = LoggerFactory.getLogger(FakeTopupPlugin.class);
    private double _currentCredit;

    public FakeTopupPlugin() {
        logger.info("Creating fake top-up plugin");
        this._currentCredit = 1.0;
    }

    @Nullable
    public TopupAccountOnDemandPlugin3.AvailableCredit getAvailableCreditForTopUp(String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged) {
        TopupAccountOnDemandPlugin3.AvailableCredit ac = new TopupAccountOnDemandPlugin3.AvailableCredit(false, this._currentCredit);
        logger.info("available credit: {}", (Object)ac);
        return ac;
    }

    public TopupAccountOnDemandPlugin.TopupResponse getTopup(double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails) {
        return GatewayUtils.performTopupDebit((TopupAccountOnDemandPlugin3)this, amount -> {
            if (amount > this._currentCredit) {
                logger.warn("Not enough credit available!!! Asked for: {}", (Object)amount);
                return null;
            }
            this._currentCredit -= amount;
            logger.info("Deducted: {}, remaining: {}", (Object)amount, (Object)this._currentCredit);
            return amount;
        }, amountRequired, amountRequired, username, sharedAccount, accountCharged, usageDetails, "fake topup");
    }

    public boolean isPluginEnabled() {
        return true;
    }

    public Map<String, Double> getBalance(Map<String, String> userDetails) {
        HashMap<String, Double> bal = new HashMap<String, Double>();
        bal.put("Fake balance", Math.floor(this._currentCredit * 100.0) / 100.0);
        return bal;
    }
}

