/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.server.ServerConfig;
import biz.papercut.pcng.util.AESEncrp;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.PropertiesUtils;
import biz.papercut.pcng.util.io.IOUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GatewayConfig {
    private static final Logger logger = LoggerFactory.getLogger(GatewayConfig.class);
    @Nullable
    private static GatewayConfig _instance;
    public static final String PRIMARY_CONFIG_FILE = "ext-payment-gateway.properties";
    public static final String ADDITIONAL_CONFIG_FILES_REGEX = "^ext-payment-gateway.+\\.properties$";
    public static final String FIELD_USER_ERROR_MESSAGE = "user-error-message";
    public static final String FIELD_NO_ACCESS_MESSAGE = "no-access-message";
    public static final String FIELD_TRANSACTION_COMMENT = "transaction-comment";
    public static final String CONFIG_PAGE_MESSAGE = "page-message";
    private final Map<String, Long> _modifiedDates = new HashMap<String, Long>();
    private String _userErrorMessage = "";
    private String _noAccessMessage = "";
    private String _transactionComment = "";
    private Properties _allProperties = new Properties();
    private static final String ENCRYPT_KEY = "PsiTPRJEDQpzCAo2";
    private static final String PREFIX_ENCRYPTED = "ENCRYPTED:";

    private GatewayConfig() {
        this.loadIfRequired(true);
    }

    @VisibleForTesting
    File[] getAllConfigFiles(File extensionHome) {
        if (!extensionHome.isDirectory()) {
            throw new ApplicationException("Unable to find extension directory: " + extensionHome.getAbsolutePath());
        }
        File primaryConfFile = new File(extensionHome, PRIMARY_CONFIG_FILE);
        if (!primaryConfFile.isFile()) {
            throw new ApplicationException("Unable to find the extensions config file: " + primaryConfFile.getAbsolutePath());
        }
        Object[] configFiles = extensionHome.listFiles((dir, name) -> StringUtils.isNotBlank((String)name) && name.matches(ADDITIONAL_CONFIG_FILES_REGEX));
        return (File[])ArrayUtils.add((Object[])configFiles, (Object)primaryConfFile);
    }

    private void loadIfRequired(boolean force) {
        Properties properties = this.getAllProperties();
        ArrayList<String> configFileNamesRead = new ArrayList<String>();
        File extensionHome = this.getExtensionHome();
        File[] configFiles = this.getAllConfigFiles(extensionHome);
        FileInputStream fin = null;
        for (File f : configFiles) {
            String filePath;
            if (!f.isFile()) {
                throw new ApplicationException("Unable to find the extension config file: " + f.getAbsolutePath());
            }
            try {
                filePath = f.getCanonicalPath();
            }
            catch (Exception e) {
                logger.error("Unable to get file path for extension config file: {}", (Object)f);
                continue;
            }
            if (!force && this.getModifiedDate(filePath) == f.lastModified()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Loading extension configuration from file: {}", (Object)filePath);
            }
            InputStreamReader isr = null;
            try {
                this.setModifiedDate(filePath, f.lastModified());
                fin = new FileInputStream(f);
                isr = new InputStreamReader((InputStream)fin, StandardCharsets.UTF_8);
                properties.load(isr);
                configFileNamesRead.add(f.getName());
            }
            catch (IOException e) {
                try {
                    throw new ApplicationException("Unable to read the extension config file. " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(isr);
                    IOUtils.closeQuietly(fin);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((InputStream)fin);
        }
        if (!configFileNamesRead.isEmpty()) {
            logger.info("Read {} extension config files from {}: {}", new Object[]{configFileNamesRead.size(), extensionHome, configFileNamesRead});
        }
        this.scanAndDecryptAESProps(properties, ENCRYPT_KEY);
        this._userErrorMessage = StringUtils.trimToEmpty((String)properties.getProperty(FIELD_USER_ERROR_MESSAGE));
        this._noAccessMessage = StringUtils.trimToEmpty((String)properties.getProperty(FIELD_NO_ACCESS_MESSAGE));
        this._transactionComment = StringUtils.trimToEmpty((String)properties.getProperty(FIELD_TRANSACTION_COMMENT));
        this._allProperties = properties;
    }

    public static synchronized GatewayConfig getInstance() {
        if (_instance == null) {
            _instance = new GatewayConfig();
        } else {
            try {
                _instance.loadIfRequired(false);
            }
            catch (Exception e) {
                logger.error("Problem trying to reload extension config file. Leaving configuration as is.");
            }
        }
        return _instance;
    }

    public Properties getAllProperties() {
        return this._allProperties;
    }

    @Nullable
    public String getProperty(String key) {
        return this._allProperties.getProperty(key);
    }

    @Nullable
    public String getString(String key) {
        return this.getProperty(key);
    }

    @CheckForNull
    public Double getDouble(String key) throws NumberFormatException {
        String v = this.getProperty(key);
        if (StringUtils.isBlank((String)v)) {
            return null;
        }
        return GatewayUtils.parseDoubleExtended(v);
    }

    @CheckForNull
    public Integer getInteger(String key) throws NumberFormatException {
        String v = this.getProperty(key);
        if (StringUtils.isBlank((String)v)) {
            return null;
        }
        return Integer.parseInt(v);
    }

    public Boolean getBoolean(String key) {
        String v = this.getProperty(key);
        if (v == null) {
            return null;
        }
        if ((v = v.trim().toLowerCase()).startsWith("y") || v.startsWith("1") || v.equals("on")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public List<String> getStringList(String key) {
        String v = StringUtils.trimToEmpty((String)this.getString(key));
        String[] arr = v.split("\\s*,\\s*");
        ArrayList<String> ret = new ArrayList<String>(arr.length);
        for (String string : arr) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            ret.add(string);
        }
        return ret;
    }

    public List<Double> getDoubleList(String key) {
        String v = StringUtils.trimToEmpty((String)this.getString(key));
        String[] arr = v.indexOf(59) > 0 ? v.split("\\s*;\\s*") : v.split("\\s*,\\s*");
        ArrayList<Double> ret = new ArrayList<Double>(arr.length);
        for (String string : arr) {
            try {
                Double d;
                if (!StringUtils.isNotBlank((String)string) || (d = GatewayUtils.parseDoubleExtended(string)) == null) continue;
                ret.add(d);
            }
            catch (Exception e) {
                logger.error("Invalid value '{}' in list: {}", (Object)string, (Object)key);
            }
        }
        return ret;
    }

    public URL getURL(String key) throws MalformedURLException {
        String v = StringUtils.trimToEmpty((String)this.getString(key));
        return StringUtils.isBlank((String)v) ? null : new URL(v);
    }

    private void setModifiedDate(String filePath, long modifiedDate) {
        this._modifiedDates.put(filePath, modifiedDate);
    }

    public long getModifiedDate(String filePath) {
        Long modDate = this._modifiedDates.get(filePath);
        return modDate == null ? 0L : modDate;
    }

    public String getNoAccessMessage() {
        return this._noAccessMessage;
    }

    public String getUserErrorMessage() {
        return this._userErrorMessage;
    }

    public String getTransactionComment() {
        return this._transactionComment;
    }

    public boolean getPageMessageAvailable() {
        return StringUtils.isNotBlank((String)this.getString(CONFIG_PAGE_MESSAGE));
    }

    @Nullable
    public String getPageMessage() {
        return this.getString(CONFIG_PAGE_MESSAGE);
    }

    public String maskIfConfigExistsAndFalse(String id, String configKey) {
        Boolean b = this.getBoolean(configKey);
        if (b != null && !b.booleanValue()) {
            return "*****";
        }
        return id;
    }

    File getExtensionHome() {
        return new File(ServerConfig.getInstance().getExtensionHome());
    }

    public void scanAndEncryptAESProperties(Set<String> aesProperties) {
        File[] configFiles;
        File extensionHome = this.getExtensionHome();
        for (File f : configFiles = this.getAllConfigFiles(extensionHome)) {
            if (!f.isFile()) continue;
            try (FileInputStream inputStream = new FileInputStream(f);
                 InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
                Properties props = new Properties();
                props.load(reader);
                props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    if (!aesProperties.contains(key)) {
                        return;
                    }
                    if (value instanceof String && !this.isEncryptedValue((String)value)) {
                        try {
                            this.encryptAndSaveStringProperty((String)key, (String)value, f.getAbsolutePath(), ENCRYPT_KEY);
                        }
                        catch (Exception e) {
                            logger.error("Unable to encrypt property: {}", key, (Object)e);
                        }
                    }
                }));
            }
            catch (IOException e) {
                logger.error("Unable to read the extension config file. {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void scanAndDecryptAESProps(Properties props, String encryptKey) {
        props.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(key, value) -> {
            if (value instanceof String && this.isEncryptedValue((String)value)) {
                try {
                    value = AESEncrp.decrypt((String)((String)value).replace(PREFIX_ENCRYPTED, ""), (String)encryptKey);
                }
                catch (UnsupportedEncodingException | GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
            return value;
        }));
    }

    private boolean isEncryptedValue(String value) {
        return value.startsWith(PREFIX_ENCRYPTED);
    }

    private void encryptAndSaveStringProperty(String key, String value, String filePath, String encryptKey) throws Exception {
        String encryptedValue = AESEncrp.encrypt((String)value, (String)encryptKey);
        Properties updated = new Properties();
        updated.setProperty(key, PREFIX_ENCRYPTED + encryptedValue);
        this.saveProperties(filePath, updated);
    }

    @VisibleForTesting
    public void saveProperties(String filePath, Properties props) throws IOException {
        PropertiesUtils.saveUpdatedProperties((String)filePath, (Properties)props);
    }
}

