/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.domain.Account;
import biz.papercut.pcng.domain.AccountTransactionType;
import biz.papercut.pcng.domain.Group;
import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.pages.AllowedAmountsPropertySelectionModel;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.IPAddressChecker;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import jakarta.servlet.http.HttpServletRequest;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.slf4j.Log4jLogger;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GatewayUtils {
    private static final Logger logger = LoggerFactory.getLogger(GatewayUtils.class);
    private static final String CLASS_NAME_SLF4J_LOG4JLOGGER = "org.apache.logging.slf4j.Log4jLogger";
    private static final double DOUBLE_ROUNDING_TOLERANCE = 1.0E-5;
    private static final Map<String, Boolean> _gatewayLicenseCache = new ConcurrentHashMap<String, Boolean>();

    public static boolean isAccessibleByUser(String username, String groupsConfigName, UserManager userManager) {
        User u = null;
        if (StringUtils.isNotBlank((String)username)) {
            u = userManager.getUser(username);
        }
        if (u == null) {
            logger.debug("Unable to find user: {}", (Object)username);
            return false;
        }
        List<String> allowedGroups = GatewayConfig.getInstance().getStringList(groupsConfigName);
        if (allowedGroups.isEmpty()) {
            return true;
        }
        for (Group group : u.getGroups()) {
            for (String allowedGroup : allowedGroups) {
                if (!allowedGroup.equalsIgnoreCase(group.getDisplayName(Locale.US))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAccessibleByUser(@Nullable User user, Set<String> groupNames) {
        if (user == null) {
            return false;
        }
        for (Group group : user.getGroups()) {
            for (String allowedGroup : groupNames) {
                if (!allowedGroup.equalsIgnoreCase(group.getDisplayName(Locale.US))) continue;
                return true;
            }
        }
        return false;
    }

    public static IPropertySelectionModel createAllowedAmountsModel(String allowedAmountsConfigName, BasePaperCutPage page) {
        GatewayConfig conf = GatewayConfig.getInstance();
        List<Double> allowedAmountsTemp = conf.getDoubleList(allowedAmountsConfigName);
        return GatewayUtils.createAllowedAmountsModel(allowedAmountsTemp, page);
    }

    public static IPropertySelectionModel createAllowedAmountsModel(List<Double> amountsList, BasePaperCutPage page) {
        String[] formattedAmounts = new String[amountsList.size()];
        double[] allowedAmounts = new double[amountsList.size()];
        for (int i = 0; i < amountsList.size(); ++i) {
            allowedAmounts[i] = amountsList.get(i);
            formattedAmounts[i] = page.formatBalance(allowedAmounts[i]);
        }
        return new AllowedAmountsPropertySelectionModel(allowedAmounts, formattedAmounts, page.getLocale());
    }

    public static double getUserBalance(AccountManager accountManager, User user) {
        return accountManager.getTotalUserBalance(user);
    }

    public static void addCreditToUser(AccountManager accountManager, CreditSourceManager creditSourceManager, User user, double amount, String comment) {
        GatewayUtils.getPaymentAccount(accountManager, user).ifPresent(paymentAcct -> creditSourceManager.adjustBalance(paymentAcct, amount, AccountTransactionType.PAYMENT_GATEWAY, comment));
    }

    public static void addCreditToUserTxn(long accountId, CreditSourceManager creditSourceManager, double amount, String comment) {
        creditSourceManager.adjustBalanceTxn(accountId, amount, AccountTransactionType.PAYMENT_GATEWAY, comment);
    }

    private static Optional<Account> getPaymentAccount(AccountManager accountManager, User user) {
        return Optional.ofNullable(accountManager.getUserAccountForPaymentGateways(user));
    }

    public static Optional<Long> getPaymentAccountId(AccountManager accountManager, User user) {
        return GatewayUtils.getPaymentAccount(accountManager, user).map(Account::getId);
    }

    public static boolean isLicensed(LicenseManager licenseManager, String licenseKeyName) {
        Boolean b = _gatewayLicenseCache.get(licenseKeyName);
        if (b != null && b.booleanValue()) {
            return true;
        }
        LicenseManager.License l = licenseManager.getLicenceWithoutUserCountCheck();
        if (l.isTrialLicense()) {
            return true;
        }
        if (l.hasUnrestrictedExtras()) {
            logger.debug("Has unrestricted extras - allow");
            return true;
        }
        int licenseCount = l.getExtraValue(licenseKeyName, 0);
        if (licenseCount > 0) {
            _gatewayLicenseCache.put(licenseKeyName, true);
            return true;
        }
        return false;
    }

    public static String getNotLicensedUserMessage() {
        return "The payment gateway module is not licensed! Please contact your system administrator and request they purchase a license.";
    }

    public static boolean isIPAddressValid(String address, @Nullable String allowedIPMask) {
        if (StringUtils.isNotBlank((String)allowedIPMask) && !"*".equals(allowedIPMask)) {
            if (StringUtils.contains((String)allowedIPMask, (String)",")) {
                return IPAddressChecker.isAddressMatchInSet((String)address, (String[])StringUtils.split((String)allowedIPMask, (String)","));
            }
            return IPAddressChecker.isAddressInRange((String)allowedIPMask, (String)address);
        }
        return true;
    }

    public static String formatNumber(double value, int fractionDigits, @Nullable Locale locale, boolean groupingUsed) {
        NumberFormat nf;
        NumberFormat numberFormat = nf = locale == null ? NumberFormat.getInstance() : NumberFormat.getInstance(locale);
        if (fractionDigits >= 0) {
            nf.setMaximumFractionDigits(fractionDigits);
            nf.setMinimumFractionDigits(fractionDigits);
        }
        nf.setGroupingUsed(groupingUsed);
        return nf.format(value);
    }

    @Nullable
    public static Double parseDoubleExtended(String value) throws NumberFormatException {
        Object valstr = value.replace(",", ".");
        int dotpos = value.lastIndexOf(46);
        if (dotpos > 4) {
            String lhs = ((String)valstr).substring(0, dotpos);
            String rhs = ((String)valstr).substring(dotpos);
            lhs = lhs.replace(".", "");
            lhs = lhs.replace(" ", "");
            valstr = lhs + rhs;
        }
        Double val = null;
        if (StringUtils.isNotBlank((String)valstr)) {
            val = Double.parseDouble((String)valstr);
        }
        return val;
    }

    public static Map<String, String> getHttpServletRequestParamsAsMap(HttpServletRequest request) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(request.getParameterMap().size());
        ArrayList<String> parameterNames = Collections.list(request.getParameterNames());
        for (String paramName : parameterNames) {
            String paramValue = request.getParameter(paramName);
            params.put(paramName, paramValue);
        }
        return params;
    }

    public static int compareCredit(double a, double b) {
        if (a == b) {
            return 0;
        }
        double tolerance = 1.0E-5;
        double bHigh = b + 1.0E-5;
        if (a >= bHigh) {
            return 1;
        }
        double bLow = b - 1.0E-5;
        if (a <= bLow) {
            return -1;
        }
        return 0;
    }

    @Nullable
    public static TopupAccountOnDemandPlugin.TopupResponse performTopupDebit(TopupAccountOnDemandPlugin3 plugin, TopUpDebitFunction debitFunc, double topupAmount, double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails, String txnComment) {
        logger.debug("Performing topup on demand for: {}", (Object)plugin.getClass().getSimpleName());
        Double transactionAmount = debitFunc.performDebit(topupAmount);
        if (transactionAmount != null) {
            return new TopupAccountOnDemandPlugin.TopupResponse(transactionAmount.doubleValue(), debitFunc.getTxnComment().orElse(txnComment));
        }
        double newTopUpAmount = -1.0;
        boolean alreadyCompleted = Boolean.parseBoolean(usageDetails.get("already-completed"));
        if (alreadyCompleted) {
            logger.debug("Job already completed, check available credit.");
            TopupAccountOnDemandPlugin3.AvailableCredit ac = plugin.getAvailableCreditForTopUp(username, sharedAccount, accountCharged);
            if (ac != null && !ac.isUnlimited()) {
                logger.debug("Job already completed, and external balance has some balance: {}", (Object)ac.getAvailable());
                newTopUpAmount = ac.getAvailable();
            }
        }
        if (newTopUpAmount < 0.0 && topupAmount > amountRequired) {
            logger.debug("User has insufficient balance for the default transfer amount. Attempting to transfer the required amount only.");
            newTopUpAmount = amountRequired;
        }
        if (newTopUpAmount > 0.0 && newTopUpAmount < topupAmount) {
            logger.debug("User has insufficient balance for: {}. Attempting to transfer: {}", (Object)topupAmount, (Object)newTopUpAmount);
            Double transactionAmount2 = debitFunc.performDebit(newTopUpAmount);
            if (transactionAmount2 != null) {
                return new TopupAccountOnDemandPlugin.TopupResponse(transactionAmount2.doubleValue(), debitFunc.getTxnComment().orElse(txnComment));
            }
            logger.debug("Insufficient balance for: {}", (Object)newTopUpAmount);
        }
        logger.debug("Insufficient balance for topup");
        return null;
    }

    @Nullable
    public static String retainAlphanumericASCII(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("[^A-Za-z0-9]", "");
    }

    public static int roundDoubleDollarsToCents(double dollars) {
        double dollarsToRound = dollars - 1.0E-5;
        return (int)Math.ceil(dollarsToRound * 100.0);
    }

    private GatewayUtils() {
    }

    public static interface TopUpDebitFunction {
        @Nullable
        public Double performDebit(double var1);

        default public Optional<String> getTxnComment() {
            return Optional.empty();
        }
    }

    public static final class LogHelper {
        private static final String FQCN = LogHelper.class.getName() + ".";

        public static void logInfo(Logger log, String msg) {
            LogHelper.logInfo(log, msg, null);
        }

        public static void logInfo(Logger log, String template, Object ... args) {
            String msg = String.format(template, args);
            LogHelper.logInfo(log, msg);
        }

        public static void logInfo(Logger log, String msg, @Nullable ApplicationLogManager appLog) {
            if (log.getClass().getName().equals(GatewayUtils.CLASS_NAME_SLF4J_LOG4JLOGGER)) {
                ((Log4jLogger)log).log(null, FQCN, 20, msg, null, null);
            } else {
                log.info(msg);
            }
            LogHelper.getEventLog().logEvent(msg);
        }

        public static void logInfo(Logger log, String template, @Nullable ApplicationLogManager appLog, Object ... args) {
            String msg = String.format(template, args);
            LogHelper.logInfo(log, msg, appLog);
        }

        public static void logDebug(Logger log, String msg) {
            if (log.isDebugEnabled()) {
                if (log.getClass().getName().equals(GatewayUtils.CLASS_NAME_SLF4J_LOG4JLOGGER)) {
                    ((Log4jLogger)log).log(null, FQCN, 10, msg, null, null);
                } else {
                    log.debug(msg);
                }
                LogHelper.getEventLog().logEvent("DEBUG: " + msg);
            }
        }

        public static void logDebug(Logger log, String template, Object ... args) {
            if (log.isDebugEnabled()) {
                String msg = String.format(template, args);
                LogHelper.logDebug(log, msg);
            }
        }

        public static void logWarn(Logger log, String msg) {
            LogHelper.logWarn(log, msg, null, null);
        }

        public static void logWarn(Logger log, String template, Object ... args) {
            String msg = String.format(template, args);
            LogHelper.logWarn(log, msg);
        }

        public static void logWarn(Logger log, String msg, @Nullable Throwable t, @Nullable ApplicationLogManager appLog) {
            if (log.getClass().getName().equals(GatewayUtils.CLASS_NAME_SLF4J_LOG4JLOGGER)) {
                ((Log4jLogger)log).log(null, FQCN, 30, msg, null, t);
            } else {
                log.warn(msg, t);
            }
            LogHelper.getEventLog().logEvent("WARN: " + msg);
            if (appLog != null) {
                appLog.logRaw(null, ApplicationLogLevelEnum.WARNING, "Payment gateway: " + msg);
            }
        }

        public static void logWarn(Logger log, String template, @Nullable Throwable t, @Nullable ApplicationLogManager appLog, Object ... args) {
            String msg = String.format(template, args);
            LogHelper.logWarn(log, msg, t, appLog);
        }

        public static void logError(Logger log, String msg) {
            LogHelper.logError(log, msg, null, null);
        }

        public static void logError(Logger log, String template, Object ... args) {
            String msg = String.format(template, args);
            LogHelper.logError(log, msg);
        }

        public static void logError(Logger log, String msg, @Nullable Throwable t, @Nullable ApplicationLogManager appLog) {
            if (log.getClass().getName().equals(GatewayUtils.CLASS_NAME_SLF4J_LOG4JLOGGER)) {
                ((Log4jLogger)log).log(null, FQCN, 40, msg, null, t);
            } else {
                log.error(msg, t);
            }
            LogHelper.getEventLog().logEvent("ERROR: " + msg);
            if (appLog != null) {
                appLog.logRaw(null, ApplicationLogLevelEnum.ERROR, "Payment gateway: " + msg);
            }
        }

        public static void logError(Logger log, String template, @Nullable Throwable t, @Nullable ApplicationLogManager appLog, Object ... args) {
            String msg = String.format(template, args);
            LogHelper.logError(log, msg, t, appLog);
        }

        private static EventLog getEventLog() {
            return EventLog.getInstance();
        }

        private LogHelper() {
        }
    }

    public static final class GroupIdMap {
        private final Map<String, String> _idmap = new HashMap<String, String>();

        public GroupIdMap(String mapConfig) {
            for (String pair : StringUtils.split((String)mapConfig, (char)',')) {
                if (StringUtils.isBlank((String)pair)) continue;
                String group = StringUtils.substringBefore((String)pair, (String)":").trim();
                String id = StringUtils.substringAfter((String)pair, (String)":").trim();
                if (id.isEmpty()) continue;
                this._idmap.put(group, id);
            }
        }

        @Nullable
        public String lookupIdForUser(User user) {
            String id = null;
            for (Group grp : user.getGroups()) {
                String grpid = this.lookupIdForGroup(grp);
                if (!StringUtils.isNotBlank((String)grpid)) continue;
                if (id == null) {
                    id = grpid;
                    continue;
                }
                id = null;
                break;
            }
            return id;
        }

        @Nullable
        public String lookupIdForGroup(Group group) {
            return this._idmap.get(group.getDisplayName());
        }
    }
}

