/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.PaymentGatewayRequestLogMessageBuilder;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.io.IOUtils;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class MonerisPlugin
implements UserLinkPlugin,
WebServerPlugin,
SpringContextPlugin,
EnableablePlugin {
    protected static final Logger logger = LoggerFactory.getLogger(MonerisPlugin.class);
    public static final String RETURN_URL_PATH = "/rpc/gateway/moneris/";
    public static final String POSTBACK_URL_PATH = "/rpc/gateway/moneris/*";
    private static final String CONFIG_PREFIX = "moneris.";
    public static final String CONFIG_ENABLED = "moneris.enabled";
    public static final String CONFIG_STORE_ID = "moneris.store-id";
    public static final String CONFIG_LANG = "moneris.lang";
    public static final String DEFAULT_LANG = "en-ca";
    @AESProperty
    public static final String CONFIG_PAY_PAGE_TOKEN = "moneris.pay-page-token";
    public static final String CONFIG_PAGE_TITLE = "moneris.page-title";
    public static final String CONFIG_PAGE_HEADING = "moneris.page-heading";
    public static final String CONFIG_SUCCESS_MESSAGE = "moneris.success-message";
    public static final String CONFIG_DECLINED_MESSAGE = "moneris.declined-message";
    public static final String CONFIG_RECEIPT_PAGE_CURRENCY = "moneris.receipt-page-currency";
    public static final String CONFIG_ALLOWED_GROUPS = "moneris.allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "moneris.allowed-amounts";
    public static final String CONFIG_PAYMENT_PAGE_URL = "moneris.payment-page-url";
    public static final String CONFIG_VERIFICATION_PAGE_URL = "moneris.verification-page-url";
    private static final int READ_TIMEOUT_MS = 15000;
    private static final List<String> PAGES = List.of("ExtnMoneris");
    private static final String VERIFY_TRANSACTION_PAGE = "/verifyTxn.php";
    private ApplicationContext _applicationContext;
    private final Map<String, MonerisOrder> _monerisOrders = Collections.synchronizedMap(new HashMap());

    public boolean isPluginEnabled() {
        Boolean enabled = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-moneris");
    }

    public String getIsConfigured() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String errorSuffix = "  Please check the payment gateway config file.";
        if (StringUtils.isBlank((String)conf.getString(CONFIG_STORE_ID))) {
            EventLog.getInstance().logEvent("Hosted Paypage ID not provided.");
            return "Hosted Paypage ID not provided." + errorSuffix;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_PAY_PAGE_TOKEN))) {
            EventLog.getInstance().logEvent("Hosted Paypage Token not provided.");
            return "Hosted Paypage Token not provided." + errorSuffix;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_ALLOWED_AMOUNTS))) {
            EventLog.getInstance().logEvent("Must specify at least one allowed payment amount.");
            return "Must specify at least one allowed payment amount." + errorSuffix;
        }
        if (!this.validateURLFromConfig(CONFIG_PAYMENT_PAGE_URL)) {
            return "Invalid payment page URL." + errorSuffix;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("moneris.payment-page-url={}", (Object)conf.getString(CONFIG_PAYMENT_PAGE_URL));
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_VERIFICATION_PAGE_URL)) && !this.validateURL(this.getPayment2VerificationURL()) && !this.validateURLFromConfig(CONFIG_VERIFICATION_PAGE_URL)) {
            return "Invalid verification page URL." + errorSuffix;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(conf.getString(CONFIG_VERIFICATION_PAGE_URL) != null ? "moneris.verification-page-url=" + conf.getString(CONFIG_VERIFICATION_PAGE_URL) : "Generated txnurl=" + this.getPayment2VerificationURL());
        }
        return null;
    }

    private String getPayment2VerificationURL() {
        return GatewayConfig.getInstance().getString(CONFIG_PAYMENT_PAGE_URL).replaceAll("(/\\w+\\.php)$", VERIFY_TRANSACTION_PAGE);
    }

    private boolean validateURL(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException murle) {
            EventLog.getInstance().logEvent("Invalid page URL: " + url + ".");
            return false;
        }
        return true;
    }

    private boolean validateURLFromConfig(String key) {
        URL pageURL = null;
        try {
            pageURL = GatewayConfig.getInstance().getURL(key);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (pageURL == null) {
            EventLog.getInstance().logEvent("Invalid page URL: " + GatewayConfig.getInstance().getString(key) + ".");
            return false;
        }
        return true;
    }

    public boolean isAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager());
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_TITLE));
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        if (!this.isPluginEnabled()) {
            return;
        }
        server.addServlet(MonerisCallbackServlet.class, POSTBACK_URL_PATH);
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    public void verifyTransactionAfterUserReturn(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            TransactionVerificationResponse tvr;
            String orderId = request.getParameter("response_order_id");
            String msg = "Moneris server returned user after payment processing, order id: " + orderId;
            logger.info(msg);
            EventLog.getInstance().logEvent(msg);
            MonerisOrder mo = this._monerisOrders.remove(orderId);
            if (mo == null) {
                String msg2 = "Moneris callback URL accessed with the invalid order id " + orderId + ". Redirecting user to the login page. Order will not be finalized.";
                logger.error(msg2);
                EventLog.getInstance().logEvent(msg2);
                response.sendRedirect("/");
                return;
            }
            String status = request.getParameter("status");
            if (StringUtils.isBlank((String)status)) {
                String msg3 = "Moneris did not include a response status for order id " + orderId + ". Displaying error message. Order will not be finalized.";
                logger.error(msg3);
                EventLog.getInstance().logEvent(msg3);
                String redirectURL = mo.getReturnRedirectURL() + "&response=error";
                response.sendRedirect(redirectURL);
                return;
            }
            if (!status.equals("approved")) {
                String msg4 = "Moneris indicated that order id " + orderId + " was not approved (" + status + "). Displaying declined message. Order will not be finalized.";
                logger.error(msg4);
                EventLog.getInstance().logEvent(msg4);
                String redirectURL = mo.getReturnRedirectURL() + "&response=decline";
                response.sendRedirect(redirectURL);
                return;
            }
            String transactionKey = request.getParameter("transactionKey");
            if (StringUtils.isBlank((String)transactionKey)) {
                String msg5 = "Moneris callback URL accessed without a transaction key. Ensure that Transaction Verification has been enabled as per the setup notes. Order id: " + orderId + ". Redirecting user to the login page. Order will not be finalized.";
                logger.error(msg5);
                EventLog.getInstance().logEvent(msg5);
                response.sendRedirect("/");
                return;
            }
            String msg6 = "Finalizing transaction for order id: " + orderId + ", transaction key: " + transactionKey;
            logger.info(msg6);
            EventLog.getInstance().logEvent(msg6);
            String responseString = this.sendTransactionVerification(transactionKey);
            try {
                tvr = new TransactionVerificationResponse(responseString);
            }
            catch (Exception e) {
                String msg7 = "Unable to parse Moneris' transaction verification response, order id: " + orderId + ". Order may have been finalized and requires further investigation. responseString=" + responseString;
                logger.error(msg7);
                EventLog.getInstance().logEvent(msg7);
                String redirectURL = mo.getReturnRedirectURL() + "&response=error";
                response.sendRedirect(redirectURL);
                return;
            }
            if (tvr.isApproved()) {
                CreditCardGatewayPlugin.OrderResponse orderResponse = this.getCreditCardGatewayPlugin().confirmOrder(orderId, tvr.getAmount());
                if (orderResponse.isSuccess()) {
                    StringBuilder redirectURL = new StringBuilder();
                    redirectURL.append(mo.getReturnRedirectURL());
                    redirectURL.append("&response=approve");
                    redirectURL.append("&transaction-type=").append(request.getParameter("trans_name"));
                    redirectURL.append("&timestamp=").append(request.getParameter("date_stamp")).append(' ').append(request.getParameter("time_stamp"));
                    redirectURL.append("&transaction-amount=").append(tvr.getAmount());
                    redirectURL.append("&order-id=").append(tvr.getOrderId());
                    redirectURL.append("&cardholder-name=").append(request.getParameter("cardholder"));
                    redirectURL.append("&response-code=").append(tvr.getResponseCode());
                    redirectURL.append("&response-message=").append(tvr.getResponseMessage());
                    redirectURL.append("&bank-reference-number=").append(request.getParameter("bank_transaction_id"));
                    redirectURL.append("&bank-auth-code=").append(request.getParameter("bank_approval_code"));
                    redirectURL.append("&iso-code=").append(request.getParameter("iso_code"));
                    if (request.getParameter("ISSNAME") != null) {
                        redirectURL.append("&interac-card-issuer-name=").append(request.getParameter("ISSNAME"));
                    }
                    if (request.getParameter("INVOICE") != null) {
                        redirectURL.append("&interac-invoice-number=").append(request.getParameter("INVOICE"));
                    }
                    if (request.getParameter("ISSCONF") != null) {
                        redirectURL.append("&interac-issuer-confirmation=").append(request.getParameter("ISSCONF"));
                    }
                    String msg8 = "Moneris server returned user after payment processing, order id: " + orderId + ", approved: true, response code: " + tvr.getResponseCode() + ", response message: \"" + tvr.getResponseMessage() + "\". Order confirmed. Redirecting user to: " + String.valueOf(redirectURL);
                    logger.debug(msg8);
                    EventLog.getInstance().logEvent(msg8);
                    response.sendRedirect(redirectURL.toString());
                } else {
                    String errorMsg = "Could not confirm order " + orderId + ", message: " + orderResponse.getMessage() + ". Order was finalized but user has not received credit. Manual reconciliation is required.";
                    logger.error(errorMsg);
                    EventLog.getInstance().logEvent(errorMsg);
                    String redirectURL = mo.getReturnRedirectURL() + "&response=error";
                    response.sendRedirect(redirectURL);
                }
            } else {
                String redirectURL = mo.getReturnRedirectURL() + "&response=decline";
                String msg9 = "Moneris server returned user after payment processing, order id: " + orderId + ", approved: false, response code: " + tvr.getResponseCode() + ", response message: \"" + tvr.getResponseMessage() + "\". Order canceled. Redirecting user to: " + redirectURL;
                logger.debug(msg9);
                EventLog.getInstance().logEvent(msg9);
                response.sendRedirect(redirectURL);
            }
        }
        catch (Exception e) {
            String errorMsg = "Unexpected error processing transaction: " + e.getMessage() + ". Please send this log to support for assistance.";
            logger.error(errorMsg, (Throwable)e);
            EventLog.getInstance().logEvent(errorMsg);
            response.sendRedirect("/");
        }
    }

    public void cancelTransactionAfterReturn(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String orderId = request.getParameter("order_id");
        MonerisOrder mo = null;
        if (StringUtils.isNotBlank((String)orderId)) {
            mo = this._monerisOrders.remove(orderId);
        }
        if (mo == null) {
            String msg = "Moneris callback URL accessed with the invalid order id " + orderId + ".  Redirecting user to the login page.";
            logger.error(msg);
            EventLog.getInstance().logEvent(msg);
            response.sendRedirect("/");
        } else {
            String redirectURL = mo.getReturnRedirectURL() + "&response=cancel";
            String msg = "Moneris server returned user after payment processing, user canceled transaction. Order id: " + request.getParameter("order_id") + ". Redirecting user to: " + redirectURL;
            logger.debug(msg);
            EventLog.getInstance().logEvent(msg);
            response.sendRedirect(redirectURL);
        }
    }

    private String sendTransactionVerification(String transactionKey) throws IOException {
        String msg;
        StringBuilder response = new StringBuilder();
        GatewayConfig conf = GatewayConfig.getInstance();
        String data = "ps_store_id=" + conf.getString(CONFIG_STORE_ID) + "&hpp_key=" + conf.getString(CONFIG_PAY_PAGE_TOKEN) + "&transactionKey=" + transactionKey;
        URL txnurl = this.buildVerifyTxnURL();
        if (logger.isDebugEnabled()) {
            logger.debug("Sending transaction validation request to Monaris: {}, using txnurl={}", (Object)data, (Object)txnurl);
        }
        URLConnection urlConn = txnurl.openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setReadTimeout(15000);
        try {
            DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
            printout.writeBytes(data);
            IOUtils.closeQuietly((OutputStream)printout);
            if (logger.isDebugEnabled()) {
                logger.debug("Request was sent to {}", (Object)txnurl);
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error received for request on verify transaction key: {}", (Object)transactionKey, (Object)e);
            }
            msg = "Error finalizing transaction with Moneris, transaction key: " + transactionKey + ". Order should not have been finalized but may require investigation.";
            logger.error(msg);
            EventLog.getInstance().logEvent(msg);
        }
        try {
            String line;
            InputStream is = urlConn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error received for reading response for verify transaction key: {}", (Object)transactionKey, (Object)e);
            }
            msg = "Error reading transaction finalization response from Moneris, transaction key: " + transactionKey + ". Order may have been finalized and requires further investigation.";
            logger.error(msg);
            EventLog.getInstance().logEvent(msg);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Received Moneris transaction validation response string: {}", (Object)response);
        }
        return response.toString();
    }

    private URL buildVerifyTxnURL() throws MalformedURLException {
        URL txnurl = GatewayConfig.getInstance().getURL(CONFIG_VERIFICATION_PAGE_URL);
        if (txnurl == null) {
            txnurl = new URL(this.getPayment2VerificationURL());
        }
        return txnurl;
    }

    public CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)PluginManager.getInstance().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    public String createNewOrder(String username, double amount, String returnRedirectURL) {
        String orderId = this.getCreditCardGatewayPlugin().createNewOrder(username, amount);
        MonerisOrder mo = new MonerisOrder(returnRedirectURL);
        this._monerisOrders.put(orderId, mo);
        return orderId;
    }

    public String getReceiptPageCurrency() {
        return this.getGatewayConfig().getString(CONFIG_RECEIPT_PAGE_CURRENCY);
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    private static List<String> getParametersToLog() {
        return List.of("response_order_id", "status", "transactionKey", "cancelTXN", "order_id");
    }

    public static void main(String[] args) {
        String url1 = "https://esqa.moneris.com/HPPDP/index.php";
        String url2 = url1.replaceAll("(/\\w+\\.php)$", VERIFY_TRANSACTION_PAGE);
        System.out.println(url2);
    }

    public static class MonerisCallbackServlet
    extends HttpServlet {
        private final PaymentGatewayRequestLogMessageBuilder logMessageBuilder = new PaymentGatewayRequestLogMessageBuilder("Callback servlet").withSelectedParameters(MonerisPlugin.getParametersToLog());

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            this.getMonerisPlugin().verifyTransactionAfterUserReturn(request, response);
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            if (StringUtils.isNotBlank((String)request.getParameter("cancelTXN"))) {
                this.getMonerisPlugin().cancelTransactionAfterReturn(request, response);
            } else {
                response.getWriter().write("<html><body><h1>The Moneris eSELECT Plus Postback URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. that the Moneris server has access)</p></body></html>");
            }
        }

        private MonerisPlugin getMonerisPlugin() {
            return (MonerisPlugin)PluginManager.getInstance().getPluginByClass(MonerisPlugin.class);
        }

        private void debugLogRequest(HttpServletRequest request) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.buildLogMessageFromRequest(request));
            }
        }

        String buildLogMessageFromRequest(HttpServletRequest request) {
            return this.logMessageBuilder.buildFrom(request);
        }
    }

    public static class MonerisOrder {
        private final String _returnRedirectURL;

        public MonerisOrder(String returnRedirectURL) {
            this._returnRedirectURL = returnRedirectURL;
        }

        public String getReturnRedirectURL() {
            return this._returnRedirectURL;
        }
    }

    private static class TransactionVerificationResponse {
        private static final Pattern ORDER_ID_PATTERN = Pattern.compile(".*order_id\\s?=?\\s?([^<]*).*");
        private static final Pattern AMOUNT_PATTERN = Pattern.compile(".*amount\\s?=?\\s?([^<]*).*");
        private static final Pattern RESPONSE_CODE_PATTERN = Pattern.compile(".*response_code\\s?=?\\s?([^<]*).*");
        private static final Pattern RESPONSE_MESSAGE_PATTERN = Pattern.compile(".*status\\s?=?\\s?([^<]*).*");
        private final String _orderId;
        private final double _amount;
        private final String _responseCode;
        private final String _responseMessage;

        public TransactionVerificationResponse(String responseString) {
            Matcher m = ORDER_ID_PATTERN.matcher(responseString);
            if (!m.matches() || m.groupCount() < 1) {
                throw new IllegalArgumentException("Order id could not be found in response string");
            }
            this._orderId = m.group(1);
            m = AMOUNT_PATTERN.matcher(responseString);
            if (!m.matches() || m.groupCount() < 1) {
                throw new IllegalArgumentException("Amount could not be found in response string");
            }
            try {
                this._amount = Double.parseDouble(m.group(1));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Could not read amount from response string: " + m.group(1));
            }
            m = RESPONSE_CODE_PATTERN.matcher(responseString);
            if (!m.matches() || m.groupCount() < 1) {
                throw new IllegalArgumentException("Response code could not be found in response string");
            }
            this._responseCode = m.group(1);
            m = RESPONSE_MESSAGE_PATTERN.matcher(responseString);
            if (!m.matches() || m.groupCount() < 1) {
                throw new IllegalArgumentException("Response message could not be found in response string");
            }
            this._responseMessage = m.group(1);
        }

        public boolean isApproved() {
            try {
                int responseCode = Integer.parseInt(this.getResponseCode());
                return responseCode < 50;
            }
            catch (Exception e) {
                return false;
            }
        }

        public String getOrderId() {
            return this._orderId;
        }

        public double getAmount() {
            return this._amount;
        }

        public String getResponseCode() {
            return this._responseCode;
        }

        public String getResponseMessage() {
            return this._responseMessage;
        }
    }
}

