/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.ext.paymentgateway.ExternalCreditSourceProvider;
import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.NumberUtils;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyStudentAccountProvider
implements ExternalCreditSourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(MyStudentAccountProvider.class);
    private static final String FIELD_SERVER_NAME = "my-student-account.server-name";
    private static final String FIELD_SERVER_PORT = "my-student-account.server-port";
    static final String FIELD_SERVER_PASSWD = "my-student-account.server-password";
    private static final String DEFAULT_MESSAGE = "Transfer to PaperCut";
    private Properties _config;

    @Override
    public String getSourceName() {
        return "My Student Account";
    }

    @Override
    public void setConfig(Properties properties) {
        this._config = properties;
    }

    @Override
    public Double availableCredit(String username, String fullName, String cardNumber) {
        XmlRpcClient xmlRpcClient = null;
        Object result = null;
        try {
            String serverName = this._config.getProperty(FIELD_SERVER_NAME);
            int serverPort = Integer.parseInt(this._config.getProperty(FIELD_SERVER_PORT));
            String serverURL = new URL("http", serverName, serverPort, "/").toString();
            xmlRpcClient = new XmlRpcClient(serverURL);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid server name (my-student-account.server-name) or server port (my-student-account.server-port). Please check the configuration.");
        }
        try {
            String password = "";
            if (this._config.getProperty(FIELD_SERVER_PASSWD) != null) {
                password = this._config.getProperty(FIELD_SERVER_PASSWD);
            }
            if (StringUtils.isBlank((String)cardNumber)) {
                logger.error("Card Number is blank");
                return null;
            }
            Vector<String> params1 = new Vector<String>();
            params1.add(password);
            params1.add(cardNumber);
            result = xmlRpcClient.execute("availableFunds", params1);
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)result;
            }
        }
        catch (Exception e) {
            logger.error("Unable to call XML-RPC availableFunds.", (Throwable)e);
            return null;
        }
        if (!(result instanceof String)) {
            logger.error("MSA XML-RCP call returned invalid data type");
            return null;
        }
        int r = 0;
        try {
            r = Integer.parseInt((String)result);
        }
        catch (Exception e) {
            logger.error("MSA server returned unexpected response/error: {}", result);
            return null;
        }
        Double decimalValue = this.fractionToDouble(r);
        logger.debug("MSA server returned available credit of : {}", (Object)decimalValue);
        return decimalValue;
    }

    private double fractionToDouble(int fraction) {
        return (double)fraction / 100.0;
    }

    @Override
    public ExternalCreditSourceProvider.RequestResponse withdrawCredit(String username, String fullName, String cardNumber, double amount, String transactionComment) {
        XmlRpcClient xmlRpcClient;
        Object result = null;
        try {
            String serverName = this._config.getProperty(FIELD_SERVER_NAME);
            int serverPort = Integer.parseInt(this._config.getProperty(FIELD_SERVER_PORT));
            String serverURL = new URL("http", serverName, serverPort, "/").toString();
            xmlRpcClient = new XmlRpcClient(serverURL);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid server name (my-student-account.server-name) or server port (my-student-account.server-port). Please check the configuration.");
        }
        try {
            String password = "";
            if (this._config.getProperty(FIELD_SERVER_PASSWD) != null) {
                password = this._config.getProperty(FIELD_SERVER_PASSWD);
            }
            if (StringUtils.isBlank((String)cardNumber)) {
                return new ExternalCreditSourceProvider.RequestResponse(false, "Invalid card number. Ensure the card number field is populated in " + ApplicationInfo.getInstance().getApplicationName());
            }
            Vector<Object> params = new Vector<Object>();
            params.add(password);
            params.add(cardNumber);
            params.add(this.amountToInt(amount));
            params.add(DEFAULT_MESSAGE);
            result = xmlRpcClient.execute("withdrawFunds", params);
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)result;
            }
        }
        catch (Exception e) {
            logger.error("Unable to call XML-RPC withdrawFunds.", (Throwable)e);
            Object msg = e.getMessage();
            if (e instanceof UnknownHostException) {
                msg = "Unknown host: " + e.getMessage();
            } else if (e instanceof ConnectException) {
                msg = "Unable to connect to: " + xmlRpcClient.getURL().getHost();
            }
            return new ExternalCreditSourceProvider.RequestResponse(false, (String)msg);
        }
        if (!(result instanceof String)) {
            logger.error("Server returned unexpected result: {}", result);
            return new ExternalCreditSourceProvider.RequestResponse(false, "Unexpected result from server");
        }
        if (!((String)result).startsWith("OK")) {
            logger.error("Server returned non-OK result: {}", result);
            return new ExternalCreditSourceProvider.RequestResponse(false, "Error: " + String.valueOf(result));
        }
        return new ExternalCreditSourceProvider.RequestResponse(true, "");
    }

    private int amountToInt(double amount) {
        amount *= 100.0;
        amount = NumberUtils.round((double)amount, (int)0);
        return (int)amount;
    }

    public static void main(String[] args) {
        Properties p = new Properties();
        p.setProperty(FIELD_SERVER_NAME, "localhost");
        p.setProperty(FIELD_SERVER_PORT, "4444");
        p.setProperty(FIELD_SERVER_PASSWD, "password");
        MyStudentAccountProvider t = new MyStudentAccountProvider();
        t.setConfig(p);
        Double result = null;
        result = t.availableCredit("priyanka", "priyanka Mittal", "13234");
        if (result != null) {
            System.out.println("Result is:" + result);
        } else {
            System.out.println("NO RESULT");
        }
    }
}

