/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public final class ParameterMapValuesStringBuilder {
    private final List<String> keyList = new ArrayList<String>();
    private Map<String, String> parameterMap = Collections.emptyMap();

    public ParameterMapValuesStringBuilder(Map<String, ?> parameterMap) {
        this.validate(parameterMap);
        this.initialise(parameterMap);
    }

    private void validate(Map<String, ?> parameterMap) {
        if (parameterMap == null) {
            throw new IllegalArgumentException("Parameter map cannot be null");
        }
    }

    private void initialise(Map<String, ?> parameterMap) {
        this.parameterMap = new HashMap<String, String>(parameterMap.entrySet().stream().collect(Collectors.toMap(e -> Optional.of(e).map(Map.Entry::getKey).orElse("null"), e -> new ParameterValue((Map.Entry<String, ?>)e).toString())));
    }

    public ParameterMapValuesStringBuilder add(String parameterKey) {
        this.keyList.add(String.valueOf(parameterKey));
        return this;
    }

    public String build() {
        ArrayList values = new ArrayList();
        this.keyList.forEach(key -> {
            if (this.parameterMap.containsKey(key)) {
                values.add(key + ": " + this.parameterMap.get(key));
            }
        });
        Collections.sort(values);
        return "{" + StringUtils.join((Object[])values.toArray(), (String)", ").trim() + "}";
    }

    ParameterMapValuesStringBuilder withAllContents() {
        this.parameterMap.keySet().forEach(this::add);
        return this;
    }

    private static class ParameterValue {
        private final String value;

        ParameterValue(Map.Entry<String, ?> mapEntry) {
            Object value = Optional.of(mapEntry).map(Map.Entry::getValue).orElse(null);
            this.value = value != null && value.getClass().isArray() ? StringUtils.join((Object[])Arrays.stream((Object[])value).toArray(Object[]::new), (String)", ") : String.valueOf(value);
        }

        public String toString() {
            return this.value;
        }
    }
}

