/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.components.BaseComponent;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PaymentGatewayForm
extends BaseComponent {
    private UserManager userManager;
    private AccountManager accountManager;

    public abstract User getUser();

    public double getUserBalance() {
        User user = this.userManager.getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.accountManager, user);
    }

    public String getUserAndFullName() {
        StringBuilder s = new StringBuilder();
        s.append(this.getUser().getUserName());
        if (StringUtils.isNotBlank((String)this.getUser().getFullName())) {
            s.append(" (");
            s.append(this.getUser().getFullName());
            s.append(")");
        }
        return s.toString();
    }

    @Autowired
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Autowired
    public void setAccountManager(AccountManager accountManager) {
        this.accountManager = accountManager;
    }
}

