/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.ext.paymentgateway.ParameterMapValuesStringBuilder;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

public final class PaymentGatewayRequestLogMessageBuilder {
    private final String name;
    private List<String> parameterList;

    public PaymentGatewayRequestLogMessageBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        this.parameterList = new ArrayList<String>();
    }

    public PaymentGatewayRequestLogMessageBuilder withSelectedParameters(List<String> parameterList) {
        this.parameterList = parameterList != null ? new ArrayList<String>(parameterList) : List.of();
        return this;
    }

    public String buildFrom(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        ParameterMapValuesStringBuilder stringBuilder = new ParameterMapValuesStringBuilder(request.getParameterMap());
        this.parameterList.forEach(stringBuilder::add);
        return this.name + " accessed via " + request.getMethod() + ", URL: " + String.valueOf(request.getRequestURL()) + ", from: " + request.getRemoteAddr() + ", params: " + stringBuilder.build();
    }
}

