/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class RollingLog {
    private final RollPeriod _period;
    private final File _targetDir;
    private final String _prefix;
    private final String _suffix;

    public RollingLog(File targetDir, RollPeriod period, String prefix, String suffix) {
        if (StringUtils.isBlank((String)prefix) || StringUtils.isBlank((String)suffix) || period == null || targetDir == null) {
            throw new IllegalArgumentException("Invalid arguments to RollingLog");
        }
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        this._period = period;
        this._targetDir = targetDir;
        this._prefix = prefix;
        this._suffix = suffix;
    }

    public synchronized void writeLine(String line) {
        File logFile = this.getCurrentLog();
        BufferedWriter logWriter = null;
        try {
            logWriter = new BufferedWriter(new FileWriter(logFile, true));
            logWriter.write(line);
            logWriter.newLine();
        }
        catch (IOException e) {
            try {
                throw new ApplicationException("Unable to write to log file: " + logFile.getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(logWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)logWriter);
    }

    private synchronized File getCurrentLog() {
        Object fileName = this._prefix;
        Date now = new Date();
        switch (this._period.ordinal()) {
            case 0: {
                fileName = (String)fileName + new SimpleDateFormat("yyyy_MM_dd", Locale.US).format(now);
                break;
            }
            case 1: {
                Calendar cal = Calendar.getInstance();
                cal.add(5, -cal.get(7));
                Date firstDayOfWeek = cal.getTime();
                fileName = (String)fileName + new SimpleDateFormat("yyyy_MM_dd", Locale.US).format(firstDayOfWeek);
                break;
            }
            case 2: {
                fileName = (String)fileName + new SimpleDateFormat("yyyy_MM", Locale.US).format(now);
                break;
            }
            case 3: {
                fileName = (String)fileName + "all";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected period format");
            }
        }
        return new File(this._targetDir, (String)fileName + this._suffix);
    }

    public static enum RollPeriod {
        Daily,
        Weekly,
        Monthly,
        Never;

    }
}

