/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.CountryRepository;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ThreeDSecureFormData;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.components.BaseComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ThreeDSecurePaymentGatewayForm
extends BaseComponent {
    private UserManager userManager;
    private AccountManager accountManager;

    public abstract User getUser();

    public abstract ThreeDSecureFormData getFormData();

    public double getUserBalance() {
        User user = this.userManager.getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.accountManager, user);
    }

    public IPropertySelectionModel getCountries() {
        return CountryRepository.getInstance().getCountrySelectionModel();
    }

    public boolean containsElement(String element) {
        if (this.getFormData().getFormElements() == null) {
            return false;
        }
        return this.getFormData().getFormElements().contains(element);
    }

    public String getUserAndFullName() {
        StringBuilder s = new StringBuilder();
        s.append(this.getUser().getUserName());
        if (StringUtils.isNotBlank((String)this.getUser().getFullName())) {
            s.append(" (");
            s.append(this.getUser().getFullName());
            s.append(")");
        }
        return s.toString();
    }

    @Autowired
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Autowired
    public void setAccountManager(AccountManager accountManager) {
        this.accountManager = accountManager;
    }
}

