/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.domain.Group;
import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.RollingLog;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.server.ServerConfig;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.Formatter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class TransactionToFilePlugin
implements UserLinkPlugin,
SpringContextPlugin,
EnableablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(TransactionToFilePlugin.class);
    private static final String CONFIG_PREFIX = "transaction-to-file.";
    private static final String CONFIG_ENABLED = "transaction-to-file.enabled";
    private static final String CONFIG_ALLOWED_GROUPS = "transaction-to-file.allowed-groups";
    private static final String CONFIG_FILE_TARGET_DIR = "transaction-to-file.target-directory";
    private static final String CONFIG_ROTATE_PERIOD = "transaction-to-file.rotation-period";
    private static final String CONFIG_PAGE_TRANSACTION_COMMENT = "transaction-to-file.transaction-comment";
    public static final String CONFIG_PAGE_TITLE = "transaction-to-file.page-title";
    public static final String CONFIG_PAGE_HEADING = "transaction-to-file.page-heading";
    public static final String CONFIG_ALLOWED_AMOUNTS = "transaction-to-file.allowed-amounts";
    public static final String CONFIG_USAGE_POLICY = "transaction-to-file.usage-policy";
    private static final List<String> PAGES;
    private static final SimpleDateFormat DATE_TIME_FORMAT;
    private ApplicationContext _ctx = null;

    public boolean isPluginEnabled() {
        Boolean enabled = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this._ctx.getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-txn-file");
    }

    public boolean userHasAccess(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        User u = null;
        if (username != null) {
            u = this.getUserManager().getUser(username);
        }
        if (u == null) {
            logger.debug("Unable to find user: {}", (Object)username);
            return false;
        }
        GatewayConfig conf = GatewayConfig.getInstance();
        List<String> allowedGroups = conf.getStringList(CONFIG_ALLOWED_GROUPS);
        if (allowedGroups.isEmpty()) {
            return true;
        }
        List userGroups = u.getGroups();
        for (Group group : userGroups) {
            for (String allowedGroup : allowedGroups) {
                if (!allowedGroup.equalsIgnoreCase(group.getGroupName())) continue;
                return true;
            }
        }
        return false;
    }

    public TransactionResponse performTransaction(String username, double amount) {
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            return new TransactionResponse(false, "Unknown user " + username);
        }
        String transactionComment = "Funds added from external system.";
        String customComment = GatewayConfig.getInstance().getString(CONFIG_PAGE_TRANSACTION_COMMENT);
        if (StringUtils.isNotBlank((String)customComment)) {
            transactionComment = customComment;
        }
        try {
            RollingLog log = new RollingLog(this.getTargetDir(), this.getRollPeriod(), "transactions-", ".csv");
            String sb = DATE_TIME_FORMAT.format(new Date()) + ",\"" + StringUtils.trimToEmpty((String)user.getUserName()) + "\"," + Formatter.formatNumber((double)amount, (int)2, null) + ",\"" + StringUtils.trimToEmpty((String)user.getFullName()) + "\",\"" + StringUtils.trimToEmpty((String)user.getCardNumber()) + "\"";
            log.writeLine(sb);
            GatewayUtils.addCreditToUser(this.getAccountManager(), this.getCreditSourceManager(), user, amount, transactionComment);
        }
        catch (Exception e) {
            logger.error("Unable to commit transaction to file", (Throwable)e);
            EventLog.getInstance().logEvent("Unable to complete transaction for user: " + user.getUserName() + " : " + e.getMessage());
            return new TransactionResponse(false, "Unable to complete transaction: " + e.getMessage());
        }
        return new TransactionResponse(true, "");
    }

    private RollingLog.RollPeriod getRollPeriod() {
        String period = GatewayConfig.getInstance().getProperty(CONFIG_ROTATE_PERIOD);
        return switch (period = StringUtils.trimToEmpty((String)period).toLowerCase()) {
            case "daily" -> RollingLog.RollPeriod.Daily;
            case "weekly" -> RollingLog.RollPeriod.Weekly;
            case "monthly" -> RollingLog.RollPeriod.Monthly;
            default -> RollingLog.RollPeriod.Never;
        };
    }

    private File getTargetDir() {
        String t = GatewayConfig.getInstance().getProperty(CONFIG_FILE_TARGET_DIR);
        if (StringUtils.isBlank((String)t)) {
            return new File(ServerConfig.getInstance().getServerLogsDir(), "payment-gateway");
        }
        return new File(t);
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.userHasAccess(username)) {
            return PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_PAGE_TITLE));
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private UserManager getUserManager() {
        return (UserManager)this._ctx.getBean("userManager", UserManager.class);
    }

    private AccountManager getAccountManager() {
        return (AccountManager)this._ctx.getBean("accountManager", AccountManager.class);
    }

    private CreditSourceManager getCreditSourceManager() {
        return (CreditSourceManager)this._ctx.getBean("creditSourceManager", CreditSourceManager.class);
    }

    static {
        DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd,h:mm:ss a", Locale.US);
        PAGES = new ArrayList<String>(1);
        PAGES.add("ExtnTransactionToFile");
    }

    public static class TransactionResponse {
        private final boolean _success;
        private final String _message;

        public TransactionResponse(boolean success, String message) {
            this._success = success;
            this._message = message;
        }

        public boolean isSuccess() {
            return this._success;
        }

        public String getMessage() {
            return this._message;
        }
    }
}

