/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.blackboard;

import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardProtocolException;
import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardResponse;
import biz.papercut.pcng.ext.paymentgateway.blackboard.Message;
import biz.papercut.pcng.ext.paymentgateway.blackboard.RequestMessage;
import biz.papercut.pcng.ext.paymentgateway.blackboard.ResponseMessage;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlackboardConnection {
    private static final Logger logger = LoggerFactory.getLogger(BlackboardConnection.class);
    private static final int RECEIVE_BUFFER_SIZE = 512;
    private static final int SOCKET_CONNECT_TIMEOUT_MS = 3000;
    private static final int SOCKET_READ_TIMEOUT_MS = 2000;
    private static final int RESEND_ATTEMPTS = 4;
    private static final Pattern BALANCE_EXTRACTION_FIND_PATTERN = Pattern.compile("Balance *([-.]?[\\d.]*)");
    private static final Pattern AVAILABLE_CREDIT_EXTRACTION_FIND_PATTERN = Pattern.compile("Limit *([-.]?[\\d.]*)");
    private final Socket _socket = new Socket();
    private final SecretKey _secretKey;
    private final IvParameterSpec _ips;

    public BlackboardConnection(String serverHost, int serverPort, SecretKey secretKey, IvParameterSpec ips) throws IOException {
        this._socket.setSoTimeout(2000);
        this._socket.setKeepAlive(true);
        this._socket.connect(new InetSocketAddress(serverHost, serverPort), 3000);
        this._secretKey = secretKey;
        this._ips = ips;
    }

    public BlackboardResponse getBalance(int sequenceNumber, int vendorNumber, int terminalNumber, int tenderNumber, boolean manualIdEntry, String id, Integer pin) throws IOException, BlackboardProtocolException {
        double balance;
        String statusMessage;
        Integer amount;
        boolean online;
        String timestamp = RequestMessage.getTimestamp(new Date());
        RequestMessage req = RequestMessage.valueOf(true, vendorNumber, terminalNumber, Message.TransactionType.BalanceInquiry, sequenceNumber, tenderNumber, timestamp, online = true, amount = null, manualIdEntry, id, pin, this._secretKey, this._ips);
        ResponseMessage res = this.sendMessage(req);
        BlackboardResponse errorResponse = this.handleErrorResponse(res, statusMessage = BlackboardConnection.formatStatusMessage(res.getDisplayText(), res.getResponseCode()));
        if (errorResponse != null) {
            return errorResponse;
        }
        Matcher m = BALANCE_EXTRACTION_FIND_PATTERN.matcher(res.getDisplayText());
        if (m.find()) {
            String s = m.group(1);
            try {
                balance = Double.parseDouble(s);
            }
            catch (Exception e) {
                throw new BlackboardProtocolException("Unexpected balance response: " + res.getDisplayText());
            }
        } else {
            throw new BlackboardProtocolException("Unexpected balance response: " + res.getDisplayText());
        }
        return new BlackboardResponse(true, "SUCCESS", statusMessage, null, balance, null);
    }

    public BlackboardResponse getAvailableCredit(int sequenceNumber, int vendorNumber, int terminalNumber, int tenderNumber, boolean manualIdEntry, String id, Integer pin) throws IOException, BlackboardProtocolException {
        double availableCredit;
        String statusMessage;
        Integer amount;
        boolean online;
        String timestamp = RequestMessage.getTimestamp(new Date());
        RequestMessage req = RequestMessage.valueOf(true, vendorNumber, terminalNumber, Message.TransactionType.AuthorizationLimit, sequenceNumber, tenderNumber, timestamp, online = true, amount = null, manualIdEntry, id, pin, this._secretKey, this._ips);
        ResponseMessage res = this.sendMessage(req);
        BlackboardResponse errorResponse = this.handleErrorResponse(res, statusMessage = BlackboardConnection.formatStatusMessage(res.getDisplayText(), res.getResponseCode()));
        if (errorResponse != null) {
            return errorResponse;
        }
        Matcher m = AVAILABLE_CREDIT_EXTRACTION_FIND_PATTERN.matcher(res.getDisplayText());
        if (m.find()) {
            String s = m.group(1);
            try {
                availableCredit = Double.parseDouble(s);
            }
            catch (Exception e) {
                throw new BlackboardProtocolException("Unexpected balance response: " + res.getDisplayText());
            }
        } else {
            throw new BlackboardProtocolException("Unexpected balance response: " + res.getDisplayText());
        }
        return new BlackboardResponse(true, "SUCCESS", statusMessage, null, null, availableCredit);
    }

    public BlackboardResponse performDebit(int amountCents, int sequenceNumber, int vendorNumber, int terminalNumber, int tenderNumber, boolean manualIdEntry, String id, Integer pin) throws IOException, BlackboardProtocolException {
        String statusMessage;
        boolean online;
        String timestamp = RequestMessage.getTimestamp(new Date());
        RequestMessage req = RequestMessage.valueOf(true, vendorNumber, terminalNumber, Message.TransactionType.Debit, sequenceNumber, tenderNumber, timestamp, online = true, amountCents, manualIdEntry, id, pin, this._secretKey, this._ips);
        ResponseMessage res = this.sendMessage(req);
        BlackboardResponse errorResponse = this.handleErrorResponse(res, statusMessage = BlackboardConnection.formatStatusMessage(res.getDisplayText(), res.getResponseCode()));
        if (errorResponse != null) {
            return errorResponse;
        }
        double amountDollars = (double)amountCents / 100.0;
        return new BlackboardResponse(true, "SUCCESS", statusMessage, amountDollars, null, null);
    }

    private BlackboardResponse handleErrorResponse(ResponseMessage response, String statusMessage) throws BlackboardProtocolException {
        if (response.getResponseCode() >= 100) {
            if (response.getResponseCode() == 114) {
                return new BlackboardResponse(false, "NO_USER", statusMessage, null, null, null);
            }
            if (response.getResponseCode() == 121) {
                throw new BlackboardProtocolException("The vendor and/or terminal numbers are incorrect. Ensure TIA is installed and confirm terminal number. (code " + response.getResponseCode() + ": " + response.getDisplayText() + ")");
            }
            if (response.getResponseCode() == 122) {
                return new BlackboardResponse(false, "NO_USER", statusMessage, null, null, null);
            }
            if (response.getResponseCode() < 200) {
                throw new BlackboardProtocolException("Message rejected by Blackboard (code " + response.getResponseCode() + ": " + response.getDisplayText() + ")");
            }
            if (response.getResponseCode() == 200) {
                return new BlackboardResponse(false, "NO_USER", statusMessage, null, null, null);
            }
            if (response.getResponseCode() == 207) {
                return new BlackboardResponse(false, "NO_CREDIT", statusMessage, null, null, null);
            }
            return new BlackboardResponse(false, "FAILED", statusMessage, null, null, null);
        }
        return null;
    }

    protected synchronized ResponseMessage sendMessage(RequestMessage requestMessage) throws IOException, BlackboardProtocolException {
        if (logger.isDebugEnabled()) {
            logger.debug("> {}", (Object)requestMessage);
        }
        ResponseMessage responseMessage = null;
        int resendAttempt = 0;
        while (responseMessage == null && resendAttempt++ < 4) {
            try {
                this._socket.getOutputStream().write(requestMessage.getRawMessage());
                this._socket.getOutputStream().flush();
                while ((responseMessage = this.readMessage()).getSequenceNumber() != requestMessage.getSequenceNumber()) {
                    logger.debug("Received a response to a different message, ignoring...");
                    responseMessage = null;
                }
            }
            catch (SocketTimeoutException ste) {
                logger.debug("Timed out reading response from Blackboard, resending message.");
            }
        }
        if (responseMessage == null) {
            throw new IOException("Failed to send message after " + resendAttempt + " attempts.");
        }
        return responseMessage;
    }

    protected synchronized ResponseMessage readMessage() throws IOException {
        int responseLength = 0;
        byte[] receiveBuffer = new byte[512];
        int totalBytesRead = 0;
        try {
            int bytesRead;
            do {
                if ((bytesRead = this._socket.getInputStream().read(receiveBuffer, totalBytesRead, receiveBuffer.length - totalBytesRead)) >= 0) continue;
                if (totalBytesRead > 0) {
                    logger.error("Connection unexpectedly closed while reading response. Read: {}", (Object)BlackboardConnection.getReceiveBufferDebugString(receiveBuffer, totalBytesRead));
                }
                throw new IOException("Connection unexpectedly closed by BbTS server");
            } while ((responseLength = ResponseMessage.containsMessage(receiveBuffer, totalBytesRead += bytesRead)) < 0);
        }
        catch (SocketTimeoutException ste) {
            if (totalBytesRead > 0 && logger.isDebugEnabled()) {
                logger.error("Timed out waiting for a complete response. {}", (Object)BlackboardConnection.getReceiveBufferDebugString(receiveBuffer, totalBytesRead));
            }
            throw ste;
        }
        byte[] responseMessageBytes = ArrayUtils.subarray((byte[])receiveBuffer, (int)0, (int)responseLength);
        ResponseMessage responseMessage = ResponseMessage.valueOf(responseMessageBytes, this._secretKey, this._ips);
        if (logger.isDebugEnabled()) {
            logger.debug("< {}", (Object)responseMessage);
        }
        return responseMessage;
    }

    public synchronized void close() {
        logger.debug("Closing connection to BbTS server.");
        IOUtils.closeQuietly((Socket)this._socket);
    }

    private static String getReceiveBufferDebugString(byte[] buffer, int length) {
        byte[] bytes = ArrayUtils.subarray((byte[])buffer, (int)0, (int)length);
        return String.valueOf(Hex.encodeHex((byte[])bytes));
    }

    private static String formatStatusMessage(String displayText, int responseCode) {
        return displayText + " (code " + responseCode + ")";
    }
}

