/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.blackboard;

import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardConnection;
import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardResponse;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlackboardConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(BlackboardConnectionManager.class);
    private static final int CONNECT_ATTEMPTS = 2;
    private static final int MAX_SEQUENCE_NUMBER = 999999;
    private static final int RECONNECT_WAIT_MS = 1000;
    private static final int TIMEOUT_MS = 10000;
    private static final BlackboardResponse RESPONSE_TIMED_OUT = new BlackboardResponse(false, "TIMED_OUT", "Timed out waiting to connect to Blackboard", null, null, null);
    private static final BlackboardResponse RESPONSE_CONNECT_FAILED = new BlackboardResponse(false, "CONNECT_FAILED", "Unable to connect to Blackboard", null, null, null);
    private static final BlackboardResponse RESPONSE_NO_ID = new BlackboardResponse(false, "NO_ID", "Card/id not defined", null, null, null);
    private final String _serverHost;
    private final int _serverPort;
    private final int _vendorNumber;
    private final int _terminalNumber;
    private final int _tenderNumber;
    private final SecretKey _secretKey;
    private final IvParameterSpec _ips;
    private volatile BlackboardConnection _connection;
    private volatile int _sequenceNumber = 1;

    public BlackboardConnectionManager(String serverHost, int serverPort, int vendorNumber, int terminalNumber, int tenderNumber, String sharedSecret) {
        byte[] sharedSecretBytes;
        if (sharedSecret.length() != 32) {
            throw new IllegalArgumentException("sharedSecret must be a 32 byte hex string");
        }
        this._serverHost = serverHost;
        this._serverPort = serverPort;
        this._vendorNumber = vendorNumber;
        this._terminalNumber = terminalNumber;
        this._tenderNumber = tenderNumber;
        try {
            sharedSecretBytes = Hex.decodeHex((char[])sharedSecret.toCharArray());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("sharedSecret must be a 32 byte hex string");
        }
        this._secretKey = new SecretKeySpec(sharedSecretBytes, "AES");
        this._ips = new IvParameterSpec(new byte[16]);
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlackboardResponse getBalance(String id, String cardNumber, Integer pin) {
        boolean manualIdEntry;
        String idOrCard;
        logger.debug("Get balance - id: {}, card: {}, pin: {}", new Object[]{id, cardNumber, pin});
        if (StringUtils.isBlank((String)id)) {
            idOrCard = cardNumber;
            manualIdEntry = false;
        } else {
            idOrCard = id;
            manualIdEntry = true;
        }
        if (StringUtils.isBlank((String)idOrCard)) {
            return RESPONSE_NO_ID;
        }
        long startTime = System.currentTimeMillis();
        BlackboardConnectionManager blackboardConnectionManager = this;
        synchronized (blackboardConnectionManager) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                logger.debug("timed out");
                return RESPONSE_TIMED_OUT;
            }
            if (this._connection == null && !this.connect()) {
                return RESPONSE_CONNECT_FAILED;
            }
            try {
                return this._connection.getBalance(this.getNextSequenceNumber(), this._vendorNumber, this._terminalNumber, this._tenderNumber, manualIdEntry, idOrCard, pin);
            }
            catch (Exception e) {
                String errorMsg = "Error communicating with Blackboard";
                logger.error("{}: {}", (Object)errorMsg, (Object)e.getMessage());
                this.disconnect();
                return new BlackboardResponse(false, "ERROR", errorMsg, null, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlackboardResponse getAvailableCredit(String id, String cardNumber, Integer pin) {
        boolean manualIdEntry;
        String idOrCard;
        logger.debug("Get available credit - id: {}, card: {}, pin: {}", new Object[]{id, cardNumber, pin});
        if (StringUtils.isBlank((String)id)) {
            idOrCard = cardNumber;
            manualIdEntry = false;
        } else {
            idOrCard = id;
            manualIdEntry = true;
        }
        if (StringUtils.isBlank((String)idOrCard)) {
            return RESPONSE_NO_ID;
        }
        long startTime = System.currentTimeMillis();
        BlackboardConnectionManager blackboardConnectionManager = this;
        synchronized (blackboardConnectionManager) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                logger.debug("timed out");
                return RESPONSE_TIMED_OUT;
            }
            if (this._connection == null && !this.connect()) {
                return RESPONSE_CONNECT_FAILED;
            }
            try {
                return this._connection.getAvailableCredit(this.getNextSequenceNumber(), this._vendorNumber, this._terminalNumber, this._tenderNumber, manualIdEntry, idOrCard, pin);
            }
            catch (Exception e) {
                String errorMsg = "Error communicating with Blackboard";
                logger.error("{}: {}", (Object)errorMsg, (Object)e.getMessage());
                this.disconnect();
                return new BlackboardResponse(false, "ERROR", errorMsg, null, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlackboardResponse performDebit(String id, String cardNumber, Integer pin, int amountCents) {
        boolean manualIdEntry;
        String idOrCard;
        logger.debug("Get perform debit - id: {}, card: {}, pin: {}, cents: {}", new Object[]{id, cardNumber, pin, amountCents});
        if (StringUtils.isBlank((String)id)) {
            idOrCard = cardNumber;
            manualIdEntry = false;
        } else {
            idOrCard = id;
            manualIdEntry = true;
        }
        long startTime = System.currentTimeMillis();
        BlackboardConnectionManager blackboardConnectionManager = this;
        synchronized (blackboardConnectionManager) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                logger.debug("timed out");
                return RESPONSE_TIMED_OUT;
            }
            if (this._connection == null && !this.connect()) {
                return RESPONSE_CONNECT_FAILED;
            }
            try {
                return this._connection.performDebit(amountCents, this.getNextSequenceNumber(), this._vendorNumber, this._terminalNumber, this._tenderNumber, manualIdEntry, idOrCard, pin);
            }
            catch (Exception e) {
                String errorMsg = "Error communicating with Blackboard";
                logger.error("{}: {}", (Object)errorMsg, (Object)e.getMessage());
                this.disconnect();
                return new BlackboardResponse(false, "ERROR", errorMsg, null, null, null);
            }
        }
    }

    private synchronized boolean connect() {
        int connectAttempt = 0;
        do {
            if (++connectAttempt != 1) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                logger.debug("Opening connection to BbTS server. Attempt: {}", (Object)connectAttempt);
                this._connection = new BlackboardConnection(this._serverHost, this._serverPort, this._secretKey, this._ips);
            }
            catch (Exception e) {
                logger.debug("Unable to connect to BbTS: {}", (Object)String.valueOf(e));
            }
        } while (this._connection == null && connectAttempt < 2);
        if (this._connection == null) {
            logger.error("Unable to connect to BbTS at {}:{} after {} attempts.", new Object[]{this._serverHost, this._serverPort, connectAttempt});
        }
        return this._connection != null;
    }

    private synchronized void disconnect() {
        if (this._connection != null) {
            this._connection.close();
            this._connection = null;
        }
    }

    private synchronized int getNextSequenceNumber() {
        int sequenceNumber = this._sequenceNumber++;
        if (this._sequenceNumber > 999999) {
            this._sequenceNumber = 2;
        }
        return sequenceNumber;
    }
}

