/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.blackboard;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardCardLookup;
import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardConnectionManager;
import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardResponse;
import biz.papercut.pcng.plugin.ExtDevicePlugin;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.tuple.Pair;
import com.papercut.server.lang.service.ServiceException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class BlackboardPlugin
implements ExtDevicePlugin,
SpringContextPlugin,
UserLinkPlugin {
    private static final Logger logger = LoggerFactory.getLogger(BlackboardPlugin.class);
    private static final String PAYMENT_GATEWAY_PAGE_NAME = "ExtnBlackboard";
    private static final double ROUNDING_TOLERANCE = 1.0E-5;
    private static final String EXT_DEVICE_PLUGIN_ID = "blackboard";
    private static final String CONFIG_PREFIX = "blackboard.";
    private static final String CONFIG_ENABLED = "blackboard.enabled";
    private static final String CONFIG_BALANCE_DISPLAY_PREFIX = "blackboard.balance-display.";
    private static final String CONFIG_BALANCE_DISPLAY_ENABLED = "blackboard.balance-display.enabled";
    private static final String CONFIG_BALANCE_DISPLAY_LABEL = "blackboard.balance-display.label";
    private static final String CONFIG_SERVER_PREFIX = "blackboard.server.";
    private static final String CONFIG_SERVER_HOST = "blackboard.server.host";
    private static final String CONFIG_SERVER_PORT = "blackboard.server.port";
    private static final String CONFIG_VENDOR_NUMBER = "blackboard.vendor-number";
    private static final String CONFIG_TERMINAL_NUMBER = "blackboard.terminal-number";
    @AESProperty
    public static final String CONFIG_ENCRYPTION_KEY = "blackboard.encryption-key";
    private static final String CONFIG_TENDER_NUMBER = "blackboard.tender-number";
    private static final String CONFIG_SENDING_CARD_NUMBERS = "blackboard.sending-card-numbers";
    private static final String CONFIG_NO_ID_DEFINED_MESSAGE = "blackboard.no-id-defined";
    private static final String CONFIG_MANUAL_PREFIX = "blackboard.manual-transfer.";
    private static final String CONFIG_MANUAL_TRANSFER_ENABLED = "blackboard.manual-transfer.enabled";
    private static final String CONFIG_MANUAL_TRANSFER_PAGE_TITLE = "blackboard.manual-transfer.page.title";
    private static final String CONFIG_MANUAL_TRANSFER_PAGE_HEADING = "blackboard.manual-transfer.page.heading";
    private static final String CONFIG_MANUAL_TRANSFER_BALANCE_LABEL = "blackboard.manual-transfer.balance.label";
    private static final String CONFIG_MANUAL_TRANSFER_AVAILABLE_CREDIT_ENABLE = "blackboard.manual-transfer.available-credit.enable";
    private static final String CONFIG_MANUAL_TRANSFER_AVAILABLE_CREDIT_LABEL = "blackboard.manual-transfer.available-credit.label";
    private static final String CONFIG_MANUAL_TRANSFER_TRANSACTION_COMMENT = "blackboard.manual-transfer.transaction-comment";
    private static final String CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS = "blackboard.manual-transfer.allowed-amounts";
    private static final String CONFIG_MANUAL_TRANSFER_ALLOWED_GROUPS = "blackboard.manual-transfer.allowed-groups";
    private static final String CONFIG_MANUAL_TRANSFER_USER_ERROR_MESSAGE = "blackboard.manual-transfer.user-error-message";
    private static final String CONFIG_ON_DEMAND_PREFIX = "blackboard.on-demand-transfer.";
    private static final String CONFIG_ON_DEMAND_TRANSFER_ENABLED = "blackboard.on-demand-transfer.enabled";
    private static final String CONFIG_ON_DEMAND_TRANSFER_DEFAULT_TRANSFER_AMOUNT = "blackboard.on-demand-transfer.default-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT = "blackboard.on-demand-transfer.max-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "blackboard.on-demand-transfer.transaction-comment";
    private static final String CONFIG_ON_DEMAND_TRANSFER_ENABLED_GROUPS = "blackboard.on-demand-transfer.enabled-groups";
    private static final int DEFAULT_PAPERCUT_VENDOR_NUMBER = 3112;
    private static final String DEFAULT_MANUAL_TRANSFER_TRANSACTION_COMMENT = "Funds added from Blackboard";
    private static final String DEFAULT_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "Automatic transfer from Blackboard";
    @AESProperty
    private static final String NOT_USE_CONFIG_CARD_ID_LOOKUP_DB_PASSWORD = "blackboard.card-id-lookup.db-password";
    @Nullable
    private final BlackboardCardLookup _cardLookup = new BlackboardCardLookup();
    @Nullable
    private volatile BlackboardConnectionManager _connectionManager;
    @Nullable
    private volatile ApplicationContext _ctx;

    @CheckForNull
    public String getIsConfigured() {
        String errorPrefix = "Configuration problem: ";
        String errorSuffix = "  Please check the payment gateway config file.";
        if (StringUtils.isBlank((String)BlackboardPlugin.getServerHost())) {
            String errorMsg = "BbTS server host address/IP is required.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (BlackboardPlugin.getServerPort() == null) {
            String errorMsg = "BbTS server port is required and must be a port number.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (BlackboardPlugin.getTerminalNumber() == null) {
            String errorMsg = "Terminal number is required and must be digits only.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (StringUtils.isBlank((String)BlackboardPlugin.getEncryptionKey())) {
            String errorMsg = "Encryption key is required.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (BlackboardPlugin.getTenderNumber() == null) {
            String errorMsg = "Tender number is required and must be digits only.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        try {
            this.getManualTransferAllowedAmounts();
        }
        catch (Exception e) {
            String errorMsg = "Allowed amounts setting uses the wrong format.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (this.getManualTransferAllowedAmounts().isEmpty()) {
            String errorMsg = "Must specify at least one allowed payment amount.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (this.isOnDemandTransferEnabled()) {
            if (this.getOnDemandTransferDefaultTransferAmount() == null) {
                String errorMsg = "If on-demand transfers is enabled a default transfer amount must be specified.";
                EventLog.getInstance().logEvent(errorMsg);
                return errorPrefix + errorMsg + errorSuffix;
            }
            if (this.getOnDemandTransferMaxTransferAmount() == null) {
                String errorMsg = "If on-demand transfers is enabled a max transfer amount must be specified.";
                EventLog.getInstance().logEvent(errorMsg);
                return errorPrefix + errorMsg + errorSuffix;
            }
        }
        try {
            this._cardLookup.checkConfiguration();
        }
        catch (ConfigurationException ce) {
            logger.error(ce.getMessage());
            EventLog.getInstance().logEvent(ce.getMessage());
        }
        return null;
    }

    public String getId() {
        return EXT_DEVICE_PLUGIN_ID;
    }

    public Hashtable<String, Object> call(Map<String, Object> args) {
        BlackboardResponse response = null;
        String action = (String)args.get("action");
        String id = (String)args.get("id");
        String cardNumber = (String)args.get("cardNumber");
        String pinString = (String)args.get("pin");
        Integer pin = null;
        if (StringUtils.isNotBlank((String)pinString)) {
            try {
                pin = Integer.valueOf(pinString);
            }
            catch (Exception e) {
                response = new BlackboardResponse(false, "INVALID_PIN", "Invalid PIN", null, null, null);
            }
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>(5);
        if (response == null) {
            if ("balance".equals(action) || "availableCredit".equals(action)) {
                response = this.getBalanceAndAvailableCredit(id, cardNumber, pin);
                result.put("balance", response.getBalance() == null ? -1.0 : response.getBalance());
                result.put("availableCredit", response.getAvailableCredit() == null ? -1.0 : response.getAvailableCredit());
            } else if ("debit".equals(action)) {
                Double amount = (Double)args.get("amount");
                response = this.performDebit(id, cardNumber, pin, amount);
                result.put("amount", response.getAmount() == null ? -1.0 : response.getAmount());
            } else {
                throw new ApplicationException("Unknown action: " + action);
            }
        }
        result.put("success", response.isSuccess());
        result.put("status", StringUtils.trimToEmpty((String)response.getStatus()));
        result.put("statusMessage", StringUtils.trimToEmpty((String)response.getStatusMessage()));
        return result;
    }

    public BlackboardResponse getAvailableCredit(User user, @Nullable Integer blackboardPIN) {
        Pair<String, String> idAndCard = this.getIdAndCard(this.getCardLookup().getBlackboardCardNumber(user));
        return this.getAvailableCredit((String)idAndCard.get0(), (String)idAndCard.get1(), blackboardPIN);
    }

    private BlackboardResponse getAvailableCredit(@Nullable String blackboardId, @Nullable String blackboardCardNumber, @Nullable Integer blackboardPIN) {
        BlackboardResponse response;
        try {
            response = this.sanitiseResponse(this.getConnectionManager().getAvailableCredit(blackboardId, blackboardCardNumber, blackboardPIN));
        }
        catch (ConfigurationException ce) {
            return new BlackboardResponse(false, "CONFIG_ERROR", ce.getMessage(), null, null, null);
        }
        return response;
    }

    public BlackboardResponse getBalance(User user, @Nullable Integer blackboardPIN) {
        Pair<String, String> idAndCard = this.getIdAndCard(this.getCardLookup().getBlackboardCardNumber(user));
        return this.getBalance((String)idAndCard.get0(), (String)idAndCard.get1(), blackboardPIN);
    }

    private BlackboardResponse getBalance(@Nullable String blackboardId, @Nullable String blackboardCardNumber, @Nullable Integer blackboardPIN) {
        BlackboardResponse response;
        try {
            response = this.sanitiseResponse(this.getConnectionManager().getBalance(blackboardId, blackboardCardNumber, blackboardPIN));
        }
        catch (ConfigurationException ce) {
            return new BlackboardResponse(false, "CONFIG_ERROR", ce.getMessage(), null, null, null);
        }
        return response;
    }

    public BlackboardResponse getBalanceAndAvailableCredit(@Nullable String blackboardId, @Nullable String blackboardCardNumber, @Nullable Integer blackboardPIN) {
        BlackboardResponse br = this.getBalance(blackboardId, blackboardCardNumber, blackboardPIN);
        if (!br.isSuccess()) {
            return br;
        }
        BlackboardResponse acr = this.getAvailableCredit(blackboardId, blackboardCardNumber, blackboardPIN);
        if (!br.isSuccess()) {
            return acr;
        }
        return new BlackboardResponse(true, acr.getStatus(), acr.getStatusMessage(), null, br.getBalance(), acr.getAvailableCredit());
    }

    public BlackboardResponse performDebit(User user, @Nullable Integer blackboardPIN, double amount) {
        Pair<String, String> idAndCard = this.getIdAndCard(this.getCardLookup().getBlackboardCardNumber(user));
        return this.performDebit((String)idAndCard.get0(), (String)idAndCard.get1(), blackboardPIN, amount);
    }

    private BlackboardResponse performDebit(@Nullable String blackboardId, @Nullable String blackboardCardNumber, @Nullable Integer blackboardPIN, double amount) {
        BlackboardResponse response;
        int amountCents = BlackboardPlugin.roundDoubleDollarsToCents(amount);
        String msg = "Attempting debit transaction for id: " + blackboardId + ", card: " + blackboardCardNumber + ", amount: " + amountCents + "c.";
        logger.debug(msg);
        BlackboardPlugin.getEventLog().logEvent(msg);
        try {
            response = this.getConnectionManager().performDebit(blackboardId, blackboardCardNumber, blackboardPIN, amountCents);
        }
        catch (ConfigurationException ce) {
            return new BlackboardResponse(false, "CONFIG_ERROR", ce.getMessage(), null, null, null);
        }
        String msg2 = "Transaction for id " + blackboardId + ", card " + blackboardCardNumber + ": " + String.valueOf(response);
        if (response.isSuccess()) {
            logger.debug(msg2);
        } else {
            logger.error(msg2);
        }
        BlackboardPlugin.getEventLog().logEvent(msg2);
        if (response.isSuccess()) {
            String idOrCard = blackboardId == null ? blackboardCardNumber : blackboardId;
            BlackboardPlugin.getEventLog().logTransaction(idOrCard, "", response.getAmount(), EXT_DEVICE_PLUGIN_ID);
        }
        return response;
    }

    @Nullable
    private static String getServerHost() {
        return StringUtils.trimToNull((String)BlackboardPlugin.getGatewayConfig().getString(CONFIG_SERVER_HOST));
    }

    @Nullable
    private static Integer getServerPort() {
        try {
            return BlackboardPlugin.getGatewayConfig().getInteger(CONFIG_SERVER_PORT);
        }
        catch (Exception e) {
            logger.error("Invalid server port.", (Throwable)e);
            return null;
        }
    }

    private static Integer getVendorNumber() {
        try {
            Integer vendorNumber = BlackboardPlugin.getGatewayConfig().getInteger(CONFIG_VENDOR_NUMBER);
            if (vendorNumber != null) {
                return vendorNumber;
            }
        }
        catch (Exception e) {
            logger.error("Invalid vendor number.", (Throwable)e);
        }
        return 3112;
    }

    @Nullable
    private static Integer getTerminalNumber() {
        try {
            return BlackboardPlugin.getGatewayConfig().getInteger(CONFIG_TERMINAL_NUMBER);
        }
        catch (Exception e) {
            logger.error("Invalid terminal number.", (Throwable)e);
            return null;
        }
    }

    private static String getEncryptionKey() {
        return StringUtils.trimToNull((String)BlackboardPlugin.getGatewayConfig().getString(CONFIG_ENCRYPTION_KEY));
    }

    @Nullable
    private static Integer getTenderNumber() {
        try {
            return BlackboardPlugin.getGatewayConfig().getInteger(CONFIG_TENDER_NUMBER);
        }
        catch (Exception e) {
            logger.error("Invalid tender number.", (Throwable)e);
            return null;
        }
    }

    private boolean isSendingCardNumbers() {
        return BooleanUtils.isTrue((Boolean)BlackboardPlugin.getGatewayConfig().getBoolean(CONFIG_SENDING_CARD_NUMBERS));
    }

    public boolean isBalanceDisplayEnabled() {
        return BooleanUtils.isTrue((Boolean)BlackboardPlugin.getGatewayConfig().getBoolean(CONFIG_BALANCE_DISPLAY_ENABLED));
    }

    public String getBalanceDisplayLabel() {
        return StringUtils.trimToEmpty((String)BlackboardPlugin.getGatewayConfig().getString(CONFIG_BALANCE_DISPLAY_LABEL));
    }

    public boolean isManualTransferEnabled() {
        return BooleanUtils.isTrue((Boolean)BlackboardPlugin.getGatewayConfig().getBoolean(CONFIG_MANUAL_TRANSFER_ENABLED));
    }

    @CheckForNull
    public String getManualTransferPageTitle() {
        return BlackboardPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_PAGE_TITLE);
    }

    public String getManualTransferPageHeading() {
        return StringUtils.trimToEmpty((String)BlackboardPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_PAGE_HEADING));
    }

    public String getManualTransferBalanceLabel() {
        return StringUtils.trimToEmpty((String)BlackboardPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_BALANCE_LABEL));
    }

    public boolean isShowManualTransferAvailableCredit() {
        return BooleanUtils.isTrue((Boolean)BlackboardPlugin.getGatewayConfig().getBoolean(CONFIG_MANUAL_TRANSFER_AVAILABLE_CREDIT_ENABLE));
    }

    public String getManualTransferAvailableCreditLabel() {
        return StringUtils.trimToEmpty((String)BlackboardPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_AVAILABLE_CREDIT_LABEL));
    }

    public String getManualTransferTransactionComment() {
        Object txnComment = StringUtils.trimToNull((String)BlackboardPlugin.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_MANUAL_TRANSFER_TRANSACTION_COMMENT;
        }
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public List<Double> getManualTransferAllowedAmounts() {
        return BlackboardPlugin.getGatewayConfig().getDoubleList(CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS);
    }

    public boolean isManualTransferAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_MANUAL_TRANSFER_ALLOWED_GROUPS, this.getUserManager());
    }

    public String getManualTransferUserErrorMessage() {
        String userError = StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_MANUAL_TRANSFER_USER_ERROR_MESSAGE));
        if (userError == null) {
            userError = "An error has occurred, please try again. If you continue to receive this error please contact a network administrator for assistance.";
        }
        return userError;
    }

    public String getNoIdDefinedMessage() {
        String noIdError = StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_NO_ID_DEFINED_MESSAGE));
        if (noIdError == null) {
            noIdError = "This service is currently not available as your login is not yet associated with a Blackboard account. Please contact a network administrator for assistance. (Reason: no card/id defined.)";
        }
        return noIdError;
    }

    public boolean isOnDemandTransferEnabled() {
        return BooleanUtils.isTrue((Boolean)BlackboardPlugin.getGatewayConfig().getBoolean(CONFIG_ON_DEMAND_TRANSFER_ENABLED));
    }

    @Nullable
    public Double getOnDemandTransferDefaultTransferAmount() {
        Double amount = null;
        try {
            amount = BlackboardPlugin.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_DEFAULT_TRANSFER_AMOUNT);
        }
        catch (Exception e) {
            logger.error("Invalid on-demand transfer default transfer amount.", (Throwable)e);
        }
        return amount;
    }

    @Nullable
    public Double getOnDemandTransferMaxTransferAmount() {
        Double amount = null;
        try {
            amount = BlackboardPlugin.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT);
        }
        catch (Exception e) {
            logger.error("Invalid on-demand transfer max transfer amount.", (Throwable)e);
        }
        return amount;
    }

    public String getOnDemandTransferTransactionComment() {
        Object txnComment = StringUtils.trimToNull((String)BlackboardPlugin.getGatewayConfig().getString(CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT;
        }
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public boolean isOnDemandTransferEnabledForUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        if (!this.isOnDemandTransferEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ON_DEMAND_TRANSFER_ENABLED_GROUPS, this.getUserManager());
    }

    protected static int roundDoubleDollarsToCents(double dollars) {
        double dollarsToRound = dollars - 1.0E-5;
        return (int)Math.ceil(dollarsToRound * 100.0);
    }

    private Pair<String, String> getIdAndCard(@Nullable String idOrCard) {
        if (this.isSendingCardNumbers()) {
            return Pair.from(null, (Object)idOrCard);
        }
        return Pair.from((Object)idOrCard, null);
    }

    private BlackboardResponse sanitiseResponse(BlackboardResponse response) {
        if ("NO_ID".equals(response.getStatus())) {
            return new BlackboardResponse(response.isSuccess(), response.getStatus(), this.getNoIdDefinedMessage(), response.getAmount(), response.getBalance(), response.getAvailableCredit());
        }
        return response;
    }

    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenceManager(), "payment-gateways-blackboard");
    }

    public boolean isPluginEnabled() {
        Boolean enabled = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isManualTransferEnabled() && this.isManualTransferAccessibleByUser(username)) {
            return List.of(PAYMENT_GATEWAY_PAGE_NAME);
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return this.getManualTransferPageTitle();
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
        if (this._cardLookup != null) {
            this._cardLookup.setApplicationContext(ctx);
        }
    }

    private BlackboardCardLookup getCardLookup() {
        if (this._cardLookup == null) {
            throw new ServiceException("Blackboard payment gateway not fully configured");
        }
        return this._cardLookup;
    }

    private synchronized BlackboardConnectionManager getConnectionManager() throws ConfigurationException {
        if (this._connectionManager == null) {
            String configError = this.getIsConfigured();
            if (configError != null) {
                logger.error(configError);
                throw new ConfigurationException(configError);
            }
            try {
                this._connectionManager = new BlackboardConnectionManager(BlackboardPlugin.getServerHost(), BlackboardPlugin.getServerPort(), BlackboardPlugin.getVendorNumber(), BlackboardPlugin.getTerminalNumber(), BlackboardPlugin.getTenderNumber(), BlackboardPlugin.getEncryptionKey());
            }
            catch (Exception e) {
                String errorMsg = "Blackboard plugin not fully configured: " + e.getMessage();
                logger.error(errorMsg, (Throwable)e);
                throw new ConfigurationException(errorMsg);
            }
        }
        return this._connectionManager;
    }

    private static EventLog getEventLog() {
        return EventLog.getInstance();
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private LicenseManager getLicenceManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }
}

