/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.blackboard;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardPlugin;
import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin4;
import biz.papercut.pcng.service.UserManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class BlackboardTopupAccountOnDemandPlugin
implements TopupAccountOnDemandPlugin4,
SpringContextPlugin {
    private static final Logger logger = LoggerFactory.getLogger(BlackboardTopupAccountOnDemandPlugin.class);
    private ApplicationContext _ctx;

    public Map<String, Double> getBalance(Map<String, String> userDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        BlackboardPlugin bp = BlackboardTopupAccountOnDemandPlugin.getBlackboardPlugin();
        if (!bp.isBalanceDisplayEnabled()) {
            logger.debug("Blackboard balance display disabled.");
            return null;
        }
        String username = userDetails.get("username");
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            logger.error("Unknown user: {}", (Object)username);
            return null;
        }
        BlackboardResponse br = bp.getBalance(user, null);
        Double balance = br.getBalance();
        if (balance == null) {
            if (logger.isDebugEnabled()) {
                logger.error("Unable to retrieve Blackboard balance for user \"{}\": {} {}", new Object[]{username, br.getStatusMessage(), br});
            } else {
                logger.error("Unable to retrieve Blackboard balance for user \"{}\": {}", (Object)username, (Object)br.getStatusMessage());
            }
            return null;
        }
        HashMap<String, Double> balances = new HashMap<String, Double>();
        balances.put(bp.getBalanceDisplayLabel(), balance);
        return balances;
    }

    @Nullable
    public TopupAccountOnDemandPlugin3.AvailableCredit getAvailableCreditForTopUp(String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged) {
        double available;
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            return null;
        }
        BlackboardPlugin bp = BlackboardTopupAccountOnDemandPlugin.getBlackboardPlugin();
        if (!bp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("Blackboard top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        User u = this.getUserManager().getUser(username);
        if (u == null) {
            logger.error("Unknown user: {}", (Object)username);
            return null;
        }
        BlackboardResponse response = bp.getAvailableCredit(u, null);
        if (!response.isSuccess()) {
            logger.debug("Error retrieving available credit for id '{}', response: {}", (Object)u.getCardNumber(), (Object)response);
            return null;
        }
        boolean unlimited = "SUCCESS_UNLIMITED".equals(response.getStatus());
        double d = available = response.getAvailableCredit() == null ? 0.0 : response.getAvailableCredit();
        if (available < 0.0) {
            available = 0.0;
        }
        return new TopupAccountOnDemandPlugin3.AvailableCredit(unlimited, available);
    }

    public TopupAccountOnDemandPlugin.TopupResponse getTopup(double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            logger.debug("Blackboard top-up on demand plugin not enabled for shared accounts.");
            return null;
        }
        double topupAmount = BlackboardTopupAccountOnDemandPlugin.calcTopUpAmount(amountRequired);
        if (topupAmount <= 0.0) {
            return null;
        }
        User u = this.getUserManager().getUser(username);
        if (u == null) {
            logger.debug("Unknown user: {}", (Object)username);
            return null;
        }
        BlackboardPlugin bp = BlackboardTopupAccountOnDemandPlugin.getBlackboardPlugin();
        if (!bp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("Blackboard top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        String txnComment = bp.getOnDemandTransferTransactionComment();
        return GatewayUtils.performTopupDebit((TopupAccountOnDemandPlugin3)this, amount -> {
            BlackboardResponse response = bp.performDebit(u, null, amount);
            logger.debug("Result: {}", (Object)response);
            return response.isSuccess() ? response.getAmount() : null;
        }, topupAmount, amountRequired, username, sharedAccount, accountCharged, usageDetails, txnComment);
    }

    private static double calcTopUpAmount(double amountRequired) {
        if (amountRequired <= 0.0) {
            return 0.0;
        }
        BlackboardPlugin bp = BlackboardTopupAccountOnDemandPlugin.getBlackboardPlugin();
        Double defaultAmount = bp.getOnDemandTransferDefaultTransferAmount();
        Double maxAmount = bp.getOnDemandTransferMaxTransferAmount();
        if (defaultAmount == null || maxAmount == null) {
            return 0.0;
        }
        if (defaultAmount > 0.0 && maxAmount > 0.0 && defaultAmount > maxAmount) {
            logger.warn("Blackboard default transfer amount is greater than the max transfer amount.  Using default transfer amount as max amount.");
            maxAmount = defaultAmount;
        }
        double topupAmount = amountRequired;
        if (defaultAmount > 0.0 && amountRequired < defaultAmount) {
            logger.debug("Using default transfer amount of {}", (Object)defaultAmount);
            topupAmount = defaultAmount;
        }
        if (maxAmount > 0.0 && topupAmount > maxAmount) {
            logger.debug("Transfer amount of {} exceeds maximum of {}", (Object)topupAmount, (Object)maxAmount);
            topupAmount = 0.0;
        }
        return topupAmount;
    }

    public boolean isPluginEnabled() {
        BlackboardPlugin bp = BlackboardTopupAccountOnDemandPlugin.getBlackboardPlugin();
        return bp.isPluginEnabled() && bp.isOnDemandTransferEnabled();
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private static BlackboardPlugin getBlackboardPlugin() {
        return (BlackboardPlugin)PluginManager.getInstance().getPluginByClass(BlackboardPlugin.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }
}

