/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.blackboard;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardPlugin;
import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnBlackboard
extends BasePaperCutPage
implements PageRenderListener {
    protected static final Logger logger = LoggerFactory.getLogger(ExtnBlackboard.class);

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract String getFormattedBlackboardBalance();

    public abstract void setFormattedBlackboardBalance(String var1);

    public abstract String getFormattedBlackboardAvailableCredit();

    public abstract void setFormattedBlackboardAvailableCredit(String var1);

    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract AccountManager getAccountManager();

    public abstract CreditSourceManager getCreditSourceManager();

    public abstract UserManager getUserManager();

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = ExtnBlackboard.getBlackboardPlugin().getManualTransferPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public String getHeading() {
        return ExtnBlackboard.getBlackboardPlugin().getManualTransferPageHeading();
    }

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(this.createAmountsModel());
        }
        if (!this.getRequestCycle().isRewinding()) {
            BlackboardResponse response;
            String configError;
            if (!ExtnBlackboard.getBlackboardPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = ExtnBlackboard.getBlackboardPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
                return;
            }
            if (this.getFormattedBlackboardBalance() == null) {
                response = ExtnBlackboard.getBlackboardPlugin().getBalance(this.getUser(), null);
                if (response.isSuccess()) {
                    String formattedBalance = "SUCCESS_UNLIMITED".equals(response.getStatus()) ? "Unrestricted" : this.formatBalance(response.getBalance());
                    this.setFormattedBlackboardBalance(formattedBalance);
                } else if ("NO_ID".equals(response.getStatus())) {
                    this.addErrorMessage(response.getStatusMessage());
                } else if (this.getErrorMessages().isEmpty()) {
                    this.addErrorMessage(ExtnBlackboard.getBlackboardPlugin().getManualTransferUserErrorMessage() + " (Error retrieving Blackboard balance: " + response.getStatusMessage() + ")");
                }
            }
            if (this.getFormattedBlackboardAvailableCredit() == null && this.getFormattedBlackboardBalance() != null && ExtnBlackboard.getBlackboardPlugin().isShowManualTransferAvailableCredit()) {
                response = ExtnBlackboard.getBlackboardPlugin().getAvailableCredit(this.getUser(), null);
                if (response.isSuccess()) {
                    String formattedAvailableCredit = "SUCCESS_UNLIMITED".equals(response.getStatus()) ? "Unrestricted" : this.formatBalance(response.getAvailableCredit());
                    this.setFormattedBlackboardAvailableCredit(formattedAvailableCredit);
                } else if (this.getErrorMessages().isEmpty()) {
                    this.addErrorMessage(ExtnBlackboard.getBlackboardPlugin().getManualTransferUserErrorMessage() + " (Error retrieving Blackboard available credit: " + response.getStatusMessage() + ")");
                }
            }
        }
    }

    public void doTransaction(IRequestCycle cycle) {
        ValidationDelegate delegate = (ValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            this.addErrorMessage(delegate.getFirstError().toString());
            return;
        }
        if (!this.isAccessibleByUser()) {
            this.addErrorMessage("You do not have permission to access this feature.");
            return;
        }
        if (this.getAmount() == null || this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select the amount to transfer to your account.");
            return;
        }
        double amount = this.getAmount();
        boolean success = false;
        Object errorSuffix = "";
        try {
            BlackboardResponse response = ExtnBlackboard.getBlackboardPlugin().performDebit(this.getUser(), null, amount);
            if (response.isSuccess()) {
                String txnComment = ExtnBlackboard.getBlackboardPlugin().getManualTransferTransactionComment();
                GatewayUtils.addCreditToUser(this.getAccountManager(), this.getCreditSourceManager(), this.getUser(), amount, txnComment);
                this.addStatusMessage(this.formatBalance(amount) + " was successfully added to your account.");
                cycle.activate("UserSummary");
                success = true;
            } else {
                errorSuffix = (String)errorSuffix + " (Transaction declined by Blackboard: " + response.getStatusMessage() + ")";
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error performing Blackboard debit transaction for user: {}", (Object)this.getUser().getUserName(), (Object)e);
        }
        if (!success) {
            this.addErrorMessage(ExtnBlackboard.getBlackboardPlugin().getManualTransferUserErrorMessage() + (String)errorSuffix);
        }
    }

    public boolean isAccessibleByUser() {
        return ExtnBlackboard.getBlackboardPlugin().isManualTransferAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public String getNoAccessMsg() {
        return ExtnBlackboard.getGatewayConfig().getNoAccessMessage();
    }

    public String getUserAndFullName() {
        StringBuilder s = new StringBuilder();
        s.append(this.getUser().getUserName());
        if (StringUtils.isNotBlank((String)this.getUser().getFullName())) {
            s.append(" (");
            s.append(this.getUser().getFullName());
            s.append(")");
        }
        return s.toString();
    }

    public String getBlackboardBalanceLabel() {
        return ExtnBlackboard.getBlackboardPlugin().getManualTransferBalanceLabel();
    }

    public boolean isShowBlackboardAvailableCredit() {
        return ExtnBlackboard.getBlackboardPlugin().isShowManualTransferAvailableCredit();
    }

    public String getBlackboardAvailableCreditLabel() {
        return ExtnBlackboard.getBlackboardPlugin().getManualTransferAvailableCreditLabel();
    }

    public String getPageMessage() {
        return ExtnBlackboard.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return ExtnBlackboard.getGatewayConfig().getPageMessageAvailable();
    }

    private IPropertySelectionModel createAmountsModel() {
        return GatewayUtils.createAllowedAmountsModel(ExtnBlackboard.getBlackboardPlugin().getManualTransferAllowedAmounts(), (BasePaperCutPage)this);
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private static BlackboardPlugin getBlackboardPlugin() {
        return (BlackboardPlugin)PluginManager.getInstance().getPluginByClass(BlackboardPlugin.class);
    }
}

