/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.blackboard;

import biz.papercut.pcng.util.ObjectUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class Message {
    protected static final byte FIELD_SEPARATOR = 126;
    protected static final int VERSION_NUMBER = 2;
    protected final byte[] _rawMessage;
    protected final int _messageLength;
    protected final boolean _encrypted;
    protected final int _vendorNumber;
    protected final int _terminalNumber;
    protected final int _encryptedLength;
    protected final int _versionNumber;
    protected final TransactionType _transactionType;
    protected final int _sequenceNumber;

    protected Message(byte[] rawMessage, int messageLength, boolean encrypted, int vendorNumber, int terminalNumber, int encryptedLength, int versionNumber, TransactionType transactionType, int sequenceNumber) {
        this._rawMessage = rawMessage;
        this._messageLength = messageLength;
        this._encrypted = encrypted;
        this._vendorNumber = vendorNumber;
        this._terminalNumber = terminalNumber;
        this._encryptedLength = encryptedLength;
        this._versionNumber = versionNumber;
        this._transactionType = transactionType;
        this._sequenceNumber = sequenceNumber;
    }

    public byte[] getRawMessage() {
        return this._rawMessage;
    }

    public int getMessageLength() {
        return this._messageLength;
    }

    public boolean isEncrypted() {
        return this._encrypted;
    }

    public int getVendorNumber() {
        return this._vendorNumber;
    }

    public int getTerminalNumber() {
        return this._terminalNumber;
    }

    public int getEncryptedLength() {
        return this._encryptedLength;
    }

    public int getVersionNumber() {
        return this._versionNumber;
    }

    public TransactionType getTransactionType() {
        return this._transactionType;
    }

    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    protected static byte[] calculateCRC16(byte[] data) {
        int crc = 0;
        int temp = 0;
        for (byte v : data) {
            int value = v & 0xFF;
            temp = value ^ crc >> 8;
            temp ^= temp >> 4;
            temp ^= temp >> 2;
            temp ^= temp >> 1;
            crc = (char)(crc << 8 ^ temp << 15 ^ temp << 2 ^ temp);
        }
        return new byte[]{(byte)(crc >>> 8), (byte)crc};
    }

    protected static byte[] calculateLRC(byte[] data) {
        int lrc = 0;
        for (byte b : data) {
            lrc ^= b;
        }
        return new byte[]{(byte)lrc};
    }

    protected ToStringBuilder createToStringBuilder() {
        return ObjectUtils.createToStringBuilder((Object)this).append("rawMessage", (Object)String.valueOf(Hex.encodeHex((byte[])this._rawMessage))).append("messageLength", this._messageLength).append("encrypted", this._encrypted).append("vendorNumber", this._vendorNumber).append("terminalNumber", this._terminalNumber).append("encryptedLength", this._encryptedLength).append("versionNumber", this._versionNumber).append("transactionType", (Object)this._transactionType).append("sequenceNumber", this._sequenceNumber);
    }

    public String toString() {
        return this.createToStringBuilder().toString();
    }

    protected static enum TransactionType {
        Debit(1),
        BalanceInquiry(2),
        Count(3),
        Deposit(6),
        AuthorizationLimit(7);

        private final int _id;

        private TransactionType(int id) {
            this._id = id;
        }

        public int getId() {
            return this._id;
        }

        public static TransactionType valueOf(int id) {
            for (TransactionType tt : TransactionType.values()) {
                if (tt.getId() != id) continue;
                return tt;
            }
            return null;
        }
    }
}

