/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.blackboard;

import biz.papercut.pcng.ext.paymentgateway.blackboard.Message;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMessage
extends Message {
    private static final Logger logger = LoggerFactory.getLogger(RequestMessage.class);
    private static final int ENCRYPTED_FIELDS_SIZE_MULTIPLE = 16;
    private final int _tenderNumber;
    private final String _timestamp;
    private final boolean _online;
    private final Integer _amount;
    private final String _currency;
    private final boolean _manualIdEntry;
    private final String _id;
    private final Integer _pin;

    private RequestMessage(byte[] rawMessage, int messageLength, boolean encrypted, int vendorNumber, int terminalNumber, int encryptedLength, int versionNumber, Message.TransactionType transactionType, int sequenceNumber, int tenderNumber, String timestamp, boolean online, Integer amount, String currency, boolean manualIdEntry, String id, Integer pin) {
        super(rawMessage, messageLength, encrypted, vendorNumber, terminalNumber, encryptedLength, versionNumber, transactionType, sequenceNumber);
        this._tenderNumber = tenderNumber;
        this._timestamp = timestamp;
        this._online = online;
        this._amount = amount;
        this._currency = currency;
        this._manualIdEntry = manualIdEntry;
        this._id = id;
        this._pin = pin;
    }

    public int getTenderNumber() {
        return this._tenderNumber;
    }

    public String getTimestamp() {
        return this._timestamp;
    }

    public boolean isOnline() {
        return this._online;
    }

    public int getAmount() {
        return this._amount;
    }

    public String getCurrency() {
        return this._currency;
    }

    public boolean isManualIdEntry() {
        return this._manualIdEntry;
    }

    public String getId() {
        return this._id;
    }

    public Integer getPIN() {
        return this._pin;
    }

    public static RequestMessage valueOf(boolean encrypted, int vendorNumber, int terminalNumber, Message.TransactionType transactionType, int sequenceNumber, int tenderNumber, String timestamp, boolean online, Integer amount, boolean manualIdEntry, String id, Integer pin, SecretKey secretKey, IvParameterSpec ips) {
        int messageLength;
        int encryptedLength;
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id must not be blank");
        }
        ByteArrayOutputStream message = new ByteArrayOutputStream();
        String currency = "USD";
        try {
            message.write(encrypted ? "1".getBytes(StandardCharsets.UTF_8) : "0".getBytes(StandardCharsets.UTF_8));
            message.write(126);
            message.write(String.valueOf(vendorNumber).getBytes(StandardCharsets.UTF_8));
            message.write(126);
            message.write(String.valueOf(terminalNumber).getBytes(StandardCharsets.UTF_8));
            message.write(126);
            byte[] fieldsToEncrypt = RequestMessage.constructFieldsToEncrypt(transactionType, sequenceNumber, tenderNumber, timestamp, amount, currency, manualIdEntry, id, pin);
            encryptedLength = encrypted ? fieldsToEncrypt.length : 0;
            message.write(String.valueOf(encryptedLength).getBytes(StandardCharsets.UTF_8));
            message.write(126);
            if (encrypted) {
                int encryptionPadLength = RequestMessage.getEncryptionPadLength(fieldsToEncrypt.length);
                byte[] encryptionPad = new byte[encryptionPadLength];
                byte[] blockToEncrypt = ArrayUtils.addAll((byte[])fieldsToEncrypt, (byte[])encryptionPad);
                byte[] encryptedBlock = RequestMessage.encryptBlock(blockToEncrypt, secretKey, ips);
                message.write(encryptedBlock);
            } else {
                message.write(fieldsToEncrypt);
            }
            messageLength = message.size() + (encrypted ? 2 : 1) + 4 + 1;
            byte[] messageLengthASCIIBytes = RequestMessage.formatNumberAsASCIIBytes(messageLength, 4);
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            temp.write(messageLengthASCIIBytes);
            temp.write(126);
            temp.write(message.toByteArray());
            message = temp;
            byte[] checksum = encrypted ? RequestMessage.calculateCRC16(message.toByteArray()) : RequestMessage.calculateLRC(message.toByteArray());
            message.write(checksum);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            return new RequestMessage(message.toByteArray(), messageLength, encrypted, vendorNumber, terminalNumber, encryptedLength, 2, transactionType, sequenceNumber, tenderNumber, timestamp, online, amount, currency, manualIdEntry, id, pin);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static byte[] constructFieldsToEncrypt(Message.TransactionType transactionType, int sequenceNumber, int tenderNumber, String timestamp, Integer amountCents, String currency, boolean manualIdEntry, String id, Integer pin) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id must not be blank");
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            bytes.write(String.valueOf(2).getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            bytes.write(String.valueOf(transactionType.getId()).getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            bytes.write(String.valueOf(sequenceNumber).getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            bytes.write(String.valueOf(tenderNumber).getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            bytes.write(timestamp.getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            bytes.write("T".getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            String amountCentsString = amountCents == null ? "0" : String.valueOf(amountCents);
            bytes.write(amountCentsString.getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            bytes.write(currency.getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            bytes.write(manualIdEntry ? "T".getBytes(StandardCharsets.UTF_8) : "F".getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            bytes.write(id.getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            bytes.write(pin == null ? "0".getBytes(StandardCharsets.UTF_8) : String.valueOf(pin).getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
            bytes.write("0".getBytes(StandardCharsets.UTF_8));
            bytes.write(126);
        }
        catch (Exception e) {
            String errorMsg = "Unexpected error constructing request message: " + e.getMessage();
            logger.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
        return bytes.toByteArray();
    }

    protected static int getEncryptionPadLength(int encryptedFieldsLength) {
        int remainder = encryptedFieldsLength % 16;
        return remainder > 0 ? 16 - remainder : 0;
    }

    protected static byte[] encryptBlock(byte[] blockToEncrypt, SecretKey secretKey, IvParameterSpec ips) {
        byte[] encryptedFields = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(1, (Key)secretKey, ips);
            encryptedFields = cipher.doFinal(blockToEncrypt);
        }
        catch (Exception e) {
            String errorMsg = "Failed to encrypt message: " + e.getMessage();
            logger.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
        return encryptedFields;
    }

    protected static byte[] formatNumberAsASCIIBytes(int number, int size) {
        String n = String.valueOf(number);
        if (n.length() > size) {
            throw new IllegalArgumentException("'number' must not have more digits than 'size'");
        }
        String leftPaddedString = StringUtils.leftPad((String)n, (int)size, (char)'0');
        try {
            return leftPaddedString.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return leftPaddedString.getBytes();
        }
    }

    protected static String getTimestamp(Date dateTime) {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(dateTime);
    }

    @Override
    public String toString() {
        return this.createToStringBuilder().append("timestamp", (Object)this._timestamp).append("online", this._online).append("tenderNumber", this._tenderNumber).append("amount", (Object)this._amount).append("currency", (Object)this._currency).append("manualIdEntry", this._manualIdEntry).append("id", (Object)this._id).append("pin", (Object)this._pin).toString();
    }
}

