/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.blackboard;

import biz.papercut.pcng.ext.paymentgateway.blackboard.BlackboardProtocolException;
import biz.papercut.pcng.ext.paymentgateway.blackboard.Message;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseMessage
extends Message {
    private static final Logger logger = LoggerFactory.getLogger(ResponseMessage.class);
    private static final int MINIMUM_MESSAGE_LENGTH = 19;
    private final int _responseCode;
    private final String _displayText;

    private ResponseMessage(byte[] rawMessage, int messageLength, boolean encrypted, int vendorNumber, int terminalNumber, int encryptedLength, int versionNumber, Message.TransactionType transactionType, int sequenceNumber, int responseCode, String displayText) {
        super(rawMessage, messageLength, encrypted, vendorNumber, terminalNumber, encryptedLength, versionNumber, transactionType, sequenceNumber);
        this._responseCode = responseCode;
        this._displayText = displayText;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public String getDisplayText() {
        return this._displayText;
    }

    public static ResponseMessage valueOf(byte[] rawMessage, SecretKey secretKey, IvParameterSpec ips) {
        byte[] decryptedBlock;
        int messageLength = -1;
        boolean encrypted = false;
        int vendorNumber = -1;
        int terminalNumber = -1;
        int encryptedLength = -1;
        int versionNumber = -1;
        Message.TransactionType transactionType = null;
        int sequenceNumber = -1;
        int responseCode = -1;
        String displayText = null;
        int fieldNumber = 0;
        int fieldStartIndex = 0;
        for (int i = 0; i < rawMessage.length; ++i) {
            if (rawMessage[i] != 126) continue;
            int fieldLength = i - fieldStartIndex;
            String field = "";
            field = new String(rawMessage, fieldStartIndex, fieldLength, StandardCharsets.UTF_8);
            switch (fieldNumber++) {
                case 0: {
                    messageLength = Integer.parseInt(field);
                    break;
                }
                case 1: {
                    encrypted = field.equals("1");
                    break;
                }
                case 2: {
                    vendorNumber = Integer.parseInt(field);
                    break;
                }
                case 3: {
                    terminalNumber = Integer.parseInt(field);
                    break;
                }
                case 4: {
                    encryptedLength = Integer.parseInt(field);
                }
            }
            fieldStartIndex = i + 1;
            if (fieldNumber == 5) break;
        }
        int checksumLength = encrypted ? 2 : 1;
        byte[] encryptedBlock = ArrayUtils.subarray((byte[])rawMessage, (int)fieldStartIndex, (int)(rawMessage.length - checksumLength));
        int actualMessageLength = rawMessage.length;
        if (messageLength != actualMessageLength) {
            throw new BlackboardProtocolException("Message length differs from expected length (" + actualMessageLength + " != " + messageLength + ")");
        }
        if (!ResponseMessage.validateChecksum(rawMessage, encrypted)) {
            String errorMsg = "Message corrupted (bad checksum)";
            String errorDetail = "[msg=" + new String(Hex.encodeHex((byte[])rawMessage)) + "]";
            logger.error("{} {}", (Object)errorMsg, (Object)errorDetail);
            throw new BlackboardProtocolException(errorMsg);
        }
        if (encrypted) {
            try {
                Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                cipher.init(2, (Key)secretKey, ips);
                decryptedBlock = cipher.doFinal(encryptedBlock);
            }
            catch (Exception e) {
                String errorMsg = "Error decrypting message: " + e.getMessage();
                logger.error(errorMsg, (Throwable)e);
                throw new BlackboardProtocolException(errorMsg, e);
            }
        } else {
            decryptedBlock = encryptedBlock;
        }
        fieldNumber = 0;
        fieldStartIndex = 0;
        for (int i = 0; i < decryptedBlock.length; ++i) {
            if (decryptedBlock[i] != 126) continue;
            int fieldLength = i - fieldStartIndex;
            String field = "";
            field = new String(decryptedBlock, fieldStartIndex, fieldLength, StandardCharsets.UTF_8);
            switch (fieldNumber++) {
                case 0: {
                    versionNumber = Integer.parseInt(field);
                    break;
                }
                case 1: {
                    try {
                        int transactionTypeInt = Integer.parseInt(field);
                        if (i <= 0 || (transactionType = Message.TransactionType.valueOf(transactionTypeInt)) != null) break;
                        logger.error("Unexpected transaction type: {}", (Object)field);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    break;
                }
                case 2: {
                    sequenceNumber = Integer.parseInt(field);
                    break;
                }
                case 3: {
                    responseCode = Integer.parseInt(field);
                    break;
                }
                case 4: {
                    displayText = field;
                }
            }
            fieldStartIndex = i + 1;
            if (fieldNumber == 5) break;
        }
        return new ResponseMessage(rawMessage, actualMessageLength, encrypted, vendorNumber, terminalNumber, encryptedLength, versionNumber, transactionType, sequenceNumber, responseCode, displayText);
    }

    public static int containsMessage(byte[] buffer, int bufferLength) {
        int messageLength;
        if (bufferLength < 19) {
            return -1;
        }
        byte[] messageLengthBytes = ArrayUtils.subarray((byte[])buffer, (int)0, (int)4);
        String messageLengthString = null;
        try {
            messageLengthString = new String(messageLengthBytes, StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            messageLength = Integer.parseInt(messageLengthString);
        }
        catch (Exception e) {
            throw new BlackboardProtocolException("Unexpected message length value: " + messageLengthString);
        }
        if (bufferLength < messageLength) {
            return -1;
        }
        return messageLength;
    }

    private static boolean validateChecksum(byte[] rawMessage, boolean encrypted) {
        int checksumLength = encrypted ? 2 : 1;
        byte[] messageWithoutChecksum = ArrayUtils.subarray((byte[])rawMessage, (int)0, (int)(rawMessage.length - checksumLength));
        byte[] actualChecksum = ArrayUtils.subarray((byte[])rawMessage, (int)(rawMessage.length - checksumLength), (int)rawMessage.length);
        byte[] calculatedChecksum = encrypted ? ResponseMessage.calculateCRC16(messageWithoutChecksum) : ResponseMessage.calculateLRC(messageWithoutChecksum);
        return Arrays.equals(actualChecksum, calculatedChecksum);
    }

    @Override
    public String toString() {
        return this.createToStringBuilder().append("responseCode", this._responseCode).append("displayText", (Object)this._displayText).toString();
    }
}

