/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.dti;

import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.util.ApplicationInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class CardSmithDtiConfig {
    static final String CONFIG_PREFIX = "cardsmith-dti.";
    static final String CONFIG_ENABLED = "cardsmith-dti.enabled";
    static final String CONFIG_MERCHANT_ID = "cardsmith-dti.merchant-id";
    static final String CONFIG_TERMINAL_ID = "cardsmith-dti.terminal-id";
    static final String CONFIG_SEARCH_PATH_CODE = "cardsmith-dti.search-path-code";
    static final String CONFIG_BALANCE_PREFIX = "cardsmith-dti.balance.";
    static final String CONFIG_BALANCE_LABEL = "cardsmith-dti.balance.label";
    static final String CONFIG_BALANCE_DISPLAY_ENABLED = "cardsmith-dti.balance.display.enabled";
    static final String CONFIG_MANUAL_PREFIX = "cardsmith-dti.manual-transfers.";
    static final String CONFIG_MANUAL_TRANSFERS_ENABLED = "cardsmith-dti.manual-transfers.enabled";
    static final String CONFIG_MANUAL_TRANSFERS_SHOW_BALANCE = "cardsmith-dti.manual-transfers.show-balance";
    static final String CONFIG_MANUAL_TRANSFERS_PAGE_TITLE = "cardsmith-dti.manual-transfers.page.title";
    static final String CONFIG_MANUAL_TRANSFERS_PAGE_HEADING = "cardsmith-dti.manual-transfers.page.heading";
    static final String CONFIG_MANUAL_TRANSFERS_TRANSACTION_COMMENT = "cardsmith-dti.manual-transfers.transaction-comment";
    static final String CONFIG_MANUAL_TRANSFERS_ALLOWED_AMOUNTS = "cardsmith-dti.manual-transfers.allowed-amounts";
    static final String CONFIG_MANUAL_TRANSFERS_ALLOWED_GROUPS = "cardsmith-dti.manual-transfers.allowed-groups";
    static final String CONFIG_MANUAL_TRANSFERS_USER_ERROR_MESSAGE = "cardsmith-dti.manual-transfers.user-error-message";
    static final String CONFIG_ON_DEMAND_PREFIX = "cardsmith-dti.on-demand-transfers.";
    static final String CONFIG_ON_DEMAND_TRANSFERS_ENABLED = "cardsmith-dti.on-demand-transfers.enabled";
    static final String CONFIG_ON_DEMAND_TRANSFERS_DEFAULT_TRANSFER_AMOUNT = "cardsmith-dti.on-demand-transfers.default-transfer-amount";
    static final String CONFIG_ON_DEMAND_TRANSFERS_MAX_TRANSFER_AMOUNT = "cardsmith-dti.on-demand-transfers.max-transfer-amount";
    static final String CONFIG_ON_DEMAND_TRANSFERS_TRANSACTION_COMMENT = "cardsmith-dti.on-demand-transfers.transaction-comment";
    static final String CONFIG_ON_DEMAND_TRANSFERS_ENABLED_GROUPS = "cardsmith-dti.on-demand-transfers.enabled-groups";
    static final String CONFIG_PAN_LOOKUP_PREFIX = "cardsmith-dti.pan-lookup.";
    static final String CONFIG_PAN_LOOKUP_MODE = "cardsmith-dti.pan-lookup.mode";
    static final String CONFIG_PAN_LOOKUP_USER_INPUT_LABEL = "cardsmith-dti.pan-lookup.user-input.label";
    static final String CONFIG_PAN_LOOKUP_DB_DRIVER = "cardsmith-dti.pan-lookup.db.driver";
    static final String CONFIG_PAN_LOOKUP_DB_URL = "cardsmith-dti.pan-lookup.db.url";
    static final String CONFIG_PAN_LOOKUP_DB_USERNAME = "cardsmith-dti.pan-lookup.db.username";
    static final String CONFIG_PAN_LOOKUP_DB_PASSWORD = "cardsmith-dti.pan-lookup.db.password";
    static final String CONFIG_PAN_LOOKUP_DB_SQL = "cardsmith-dti.pan-lookup.db.sql";
    static final String CONFIG_SERVER_PREFIX = "cardsmith-dti.server.";
    static final String CONFIG_SERVER_AUTHORIZATION_URL = "cardsmith-dti.server.authorize-url";
    static final String CONFIG_SERVER_CONNECT_TIMEOUT = "cardsmith-dti.server.connect-timeout";
    static final String CONFIG_SERVER_READ_TIMEOUT = "cardsmith-dti.server.read-timeout";
    static final String CONFIG_SERVER_RECEIVE_TIMEOUT = "cardsmith-dti.server.receive-timeout";
    static final String DEFAULT_SEARCH_PATH_CODE = "00";
    static final String DEFAULT_MANUAL_TRANSFERS_TRANSACTION_COMMENT = "Funds added from CardSmith";
    static final String DEFAULT_MANUAL_TRANSFERS_USER_ERROR_MESSAGE = "An error has occurred, please try again. If you continue to receive this error please contact a network administrator for assistance.";
    static final String DEFAULT_ON_DEMAND_TRANSFERS_TRANSACTION_COMMENT = "Automatic transfer from CardSmith";
    static final int DEFAULT_SERVER_CONNECT_TIMEOUT = 3000;
    static final int DEFAULT_SERVER_READ_TIMEOUT = 2000;
    static final int DEFAULT_SERVER_RECEIVE_TIMEOUT = 4000;
    static final String APPLICATION_VERSION_PREFIX = "PC ";
    private static final int MESSAGE_SEND_ATTEMPTS = 3;
    private static final int MESSAGE_RECEIVE_ATTEMPTS = 2;
    private static final int WAIT_BEFORE_RESEND_MS = 500;

    public void checkConfiguration() throws ConfigurationException {
        this.getMerchantId();
        this.getTerminalId();
        this.getSearchPathCode();
        if (this.isOnDemandTransfersEnabled()) {
            this.getOnDemandTransfersDefaultTransferAmount();
            this.getOnDemandTransfersMaxTransferAmount();
        }
        this.getPanLookupMode();
        this.getServerAuthorizationUrl();
        this.getServerHost();
        this.getServerPort();
        this.isServerSsl();
        if (this.getPanLookupMode() == PanLookupMode.EXTERNAL_DATABASE) {
            this.getExternalDbPanLookupDriver();
            this.getExternalDbPanLookupUrl();
            if (StringUtils.isBlank((String)this.getExternalDbPanLookupSqlTemplate())) {
                throw CardSmithDtiConfig.formatConfigurationException("External database PAN lookup has been enabled but no SQL query has been specified (cardsmith-dti.pan-lookup.db.sql).");
            }
        }
    }

    public boolean isEnabled() {
        Boolean enabled = this.getGatewayConfig().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public String getMerchantId() throws ConfigurationException {
        String value = this.getGatewayConfig().getString(CONFIG_MERCHANT_ID);
        if (StringUtils.isBlank((String)value)) {
            throw CardSmithDtiConfig.formatConfigurationException("CardSmith merchant id is blank (cardsmith-dti.merchant-id).");
        }
        return value;
    }

    public String getTerminalId() throws ConfigurationException {
        String value = this.getGatewayConfig().getString(CONFIG_TERMINAL_ID);
        if (StringUtils.isBlank((String)value)) {
            throw CardSmithDtiConfig.formatConfigurationException("CardSmith terminal id is blank (cardsmith-dti.terminal-id).");
        }
        return value;
    }

    public String getSearchPathCode() throws ConfigurationException {
        String value = this.getGatewayConfig().getString(CONFIG_SEARCH_PATH_CODE);
        if (StringUtils.isBlank((String)value)) {
            return DEFAULT_SEARCH_PATH_CODE;
        }
        if (value.length() != 2 || !NumberUtils.isDigits((String)value)) {
            throw CardSmithDtiConfig.formatConfigurationException("CardSmith search path code is invalid (cardsmith-dti.search-path-code, should be two digits).");
        }
        return value;
    }

    public String getApplicationVersion() {
        return APPLICATION_VERSION_PREFIX + this.getApplicationInfo().getVersion();
    }

    public String getBalanceLabel() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_BALANCE_LABEL));
    }

    public boolean isBalanceDisplayEnabled() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_BALANCE_DISPLAY_ENABLED));
    }

    public boolean isManualTransfersEnabled() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_MANUAL_TRANSFERS_ENABLED));
    }

    public boolean isManualTransfersShowBalance() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_MANUAL_TRANSFERS_SHOW_BALANCE));
    }

    @CheckForNull
    public String getManualTransfersPageTitle() {
        return this.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFERS_PAGE_TITLE);
    }

    public String getManualTransfersPageHeading() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFERS_PAGE_HEADING));
    }

    public String getManualTransfersTransactionComment() {
        String txnComment = StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFERS_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_MANUAL_TRANSFERS_TRANSACTION_COMMENT;
        }
        return txnComment;
    }

    public String getManualTransfersUserErrorMessage() {
        String userError = StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFERS_USER_ERROR_MESSAGE));
        if (userError == null) {
            userError = DEFAULT_MANUAL_TRANSFERS_USER_ERROR_MESSAGE;
        }
        return userError;
    }

    public boolean isOnDemandTransfersEnabled() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_ON_DEMAND_TRANSFERS_ENABLED));
    }

    public double getOnDemandTransfersDefaultTransferAmount() throws ConfigurationException {
        Double amount = null;
        try {
            amount = this.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFERS_DEFAULT_TRANSFER_AMOUNT);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (amount == null) {
            throw CardSmithDtiConfig.formatConfigurationException("Invalid value for default on-demand transfers amount (cardsmith-dti.on-demand-transfers.default-transfer-amount).");
        }
        return amount;
    }

    public double getOnDemandTransfersMaxTransferAmount() throws ConfigurationException {
        Double amount = null;
        try {
            amount = this.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFERS_MAX_TRANSFER_AMOUNT);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (amount == null) {
            throw CardSmithDtiConfig.formatConfigurationException("Invalid value for maximum on-demand transfers amount (cardsmith-dti.on-demand-transfers.max-transfer-amount).");
        }
        return amount;
    }

    public String getOnDemandTransfersTransactionComment() {
        String txnComment = StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ON_DEMAND_TRANSFERS_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_ON_DEMAND_TRANSFERS_TRANSACTION_COMMENT;
        }
        return txnComment;
    }

    public PanLookupMode getPanLookupMode() throws ConfigurationException {
        PanLookupMode mode;
        String value = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_PAN_LOOKUP_MODE)).toUpperCase(Locale.US);
        try {
            mode = PanLookupMode.valueOf(value);
        }
        catch (IllegalArgumentException iae) {
            throw CardSmithDtiConfig.formatConfigurationException("Invalid value for PAN lookup mode: " + value + " (cardsmith-dti.pan-lookup.mode).");
        }
        if (mode == PanLookupMode.USER_INPUT && this.isOnDemandTransfersEnabled()) {
            throw CardSmithDtiConfig.formatConfigurationException("The PAN lookup mode USER_INPUT cannot be used with on-demand transfers.");
        }
        return mode;
    }

    public String getPanLookupUserInputLabel() {
        return this.getGatewayConfig().getString(CONFIG_PAN_LOOKUP_USER_INPUT_LABEL);
    }

    public String getExternalDbPanLookupDriver() throws ConfigurationException {
        String value = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_PAN_LOOKUP_DB_DRIVER));
        if (StringUtils.isBlank((String)value)) {
            throw CardSmithDtiConfig.formatConfigurationException("CardSmith external database PAN lookup is enabled, but the option cardsmith-dti.pan-lookup.db.driver is blank.");
        }
        return value;
    }

    public String getExternalDbPanLookupUrl() throws ConfigurationException {
        String value = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_PAN_LOOKUP_DB_URL));
        if (StringUtils.isBlank((String)value)) {
            throw CardSmithDtiConfig.formatConfigurationException("CardSmith external database PAN lookup is enabled, but the option cardsmith-dti.pan-lookup.db.url is blank.");
        }
        return value;
    }

    public String getExternalDbPanLookupUsername() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_PAN_LOOKUP_DB_USERNAME));
    }

    public String getExternalDbPanLookupPassword() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_PAN_LOOKUP_DB_PASSWORD));
    }

    public String getExternalDbPanLookupSqlTemplate() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_PAN_LOOKUP_DB_SQL));
    }

    private URL getServerAuthorizationUrl() throws ConfigurationException {
        try {
            return this.getGatewayConfig().getURL(CONFIG_SERVER_AUTHORIZATION_URL);
        }
        catch (MalformedURLException murle) {
            String url = this.getGatewayConfig().getString(CONFIG_SERVER_AUTHORIZATION_URL);
            throw CardSmithDtiConfig.formatConfigurationException("Invalid CardSmith server authorization URL: " + url);
        }
    }

    public String getServerHost() throws ConfigurationException {
        URL url = this.getServerAuthorizationUrl();
        return url.getHost();
    }

    public int getServerPort() throws ConfigurationException {
        URL url = this.getServerAuthorizationUrl();
        return url.getPort();
    }

    public boolean isServerSsl() throws ConfigurationException {
        URL url = this.getServerAuthorizationUrl();
        return "https".equals(url.getProtocol());
    }

    public int getServerConnectTimeoutMs() {
        Integer connectTimeout = this.getGatewayConfig().getInteger(CONFIG_SERVER_CONNECT_TIMEOUT);
        if (connectTimeout == null) {
            connectTimeout = 3000;
        }
        return connectTimeout;
    }

    public int getServerReadTimeoutMs() {
        Integer connectTimeout = this.getGatewayConfig().getInteger(CONFIG_SERVER_READ_TIMEOUT);
        if (connectTimeout == null) {
            connectTimeout = 2000;
        }
        return connectTimeout;
    }

    public int getServerReceiveTimeoutMs() {
        Integer connectTimeout = this.getGatewayConfig().getInteger(CONFIG_SERVER_RECEIVE_TIMEOUT);
        if (connectTimeout == null) {
            connectTimeout = 4000;
        }
        return connectTimeout;
    }

    public int getMessageSendAttempts() {
        return 3;
    }

    public int getMessageReceiveAttempts() {
        return 2;
    }

    public int getWaitBeforeResendMs() {
        return 500;
    }

    private static ConfigurationException formatConfigurationException(String msg) {
        String errorPrefix = "Configuration problem: ";
        String errorSuffix = " Please check the CardSmith payment gateway config file.";
        return new ConfigurationException(errorPrefix + msg + errorSuffix);
    }

    private ApplicationInfo getApplicationInfo() {
        return ApplicationInfo.getInstance();
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public static enum PanLookupMode {
        INTERNAL_ID_NO,
        INTERNAL_ID_NO_EDITABLE,
        USER_INPUT,
        EXTERNAL_DATABASE,
        EXTERNAL_DATABASE_THEN_INTERNAL_ID_NO;

    }
}

