/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.dti;

import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.CardSmithDtiConfig;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.Message;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.ProtocolException;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.PurchaseResponse;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.util.NetworkUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardSmithDtiConnection {
    private static final Logger logger = LoggerFactory.getLogger(CardSmithDtiConnection.class);
    protected static final Object SEND_RECEIVE_LOCK = new Object();
    protected final AtomicInteger _sequenceNumber = new AtomicInteger(1);
    @Nullable
    private ApplicationLogManager _appLogManager;
    @Nullable
    private CardSmithDtiConfig _config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BalanceResponse getAvailableCredit(String pan) throws ConfigurationException, IOException, ProtocolException {
        Message response = null;
        int receiveAttempt = 0;
        int receiveAttempts = this.getConfig().getMessageReceiveAttempts();
        while (response == null && ++receiveAttempt <= receiveAttempts && !Thread.currentThread().isInterrupted()) {
            Object object = SEND_RECEIVE_LOCK;
            synchronized (object) {
                try (Socket socket = this.connect();){
                    int sequenceNumber = this._sequenceNumber.getAndIncrement();
                    String merchantId = this.getConfig().getMerchantId();
                    String terminalId = this.getConfig().getTerminalId();
                    String searchPathCode = this.getConfig().getSearchPathCode();
                    String applicationVersion = this.getConfig().getApplicationVersion();
                    Message request = Message.createOpenToBuyRequestMessage(pan, searchPathCode, sequenceNumber, terminalId, merchantId, applicationVersion);
                    this.sendWithRetry(socket, request);
                    try {
                        response = this.receive(socket);
                    }
                    catch (IOException ioe) {
                        GatewayUtils.LogHelper.logWarn(logger, "Unable to receive message from CardSmith server (attempt %d of %d): %s", receiveAttempt, receiveAttempts, ioe.getMessage());
                    }
                }
            }
        }
        if (response == null) {
            GatewayUtils.LogHelper.logError(logger, "Unable to communicate with CardSmith server. Please check CardSmith server connectivity or connection details.");
            throw new IOException("Unable to receive response from CardSmith server");
        }
        boolean success = response.isResultSuccess();
        String userMessage = success ? null : (String)response.getFields().get(Message.MessageField.DISPLAY_DATA);
        double availableCredit = success ? response.parseAvailableCredit() : 0.0;
        return new BalanceResponse(success, userMessage, availableCredit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PurchaseResponse performPurchase(String pan, double amount) throws ConfigurationException, IOException, ProtocolException {
        int amountInCents = GatewayUtils.roundDoubleDollarsToCents(amount);
        Message response = null;
        int receiveAttempt = 0;
        int receiveAttempts = this.getConfig().getMessageReceiveAttempts();
        while (response == null && ++receiveAttempt <= receiveAttempts && !Thread.currentThread().isInterrupted()) {
            Object object = SEND_RECEIVE_LOCK;
            synchronized (object) {
                try (Socket socket = this.connect();){
                    int sequenceNumber = this._sequenceNumber.getAndIncrement();
                    String merchantId = this.getConfig().getMerchantId();
                    String terminalId = this.getConfig().getTerminalId();
                    String searchPathCode = this.getConfig().getSearchPathCode();
                    String applicationVersion = this.getConfig().getApplicationVersion();
                    Message request = Message.createManualPurchaseRequestMessage(pan, amountInCents, searchPathCode, sequenceNumber, terminalId, merchantId, applicationVersion);
                    this.sendWithRetry(socket, request);
                    try {
                        response = this.receive(socket);
                    }
                    catch (IOException ioe) {
                        GatewayUtils.LogHelper.logWarn(logger, "Unable to receive message from CardSmith server (attempt " + receiveAttempt + " + of " + this.getConfig().getMessageReceiveAttempts() + ": " + ioe.getMessage());
                        this.reversePurchase(request);
                    }
                }
            }
        }
        if (response == null) {
            GatewayUtils.LogHelper.logError(logger, "Unable to communicate with CardSmith server. Please check CardSmith server connectivity or connection details.");
            throw new IOException("Unable to receive response from CardSmith server");
        }
        boolean success = response.isResultSuccess();
        String userMessage = success ? null : (String)response.getFields().get(Message.MessageField.DISPLAY_DATA);
        String retrievalReferenceNumber = (String)response.getFields().get(Message.MessageField.RETRIEVAL_REFERENCE_NUMBER);
        String approvalCode = (String)response.getFields().get(Message.MessageField.APPROVAL_CODE);
        return new PurchaseResponse(success, userMessage, retrievalReferenceNumber, approvalCode);
    }

    @GuardedBy(value="SEND_RECEIVE_LOCK")
    protected void reversePurchase(Message purchaseRequest) throws ConfigurationException {
        Object msg;
        Message response = null;
        try (Socket socket2 = this.connect();){
            Message reversal = Message.createManualPurchaseReversalRequestMessage(purchaseRequest);
            this.sendWithRetry(socket2, reversal);
            response = CardSmithDtiConnection.receive(socket2, this.getConfig().getServerReceiveTimeoutMs());
        }
        catch (ProtocolException | IOException socket2) {
            // empty catch block
        }
        if (response == null || !response.isResultSuccess()) {
            msg = "Failed to reverse a CardSmith purchase after communication failures. User may have paid for credit they did not receive. Further investigation is recommended. CardSmith reference number: " + (String)purchaseRequest.getFields().get(Message.MessageField.RETRIEVAL_REFERENCE_NUMBER);
            GatewayUtils.LogHelper.logError(logger, (String)msg, null, this.getApplicationLogManager());
            return;
        }
        msg = new StringBuilder("Successfully reversed CardSmith purchase.");
        if (!response.isResultSuccess()) {
            String resultCode = (String)response.getFields().get(Message.MessageField.RESULT_CODE);
            ((StringBuilder)msg).append(" Result code: ").append(resultCode).append(".");
        }
        ((StringBuilder)msg).append(" Reference number: ").append((String)response.getFields().get(Message.MessageField.RETRIEVAL_REFERENCE_NUMBER)).append(".");
        GatewayUtils.LogHelper.logInfo(logger, ((StringBuilder)msg).toString());
    }

    @GuardedBy(value="SEND_RECEIVE_LOCK")
    protected Socket connect() throws ConfigurationException, IOException {
        CardSmithDtiConfig config = this.getConfig();
        return CardSmithDtiConnection.connect(config.getServerHost(), config.getServerPort(), config.isServerSsl(), config.getServerConnectTimeoutMs(), config.getServerReadTimeoutMs());
    }

    @GuardedBy(value="SEND_RECEIVE_LOCK")
    private static Socket connect(String serverHost, int serverPort, boolean useSsl, int serverConnectTimeoutMs, int serverReadTimeoutMs) throws IOException {
        GatewayUtils.LogHelper.logDebug(logger, "Establishing new connection to %s:%d " + (useSsl ? "with" : "without") + " SSL.", serverHost, serverPort);
        try {
            SocketFactory socketFactory;
            if (useSsl) {
                try {
                    socketFactory = NetworkUtils.getTrustAllSSLSocketFactory();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            } else {
                socketFactory = SocketFactory.getDefault();
            }
            Socket socket = socketFactory.createSocket();
            socket.setSoTimeout(serverReadTimeoutMs);
            socket.setKeepAlive(true);
            socket.connect(new InetSocketAddress(serverHost, serverPort), serverConnectTimeoutMs);
            if (socket instanceof SSLSocket) {
                ((SSLSocket)socket).startHandshake();
            }
            return socket;
        }
        catch (IOException ioe) {
            GatewayUtils.LogHelper.logError(logger, "Unable to connect to CardSmith server. Please check CardSmith server connectivity or connection details.");
            throw new IOException("Unable to connect to CardSmith server", ioe);
        }
    }

    @GuardedBy(value="SEND_RECEIVE_LOCK")
    protected void sendWithRetry(Socket socket, Message request) throws IOException {
        CardSmithDtiConfig config = this.getConfig();
        CardSmithDtiConnection.sendWithRetry(socket, request, config.getMessageSendAttempts(), config.getWaitBeforeResendMs());
    }

    @GuardedBy(value="SEND_RECEIVE_LOCK")
    private static void sendWithRetry(Socket socket, Message request, int sendAttempts, int waitBeforeResendMs) throws IOException {
        boolean sendSuccess = false;
        int sendAttempt = 0;
        while (!sendSuccess && ++sendAttempt <= sendAttempts && !Thread.currentThread().isInterrupted()) {
            if (sendAttempt > 1) {
                try {
                    Thread.sleep(waitBeforeResendMs);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            try {
                String requestXml = request.toXml();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8));
                GatewayUtils.LogHelper.logDebug(logger, "> " + requestXml);
                try {
                    IOUtils.write((String)requestXml, (Writer)writer);
                    ((Writer)writer).flush();
                }
                catch (IOException ioe) {
                    throw new IOException("Error sending message to CardSmith: " + ioe.getMessage(), ioe);
                }
                sendSuccess = true;
            }
            catch (IOException ioe) {
                GatewayUtils.LogHelper.logWarn(logger, "Unable to send message to CardSmith server (attempt " + sendAttempt + " + of " + sendAttempts + ": " + ioe.getMessage());
            }
        }
        if (!sendSuccess) {
            GatewayUtils.LogHelper.logError(logger, "Unable to communicate with CardSmith server. Please check CardSmith server connectivity or connection details.");
            throw new IOException("Unable to send message to CardSmith server");
        }
    }

    @GuardedBy(value="SEND_RECEIVE_LOCK")
    protected Message receive(Socket socket) throws IOException, ProtocolException {
        CardSmithDtiConfig config = this.getConfig();
        return CardSmithDtiConnection.receive(socket, config.getServerReceiveTimeoutMs());
    }

    @GuardedBy(value="SEND_RECEIVE_LOCK")
    private static Message receive(Socket socket, int serverReceiveTimeoutMs) throws IOException, ProtocolException {
        InputStreamReader reader = new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8);
        StringBuilder responseXml = new StringBuilder();
        try (Socket socket2 = socket;){
            try {
                int i = -1;
                long startTime = System.currentTimeMillis();
                do {
                    if (System.currentTimeMillis() > startTime + (long)serverReceiveTimeoutMs) {
                        GatewayUtils.LogHelper.logWarn(logger, "Timed out while reading a response from CardSmith. Read so far: " + String.valueOf(responseXml));
                        throw new IOException("CardSmith message receive timeout");
                    }
                    i = ((Reader)reader).read();
                    if (i == -1) {
                        GatewayUtils.LogHelper.logWarn(logger, "CardSmith closed connection before reading a full message. Read: " + String.valueOf(responseXml));
                        throw new IOException("CardSmith connection closed while reading message");
                    }
                    responseXml.append((char)i);
                } while (!responseXml.toString().trim().endsWith("</isomsg>"));
            }
            catch (IOException ioe) {
                throw new IOException("Error communicating with CardSmith: " + ioe.getMessage(), ioe);
            }
        }
        catch (IOException ioe) {
            GatewayUtils.LogHelper.logWarn(logger, "Error closing connection to CardSmith: " + ioe.getMessage());
        }
        GatewayUtils.LogHelper.logDebug(logger, "< " + String.valueOf(responseXml));
        if (responseXml.isEmpty()) {
            throw new IOException("Received empty response from CardSmith.");
        }
        if (!responseXml.toString().endsWith("</isomsg>")) {
            throw new IOException("Received incomplete message from CardSmith.");
        }
        Message responseMessage = Message.valueOf(responseXml.toString());
        GatewayUtils.LogHelper.logDebug(logger, "< [parsed] " + String.valueOf(responseMessage));
        return responseMessage;
    }

    private ApplicationLogManager getApplicationLogManager() {
        return this._appLogManager;
    }

    void setApplicationLogManager(ApplicationLogManager appLogManager) {
        this._appLogManager = appLogManager;
    }

    protected CardSmithDtiConfig getConfig() {
        return this._config;
    }

    public void setConfig(CardSmithDtiConfig config) {
        this._config = config;
    }

    static EventLog getEventLog() {
        return EventLog.getInstance();
    }
}

