/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.dti;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.CardSmithDtiConfig;
import biz.papercut.pcng.service.ApplicationLogManager;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CardSmithDtiPanLookup {
    private static final Logger logger = LoggerFactory.getLogger(CardSmithDtiPanLookup.class);
    @Nullable
    private volatile ApplicationContext _ctx;
    @Nullable
    private CardSmithDtiConfig _config;
    @Nullable
    private volatile ComboPooledDataSource _dataSource = null;

    @CheckForNull
    public String getCardSmithPan(User user) {
        CardSmithDtiConfig.PanLookupMode mode;
        String pan = null;
        try {
            mode = this.getConfig().getPanLookupMode();
        }
        catch (ConfigurationException ce) {
            GatewayUtils.LogHelper.logError(logger, ce.getMessage());
            return null;
        }
        if (mode == CardSmithDtiConfig.PanLookupMode.EXTERNAL_DATABASE || mode == CardSmithDtiConfig.PanLookupMode.EXTERNAL_DATABASE_THEN_INTERNAL_ID_NO) {
            pan = this.lookUpCardSmithPanInDatabase(user);
        }
        if (pan == null && (mode == CardSmithDtiConfig.PanLookupMode.INTERNAL_ID_NO || mode == CardSmithDtiConfig.PanLookupMode.INTERNAL_ID_NO_EDITABLE || mode == CardSmithDtiConfig.PanLookupMode.EXTERNAL_DATABASE_THEN_INTERNAL_ID_NO)) {
            GatewayUtils.LogHelper.logDebug(logger, "Using internal user id number as CardSmith PAN");
            pan = StringUtils.trimToNull((String)user.getCardNumber());
            if (pan == null) {
                GatewayUtils.LogHelper.logWarn(logger, "Unable to determine CardSmith PAN for user %s", user.getUserName());
            }
        }
        return pan;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private String lookUpCardSmithPanInDatabase(User user) {
        GatewayUtils.LogHelper.logDebug(logger, "Looking up CardSmith PAN for user %s in database.", user.getUserName());
        try (Connection conn = this.createDbConnection();
             PreparedStatement stmt = this.createLookupSqlStatement(conn, user);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return null;
            String pan = rs.getString(1);
            if (rs.next()) {
                String nextPan = rs.getString(1);
                GatewayUtils.LogHelper.logDebug(logger, "CardSmith PAN lookup returned more than one result for user: %s. Match 1: %s, Match 2: %s, More matches? %s. Using first match.", user.getUserName(), pan, nextPan, rs.next());
            }
            GatewayUtils.LogHelper.logDebug(logger, "Found CardSmith PAN: %s for user: %s in lookup DB.", pan, user.getUserName());
            String string = pan;
            return string;
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Error occurred looking up CardSmith PAN in external database for user: %s. %s", e, this.getApplicationLogManager(), user.getUserName(), e.getMessage());
        }
        return null;
    }

    private PreparedStatement createLookupSqlStatement(Connection conn, User user) throws ConfigurationException {
        PreparedStatement stmt;
        String sqlTemplate = this.getConfig().getExternalDbPanLookupSqlTemplate();
        Matcher m = Pattern.compile("\\{\\s*(\\p{Alpha}+)\\s*\\}").matcher(sqlTemplate);
        GatewayUtils.LogHelper.logDebug(logger, "SQL template: %s", sqlTemplate);
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        while (m.find()) {
            String key;
            switch (key = m.group(1).trim().toLowerCase()) {
                case "username": {
                    params.add(user.getUserName());
                    break;
                }
                case "id": {
                    params.add(user.getCardNumber());
                    break;
                }
                case "fullname": {
                    params.add(user.getFullName());
                    break;
                }
                default: {
                    throw new RuntimeException("Configuration error - unexpected replacement in SQL: " + key);
                }
            }
            m.appendReplacement(sql, "?");
        }
        m.appendTail(sql);
        if (params.isEmpty()) {
            throw new ConfigurationException("Configuration error - CardSmith lookup SQL does not contain any parameters/replacements. SQL: " + sqlTemplate);
        }
        GatewayUtils.LogHelper.logDebug(logger, "Parsed SQL: \"%s\", params: %s", sql.toString(), params);
        try {
            stmt = conn.prepareStatement(sql.toString());
            if (stmt.getParameterMetaData().getParameterCount() != params.size()) {
                throw new ConfigurationException("Problem with replacements in card lookup SQL (cardsmith-dti.pan-lookup.db.sql). Ensure replacements are not quoted.");
            }
            for (int i = 0; i < params.size(); ++i) {
                stmt.setString(i + 1, (String)params.get(i));
            }
        }
        catch (SQLException sqle) {
            throw new ConfigurationException("Could not prepare external database PAN lookup SQL (cardsmith-dti.pan-lookup.db.sql). Please check configuration.");
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection createDbConnection() throws ConfigurationException {
        try {
            if (this._dataSource == null) {
                CardSmithDtiPanLookup cardSmithDtiPanLookup = this;
                synchronized (cardSmithDtiPanLookup) {
                    if (this._dataSource == null) {
                        this._dataSource = this.createDataSource();
                    }
                }
            }
            GatewayUtils.LogHelper.logDebug(logger, "Getting CardSmith external PAN lookup DB connection from: %s", this._dataSource.getDriverClass());
            return this._dataSource.getConnection();
        }
        catch (SQLException sqle) {
            throw new ConfigurationException("Unable to create database connection for CardSmith external PAN lookup: " + sqle.getMessage() + ". Please check configuration.");
        }
    }

    private ComboPooledDataSource createDataSource() throws ConfigurationException {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        String driverName = this.getConfig().getExternalDbPanLookupDriver();
        try {
            dataSource.setDriverClass(driverName);
        }
        catch (PropertyVetoException pve) {
            GatewayUtils.LogHelper.logError(logger, "Error loading CardSmith external database PAN lookup driver: %s, error: %s", pve, null, driverName, pve.getMessage());
            throw new ConfigurationException("Unable to configure database for CardSmith external database PAN lookup: " + driverName + ", error: " + pve.getMessage() + ". Please check configuration (cardsmith-dti.pan-lookup.db.driver)");
        }
        dataSource.setJdbcUrl(this.getConfig().getExternalDbPanLookupUrl());
        dataSource.setUser(this.getConfig().getExternalDbPanLookupUsername());
        dataSource.setPassword(this.getConfig().getExternalDbPanLookupPassword());
        dataSource.setInitialPoolSize(0);
        dataSource.setMinPoolSize(1);
        dataSource.setMaxPoolSize(50);
        dataSource.setMaxIdleTime(300);
        dataSource.setCheckoutTimeout(10000);
        dataSource.setAcquireIncrement(1);
        dataSource.setAcquireRetryAttempts(2);
        dataSource.setAcquireRetryDelay(500);
        return dataSource;
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    private CardSmithDtiConfig getConfig() {
        return this._config;
    }

    public void setConfig(CardSmithDtiConfig config) {
        this._config = config;
    }
}

