/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.dti;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.CardSmithDtiConfig;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.CardSmithDtiConnection;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.CardSmithDtiPanLookup;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.ExtnCardSmithDti;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.ProtocolException;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.PurchaseResponse;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CardSmithDtiPlugin
implements EnableablePlugin,
SpringContextPlugin,
UserLinkPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CardSmithDtiPlugin.class);
    private static final String PAYMENT_GATEWAY_PAGE_NAME = ExtnCardSmithDti.PAGE_NAME;
    private static final String TRANSACTION_SOURCE_NAME = "CardSmith";
    @AESProperty
    public static final String NOT_USE_CONFIG_PAN_LOOKUP_DB_PASSWORD = "cardsmith-dti.pan-lookup.db.password";
    private final CardSmithDtiConfig _config;
    private final CardSmithDtiConnection _connection;
    private final CardSmithDtiPanLookup _panLookup;
    @Nullable
    private volatile ApplicationContext _ctx;

    public CardSmithDtiPlugin() {
        CardSmithDtiConfig config = new CardSmithDtiConfig();
        CardSmithDtiConnection connection = new CardSmithDtiConnection();
        connection.setConfig(config);
        CardSmithDtiPanLookup cardLookup = new CardSmithDtiPanLookup();
        cardLookup.setConfig(config);
        this._config = config;
        this._connection = connection;
        this._panLookup = cardLookup;
    }

    public boolean isPluginEnabled() {
        return this.getConfig().isEnabled();
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.getConfig().isManualTransfersEnabled() && this.isManualTransferAccessibleByUser(username)) {
            return List.of(PAYMENT_GATEWAY_PAGE_NAME);
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return this._config.getManualTransfersPageTitle();
    }

    public BalanceResponse getBalance(User user, @Nullable String panOverride) {
        BalanceResponse response;
        try {
            String pan;
            String string = pan = panOverride == null ? this.getPanLookup().getCardSmithPan(user) : panOverride;
            if (pan == null) {
                return new BalanceResponse(false, "Unable to find account number.", 0.0);
            }
            response = this.getCardSmithConnection().getAvailableCredit(pan);
        }
        catch (ConfigurationException ce) {
            return new BalanceResponse(false, ce.getMessage(), 0.0);
        }
        catch (ProtocolException | IOException ioe) {
            GatewayUtils.LogHelper.logError(logger, "Error fetching CardSmith balance for user %s: %s", ioe, null, user.getUserName(), ioe.getMessage());
            return BalanceResponse.newGenericError();
        }
        return response;
    }

    public PurchaseResponse performPurchase(User user, @Nullable String panOverride, double amount) {
        PurchaseResponse response;
        String pan;
        try {
            String string = pan = panOverride == null ? this.getPanLookup().getCardSmithPan(user) : panOverride;
            if (pan == null) {
                return new PurchaseResponse(false, "Unable to find Transact SaaS account number. Please contact an administrator for assistance.", null, null);
            }
            response = this.getCardSmithConnection().performPurchase(pan, amount);
        }
        catch (ConfigurationException ce) {
            return new PurchaseResponse(false, ce.getMessage(), null, null);
        }
        catch (ProtocolException | IOException ioe) {
            GatewayUtils.LogHelper.logError(logger, "Error fetching CardSmith balance for user %s: %s", ioe, null, user.getUserName(), ioe.getMessage());
            return PurchaseResponse.newGenericError();
        }
        if (response.isSuccess()) {
            String usernameAndPan = user.getUserName() + "(" + pan + ")";
            CardSmithDtiPlugin.getEventLog().logTransaction(usernameAndPan, response.getRetrievalReferenceNumber(), amount, TRANSACTION_SOURCE_NAME, response.getApprovalCode());
        }
        return response;
    }

    public String getManualTransferTransactionComment() {
        Object txnComment = this.getConfig().getManualTransfersTransactionComment();
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public boolean isManualTransferAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        if (!this.getConfig().isManualTransfersEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, "cardsmith-dti.manual-transfers.allowed-groups", this.getUserManager());
    }

    public boolean isOnDemandTransferEnabledForUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        if (!this.getConfig().isOnDemandTransfersEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, "cardsmith-dti.on-demand-transfers.enabled-groups", this.getUserManager());
    }

    public String getOnDemandTransfersTransactionComment() {
        Object txnComment = this.getConfig().getOnDemandTransfersTransactionComment();
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenceManager(), "payment-gateways-cardsmith");
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
        this.getPanLookup().setApplicationContext(ctx);
    }

    protected CardSmithDtiPanLookup getPanLookup() {
        return this._panLookup;
    }

    protected CardSmithDtiConfig getConfig() {
        return this._config;
    }

    private CardSmithDtiConnection getCardSmithConnection() {
        return this._connection;
    }

    private static EventLog getEventLog() {
        return EventLog.getInstance();
    }

    private LicenseManager getLicenceManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }
}

