/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.dti;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.CardSmithDtiPlugin;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.PurchaseResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin4;
import biz.papercut.pcng.service.UserManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CardSmithDtiTopupAccountOnDemandPlugin
implements TopupAccountOnDemandPlugin4,
SpringContextPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CardSmithDtiTopupAccountOnDemandPlugin.class);
    private static final double ROUNDING_TOLERANCE = 1.0E-5;
    @Nullable
    private ApplicationContext _ctx;

    public boolean isPluginEnabled() {
        CardSmithDtiPlugin csp = CardSmithDtiTopupAccountOnDemandPlugin.getCardSmithDtiPlugin();
        return csp.isPluginEnabled() && csp.getConfig().isOnDemandTransfersEnabled();
    }

    public Map<String, Double> getBalance(Map<String, String> userDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        CardSmithDtiPlugin csp = CardSmithDtiTopupAccountOnDemandPlugin.getCardSmithDtiPlugin();
        if (!csp.getConfig().isBalanceDisplayEnabled()) {
            GatewayUtils.LogHelper.logDebug(logger, "CardSmith balance display disabled.");
            return null;
        }
        String username = userDetails.get("username");
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            GatewayUtils.LogHelper.logError(logger, "Unknown user: %s", username);
            return null;
        }
        BalanceResponse br = csp.getBalance(user, null);
        if (!br.isSuccess()) {
            GatewayUtils.LogHelper.logError(logger, "Unable to retrieve CardSmith balance for user \"%s\": %s", username, br.getUserMessage());
            return null;
        }
        HashMap<String, Double> balances = new HashMap<String, Double>();
        balances.put(csp.getConfig().getBalanceLabel(), br.getAvailableCredit());
        return balances;
    }

    @Nullable
    public TopupAccountOnDemandPlugin3.AvailableCredit getAvailableCreditForTopUp(String username, @Nullable String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            return null;
        }
        CardSmithDtiPlugin csp = CardSmithDtiTopupAccountOnDemandPlugin.getCardSmithDtiPlugin();
        if (!csp.isOnDemandTransferEnabledForUser(username)) {
            GatewayUtils.LogHelper.logDebug(logger, "CardSmith top-up on demand plugin not enabled for user \"%s\"", username);
            return null;
        }
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            GatewayUtils.LogHelper.logError(logger, "Unknown user: %s", username);
            return null;
        }
        BalanceResponse response = csp.getBalance(user, null);
        if (!response.isSuccess()) {
            GatewayUtils.LogHelper.logError(logger, "Error retrieving available credit for user \"%s\", response: %s", username, response);
            return null;
        }
        return new TopupAccountOnDemandPlugin3.AvailableCredit(false, response.getAvailableCredit());
    }

    public TopupAccountOnDemandPlugin.TopupResponse getTopup(double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            GatewayUtils.LogHelper.logDebug(logger, "CardSmith top-up on demand plugin not enabled for shared accounts.");
            return null;
        }
        double topupAmount = CardSmithDtiTopupAccountOnDemandPlugin.calcTopUpAmount(amountRequired);
        if (topupAmount <= 0.0) {
            return null;
        }
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            GatewayUtils.LogHelper.logDebug(logger, "Unknown user: %s", username);
            return null;
        }
        CardSmithDtiPlugin csp = CardSmithDtiTopupAccountOnDemandPlugin.getCardSmithDtiPlugin();
        if (!csp.isOnDemandTransferEnabledForUser(username)) {
            GatewayUtils.LogHelper.logDebug(logger, "CardSmith top-up on demand plugin not enabled for user \"%s\"", username);
            return null;
        }
        String txnComment = csp.getOnDemandTransfersTransactionComment();
        return GatewayUtils.performTopupDebit((TopupAccountOnDemandPlugin3)this, amount -> {
            PurchaseResponse pr = csp.performPurchase(user, null, amount);
            GatewayUtils.LogHelper.logDebug(logger, "Result: " + String.valueOf(pr));
            return pr.isSuccess() ? Double.valueOf(amount) : null;
        }, topupAmount, amountRequired, username, sharedAccount, accountCharged, usageDetails, txnComment);
    }

    private static double calcTopUpAmount(double amountRequired) {
        Double maxAmount;
        Double defaultAmount;
        if (amountRequired <= 0.0) {
            return 0.0;
        }
        CardSmithDtiPlugin csp = CardSmithDtiTopupAccountOnDemandPlugin.getCardSmithDtiPlugin();
        try {
            defaultAmount = csp.getConfig().getOnDemandTransfersDefaultTransferAmount();
            maxAmount = csp.getConfig().getOnDemandTransfersMaxTransferAmount();
        }
        catch (ConfigurationException ce) {
            GatewayUtils.LogHelper.logError(logger, "Invalid CardSmith top-up on demand configuration: " + ce.getMessage());
            return 0.0;
        }
        if (defaultAmount == null || maxAmount == null) {
            return 0.0;
        }
        double dollarsToRound = amountRequired - 1.0E-5;
        int cents = (int)Math.ceil(dollarsToRound * 100.0);
        double topupAmount = (double)cents / 100.0;
        if (defaultAmount > 0.0 && maxAmount > 0.0 && defaultAmount > maxAmount) {
            GatewayUtils.LogHelper.logWarn(logger, "CardSmith default transfer amount is greater than the max transfer amount. Using default transfer amount as max amount.");
            maxAmount = defaultAmount;
        }
        if (defaultAmount > 0.0 && amountRequired < defaultAmount) {
            GatewayUtils.LogHelper.logDebug(logger, "Using default transfer amount of " + defaultAmount);
            topupAmount = defaultAmount;
        }
        if (maxAmount > 0.0 && topupAmount > maxAmount) {
            GatewayUtils.LogHelper.logDebug(logger, "Transfer amount of " + topupAmount + " exceeds maximum of " + maxAmount);
            topupAmount = 0.0;
        }
        return topupAmount;
    }

    private static PluginManager getPluginManager() {
        return PluginManager.getInstance();
    }

    public ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private static CardSmithDtiPlugin getCardSmithDtiPlugin() {
        return (CardSmithDtiPlugin)CardSmithDtiTopupAccountOnDemandPlugin.getPluginManager().getPluginByClass(CardSmithDtiPlugin.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }
}

