/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.dti;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.CardSmithDtiConfig;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.CardSmithDtiPlugin;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.PurchaseResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnCardSmithDti
extends BasePaperCutPage
implements PageRenderListener {
    private static final Logger logger = LoggerFactory.getLogger(ExtnCardSmithDti.class);
    public static final String PAGE_NAME = ExtnCardSmithDti.class.getSimpleName();

    @Nullable
    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract Double getCardSmithBalance();

    public abstract void setCardSmithBalance(Double var1);

    @CheckForNull
    public abstract String getPan();

    public abstract void setPan(@Nullable String var1);

    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    @Nullable
    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract void setShowPanInput(boolean var1);

    public abstract void setFatalError(boolean var1);

    public abstract AccountManager getAccountManager();

    public abstract CreditSourceManager getCreditSourceManager();

    public abstract UserManager getUserManager();

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = ExtnCardSmithDti.getCardSmithPlugin().getConfig().getManualTransfersPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public String getHeading() {
        return ExtnCardSmithDti.getCardSmithPlugin().getConfig().getManualTransfersPageHeading();
    }

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUserUnconditional().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        CardSmithDtiConfig.PanLookupMode mode;
        User user = this.getUserManager().getUser(this.getPaperCutVisit().getUserName());
        if (user == null) {
            throw new RuntimeException("Unknown user: " + this.getPaperCutVisit().getUserName());
        }
        this.setUser(user);
        if (this.getAmountsModel() == null) {
            IPropertySelectionModel model = GatewayUtils.createAllowedAmountsModel("cardsmith-dti.manual-transfers.allowed-amounts", (BasePaperCutPage)this);
            if (model.getOptionCount() <= 1) {
                this.addErrorMessage("Invalid list of allowed transfer amounts. Please check the option cardsmith-dti.manual-transfers.allowed-amounts in the CardSmith payment gateway config file.");
            }
            this.setAmountsModel(model);
        }
        try {
            mode = ExtnCardSmithDti.getCardSmithPlugin().getConfig().getPanLookupMode();
        }
        catch (ConfigurationException ce) {
            this.addWarningMessage(ce.getMessage());
            GatewayUtils.LogHelper.logError(logger, ce.getMessage());
            return;
        }
        if (mode == CardSmithDtiConfig.PanLookupMode.USER_INPUT || mode == CardSmithDtiConfig.PanLookupMode.INTERNAL_ID_NO_EDITABLE) {
            this.setShowPanInput(true);
        }
        if (!this.getRequestCycle().isRewinding()) {
            if (!ExtnCardSmithDti.getCardSmithPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            try {
                ExtnCardSmithDti.getCardSmithPlugin().getConfig().checkConfiguration();
            }
            catch (ConfigurationException ce) {
                this.addWarningMessage(ce.getMessage());
                GatewayUtils.LogHelper.logError(logger, ce.getMessage());
                return;
            }
            String pan = this.getPan();
            if (mode != CardSmithDtiConfig.PanLookupMode.USER_INPUT && StringUtils.isBlank((String)pan)) {
                pan = ExtnCardSmithDti.getCardSmithPlugin().getPanLookup().getCardSmithPan(this.getUserUnconditional());
                if (StringUtils.isBlank((String)pan)) {
                    this.addErrorMessage(ExtnCardSmithDti.getCardSmithPlugin().getConfig().getManualTransfersUserErrorMessage() + " (Account number not found)");
                    this.setFatalError(true);
                    return;
                }
                if (mode == CardSmithDtiConfig.PanLookupMode.INTERNAL_ID_NO_EDITABLE) {
                    this.setPan(pan);
                }
            }
            if (ExtnCardSmithDti.getCardSmithPlugin().getConfig().isManualTransfersShowBalance()) {
                BalanceResponse br = ExtnCardSmithDti.getCardSmithPlugin().getBalance(user, pan);
                if (br.isSuccess()) {
                    this.setCardSmithBalance(br.getAvailableCredit());
                } else {
                    String userMessage = br.getUserMessage();
                    if (userMessage != null) {
                        this.addWarningMessage(userMessage);
                    }
                }
            }
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        User user = this.getUserUnconditional();
        ValidationDelegate delegate = (ValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            this.addErrorMessage(delegate.getFirstError().toString());
            return;
        }
        if (!this.isAccessibleByUser()) {
            this.addErrorMessage("You do not have permission to access this feature.");
            return;
        }
        if (this.getAmount() == null || this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select the amount to transfer to your account.");
            return;
        }
        double amount = this.getAmount();
        boolean success = false;
        Object errorSuffix = "";
        try {
            String panOverride = StringUtils.trimToNull((String)this.getPan());
            PurchaseResponse response = ExtnCardSmithDti.getCardSmithPlugin().performPurchase(user, panOverride, amount);
            if (response.isSuccess()) {
                String txnComment = ExtnCardSmithDti.getCardSmithPlugin().getManualTransferTransactionComment();
                GatewayUtils.addCreditToUser(this.getAccountManager(), this.getCreditSourceManager(), this.getUser(), amount, txnComment);
                this.addStatusMessage(this.formatBalance(amount) + " was successfully added to your account.");
                cycle.activate("UserSummary");
                success = true;
            } else {
                errorSuffix = (String)errorSuffix + " (Transaction declined: " + response.getUserMessage() + ")";
            }
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Unexpected error performing CardSmith debit transaction for user %s", user.getUserName(), e);
        }
        if (!success) {
            this.addErrorMessage(ExtnCardSmithDti.getCardSmithPlugin().getConfig().getManualTransfersUserErrorMessage() + (String)errorSuffix);
        }
    }

    public boolean isAccessibleByUser() {
        return ExtnCardSmithDti.getCardSmithPlugin().isManualTransferAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public String getNoAccessMsg() {
        return ExtnCardSmithDti.getGatewayConfig().getNoAccessMessage();
    }

    public String getUserAndFullName() {
        User user = this.getUserUnconditional();
        StringBuilder s = new StringBuilder();
        s.append(user.getUserName());
        if (StringUtils.isNotBlank((String)user.getFullName())) {
            s.append(" (");
            s.append(user.getFullName());
            s.append(")");
        }
        return s.toString();
    }

    public String getCardSmithBalanceLabel() {
        return ExtnCardSmithDti.getCardSmithPlugin().getConfig().getBalanceLabel();
    }

    public boolean isPageMessageAvailable() {
        return ExtnCardSmithDti.getGatewayConfig().getPageMessageAvailable();
    }

    public String getPageMessage() {
        return ExtnCardSmithDti.getGatewayConfig().getPageMessage();
    }

    public String getPanLookupUserInputLabel() {
        return ExtnCardSmithDti.getCardSmithPlugin().getConfig().getPanLookupUserInputLabel();
    }

    private User getUserUnconditional() {
        User user = this.getUser();
        if (user == null) {
            throw new RuntimeException("Unknown user: " + this.getPaperCutVisit().getUserName());
        }
        return user;
    }

    private static CardSmithDtiPlugin getCardSmithPlugin() {
        return (CardSmithDtiPlugin)PluginManager.getInstance().getPluginByClass(CardSmithDtiPlugin.class);
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }
}

