/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.dti;

import biz.papercut.pcng.ext.paymentgateway.cardsmith.dti.ProtocolException;
import biz.papercut.pcng.util.ObjectUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.znerd.xmlenc.XMLOutputter;

public class Message {
    private static final int SEQUENCE_NUMBER_LENGTH = 6;
    private static final int AMOUNT_TRANSACTION_LENGTH = 12;
    private static final String POS_ENTRY_MODE_UNKNOWN_NO_PIN = "002";
    private static final Format TRANSMISSION_TIMESTAMP_FORMATTER = new SimpleDateFormat("MMddHHmmss");
    private static final Format EXPIRATION_DATE_FORMATTER = new SimpleDateFormat("yyMM");
    private static final String MTI_INQUIRY_REQUEST = "0100";
    private static final String PROCESSING_CODE_OTB_TRANSACTION_TYPE = "32";
    private static final String MTI_PURCHASE_REQUEST = "0200";
    private static final String MTI_PURCHASE_REVERSAL_REQUEST = "0400";
    private static final String MTI_PURCHASE_REVERSAL_ORIGINAL_PURCHASE_REQUEST = "200";
    private static final String PROCESSING_CODE_PURCHASE_REVERSAL_TRANSACTION_TYPE = "00";
    private static final String PROCESSING_CODE_PURCHASE_TRANSACTION_TYPE = "00";
    private static final String PROCESSING_CODE_RESERVED_DIGITS = "00";
    private static final String CARDSMITH_DTI_PROTOCOL_VERSION = "DTI XML 2.0.4";
    private static final String RESULT_CODE_SUCCESS = "00";
    private final SortedMap<MessageField, String> _fields;

    public Message(Map<MessageField, String> fields) {
        TreeMap<MessageField, String> f = new TreeMap<MessageField, String>(fields);
        this._fields = Collections.unmodifiableSortedMap(f);
    }

    public SortedMap<MessageField, String> getFields() {
        return this._fields;
    }

    public String getSearchPathCode() {
        String processingCode = (String)this.getFields().get(MessageField.PROCESSING_CODE);
        return StringUtils.substring((String)processingCode, (int)2, (int)4);
    }

    public boolean isResultSuccess() {
        return "00".equals(this.getFields().get(MessageField.RESULT_CODE));
    }

    @Nullable
    public Double parseAvailableCredit() throws ProtocolException {
        double availableCredit;
        String value = (String)this.getFields().get(MessageField.BALANCE_INFORMATION);
        if (value == null) {
            return null;
        }
        try {
            availableCredit = Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw new ProtocolException("Unexpected value for balance: " + value);
        }
        return availableCredit;
    }

    public String toXml() {
        StringWriter sw = new StringWriter();
        try {
            XMLOutputter outputter = new XMLOutputter((Writer)sw, "UTF-8");
            outputter.startTag("isomsg");
            for (Map.Entry<MessageField, String> e : this.getFields().entrySet()) {
                outputter.startTag("field");
                outputter.attribute("id", String.valueOf(e.getKey().getFieldId()));
                outputter.attribute("value", e.getValue());
                outputter.endTag();
            }
            outputter.endTag();
            outputter.endDocument();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        sw.write("\n");
        return sw.toString();
    }

    public String toString() {
        ToStringBuilder tsb = ObjectUtils.createToStringBuilder((Object)this);
        for (Map.Entry<MessageField, String> e : this.getFields().entrySet()) {
            tsb.append(e.getKey().toString(), (Object)e.getValue());
        }
        return tsb.toString();
    }

    public static Message valueOf(String xml) throws ProtocolException {
        Document doc;
        EnumMap<MessageField, String> fields = new EnumMap<MessageField, String>(MessageField.class);
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(IOUtils.toInputStream((String)xml, (String)"UTF-8"));
        }
        catch (Exception e) {
            throw new ProtocolException("Unable to parse CardSmith response message", e);
        }
        doc.getDocumentElement().normalize();
        NodeList fieldNodes = doc.getDocumentElement().getElementsByTagName("field");
        for (int i = 0; i < fieldNodes.getLength(); ++i) {
            Element e = (Element)fieldNodes.item(i);
            int id = Integer.parseInt(e.getAttribute("id"));
            MessageField field = MessageField.valueOf(id);
            String value = e.getAttribute("value");
            if (field == null) continue;
            fields.put(field, value);
        }
        return new Message(fields);
    }

    public static Message createOpenToBuyRequestMessage(String pan, String searchPathCode, int sequenceNumber, String terminalId, String merchantId, String applicationVersion) {
        String processingCode = PROCESSING_CODE_OTB_TRANSACTION_TYPE + searchPathCode + "00";
        String transmissionDateTime = TRANSMISSION_TIMESTAMP_FORMATTER.format(new Date());
        String formattedSequenceNumber = StringUtils.leftPad((String)String.valueOf(sequenceNumber), (int)6, (char)'0');
        String expirationDate = Message.makeFudgedExpirationDate();
        String terminalSoftwareVersion = applicationVersion + "^DTI XML 2.0.4";
        EnumMap<MessageField, String> fields = new EnumMap<MessageField, String>(MessageField.class);
        fields.put(MessageField.MESSAGE_TYPE_INDICATOR, MTI_INQUIRY_REQUEST);
        fields.put(MessageField.PRIMARY_ACCOUNT_NUMBER, pan);
        fields.put(MessageField.PROCESSING_CODE, processingCode);
        fields.put(MessageField.TRANSMISSION_DATE_TIME, transmissionDateTime);
        fields.put(MessageField.SYSTEM_TRACE_AUDIT_NUMBER, formattedSequenceNumber);
        fields.put(MessageField.EXPIRATION_DATE, expirationDate);
        fields.put(MessageField.POINT_OF_SERVICE_ENTRY_MODE, POS_ENTRY_MODE_UNKNOWN_NO_PIN);
        fields.put(MessageField.CARD_ACCEPTOR_TERMINAL_ID, terminalId);
        fields.put(MessageField.CARD_ACCEPTOR_IDENTIFICATION_CODE, merchantId);
        fields.put(MessageField.TERMINAL_SOFTWARE_VERSION, terminalSoftwareVersion);
        return new Message(fields);
    }

    public static Message createManualPurchaseRequestMessage(String pan, int amountInCents, String searchPathCode, int sequenceNumber, String terminalId, String merchantId, String applicationVersion) {
        String processingCode = "00" + searchPathCode + "00";
        String amountInCentsFormatted = StringUtils.leftPad((String)String.valueOf(amountInCents), (int)12, (char)'0');
        String transmissionDateTime = TRANSMISSION_TIMESTAMP_FORMATTER.format(new Date());
        String formattedSequenceNumber = StringUtils.leftPad((String)String.valueOf(sequenceNumber), (int)6, (char)'0');
        String terminalSoftwareVersion = applicationVersion + "^DTI XML 2.0.4";
        EnumMap<MessageField, String> fields = new EnumMap<MessageField, String>(MessageField.class);
        fields.put(MessageField.MESSAGE_TYPE_INDICATOR, MTI_PURCHASE_REQUEST);
        fields.put(MessageField.PRIMARY_ACCOUNT_NUMBER, pan);
        fields.put(MessageField.PROCESSING_CODE, processingCode);
        fields.put(MessageField.AMOUNT_TRANACTION, amountInCentsFormatted);
        fields.put(MessageField.TRANSMISSION_DATE_TIME, transmissionDateTime);
        fields.put(MessageField.SYSTEM_TRACE_AUDIT_NUMBER, formattedSequenceNumber);
        fields.put(MessageField.POINT_OF_SERVICE_ENTRY_MODE, POS_ENTRY_MODE_UNKNOWN_NO_PIN);
        fields.put(MessageField.CARD_ACCEPTOR_TERMINAL_ID, terminalId);
        fields.put(MessageField.CARD_ACCEPTOR_IDENTIFICATION_CODE, merchantId);
        fields.put(MessageField.TERMINAL_SOFTWARE_VERSION, terminalSoftwareVersion);
        return new Message(fields);
    }

    public static Message createManualPurchaseReversalRequestMessage(Message originalPurchaseRequest) {
        String processingCode = "00" + originalPurchaseRequest.getSearchPathCode() + "00";
        EnumMap<MessageField, String> fields = new EnumMap<MessageField, String>(MessageField.class);
        SortedMap<MessageField, String> originalFields = originalPurchaseRequest.getFields();
        fields.put(MessageField.MESSAGE_TYPE_INDICATOR, MTI_PURCHASE_REVERSAL_REQUEST);
        fields.put(MessageField.PRIMARY_ACCOUNT_NUMBER, (String)originalFields.get(MessageField.PRIMARY_ACCOUNT_NUMBER));
        fields.put(MessageField.PROCESSING_CODE, processingCode);
        fields.put(MessageField.AMOUNT_TRANACTION, (String)originalFields.get(MessageField.AMOUNT_TRANACTION));
        fields.put(MessageField.TRANSMISSION_DATE_TIME, (String)originalFields.get(MessageField.TRANSMISSION_DATE_TIME));
        fields.put(MessageField.SYSTEM_TRACE_AUDIT_NUMBER, (String)originalFields.get(MessageField.SYSTEM_TRACE_AUDIT_NUMBER));
        fields.put(MessageField.POINT_OF_SERVICE_ENTRY_MODE, (String)originalFields.get(MessageField.POINT_OF_SERVICE_ENTRY_MODE));
        fields.put(MessageField.CARD_ACCEPTOR_TERMINAL_ID, (String)originalFields.get(MessageField.CARD_ACCEPTOR_TERMINAL_ID));
        fields.put(MessageField.CARD_ACCEPTOR_IDENTIFICATION_CODE, (String)originalFields.get(MessageField.CARD_ACCEPTOR_IDENTIFICATION_CODE));
        fields.put(MessageField.ORIGINAL_MESSAGE_TYPE_INDICATOR, MTI_PURCHASE_REVERSAL_ORIGINAL_PURCHASE_REQUEST);
        fields.put(MessageField.TERMINAL_SOFTWARE_VERSION, (String)originalFields.get(MessageField.TERMINAL_SOFTWARE_VERSION));
        return new Message(fields);
    }

    private static String makeFudgedExpirationDate() {
        Calendar c = Calendar.getInstance();
        c.roll(1, 10);
        return EXPIRATION_DATE_FORMATTER.format(c.getTime());
    }

    public static enum MessageField implements Comparable<MessageField>
    {
        MESSAGE_TYPE_INDICATOR(0),
        PRIMARY_ACCOUNT_NUMBER(2),
        PROCESSING_CODE(3),
        AMOUNT_TRANACTION(4),
        TRANSMISSION_DATE_TIME(7),
        SYSTEM_TRACE_AUDIT_NUMBER(11),
        EXPIRATION_DATE(14),
        POINT_OF_SERVICE_ENTRY_MODE(22),
        RETRIEVAL_REFERENCE_NUMBER(37),
        APPROVAL_CODE(38),
        RESULT_CODE(39),
        CARD_ACCEPTOR_TERMINAL_ID(41),
        CARD_ACCEPTOR_IDENTIFICATION_CODE(42),
        ORIGINAL_MESSAGE_TYPE_INDICATOR(56),
        TERMINAL_SOFTWARE_VERSION(60),
        BALANCE_INFORMATION(62),
        DISPLAY_DATA(63);

        private final int _fieldId;

        private MessageField(int fieldId) {
            this._fieldId = fieldId;
        }

        public int getFieldId() {
            return this._fieldId;
        }

        public String toString() {
            return this.name() + "[id=" + this._fieldId + "]";
        }

        @Nullable
        public static MessageField valueOf(int fieldId) {
            for (MessageField field : MessageField.values()) {
                if (field.getFieldId() != fieldId) continue;
                return field;
            }
            return null;
        }
    }
}

