/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx;

import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx.CardSmithResponse;
import biz.papercut.pcng.util.NetworkUtils;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardSmithConnector {
    private static final Logger logger = LoggerFactory.getLogger(CardSmithConnector.class);
    private static final String FIELD_SEPARATOR = String.valueOf('\u001c');
    private static final int TRANSACTION_SEQUENCE_NUMBER_LENGTH = 6;
    private static final char CUSTOMER_DATA_FIELD_SEPARATOR = '\u001d';
    private static final String CUSTOMER_DATA_FIELD_CVV = "00    ";
    private static final int READ_TIMEOUT_MS = 15000;
    private static final AtomicInteger TRANSACTION_SEQUENCE_NUMBER = new AtomicInteger(1);
    private static final DateFormat EXPIRY_DATE_FORMATTER = new SimpleDateFormat("MMyy");
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("MMddyyyy");
    private static final DateFormat TIME_FORMATTER = new SimpleDateFormat("HHmmss");

    public CardSmithResponse performTransactionRequest(String cardNumber, double amount) throws Exception {
        String line;
        if (logger.isDebugEnabled()) {
            logger.debug("Sending CardSmith transaction request.  Card number: {}, amount: {}", (Object)cardNumber, (Object)amount);
        }
        StringBuilder responseString = new StringBuilder();
        try {
            NetworkUtils.setupHTTPSToIgnoreHostnameAndTrustErrors();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String data = "Transaction=" + this.formatTransactionRequestString(cardNumber, amount);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending transaction string to CardSmith: {}", (Object)data);
        }
        URLConnection urlConn = this.getGatewayConfig().getURL("cardsmith.post-url").openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setReadTimeout(15000);
        DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
        printout.writeBytes(data);
        IOUtils.closeQuietly((OutputStream)printout);
        InputStream is = urlConn.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            responseString.append(line);
        }
        IOUtils.closeQuietly((Reader)reader);
        if (logger.isDebugEnabled()) {
            logger.debug("Received CardSmith transaction response string: {}", (Object)responseString);
        }
        CardSmithResponse response = null;
        try {
            response = new CardSmithResponse(responseString.toString());
            if (logger.isDebugEnabled()) {
                logger.debug("CardSmith transaction response parsed as: {}", (Object)response);
            }
        }
        catch (IllegalArgumentException iae) {
            logger.error("Unable to parse CardSmith transaction response: {}", (Object)iae.getMessage());
            throw iae;
        }
        return response;
    }

    private String formatTransactionRequestString(String cardNumber, double amount) {
        StringBuilder sb = new StringBuilder();
        Date transactionTime = new Date();
        int currencyDecimalPlaces = this.getGatewayConfig().getInteger("cardsmith.currency-decimal-places");
        String amountStr = String.valueOf((int)(amount * Math.pow(10.0, currencyDecimalPlaces)));
        sb.append("IPS");
        sb.append(".");
        sb.append("123456");
        sb.append(FIELD_SEPARATOR);
        sb.append("02");
        sb.append("200");
        sb.append("0");
        sb.append(this.getGatewayConfig().getString("cardsmith.merchant-id"));
        sb.append(FIELD_SEPARATOR);
        sb.append(this.getGatewayConfig().getString("cardsmith.terminal-id"));
        sb.append(FIELD_SEPARATOR);
        sb.append("UR");
        sb.append("000001");
        sb.append(CardSmithConnector.generateTransactionSequenceNumber());
        sb.append("C");
        sb.append("U");
        sb.append("00");
        sb.append("@");
        sb.append("T");
        sb.append(this.getGatewayConfig().getString("cardsmith.time-zone-differential"));
        sb.append(this.formatCustomerDataField(cardNumber));
        sb.append(FIELD_SEPARATOR);
        sb.append("H");
        sb.append(FIELD_SEPARATOR);
        sb.append("Y");
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        sb.append(amountStr);
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        sb.append("7338");
        sb.append(FIELD_SEPARATOR);
        sb.append(this.getGatewayConfig().getString("cardsmith.currency-number"));
        sb.append(FIELD_SEPARATOR);
        sb.append("U");
        sb.append(FIELD_SEPARATOR);
        sb.append("N");
        sb.append(CardSmithConnector.getDateFormatter().format(transactionTime));
        sb.append(CardSmithConnector.getTimeFormatter().format(transactionTime));
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        sb.append(FIELD_SEPARATOR);
        return URLEncoder.encode(sb.toString(), StandardCharsets.UTF_8);
    }

    private static String generateTransactionSequenceNumber() {
        int i = TRANSACTION_SEQUENCE_NUMBER.getAndIncrement();
        if (String.valueOf(i).length() > 6) {
            TRANSACTION_SEQUENCE_NUMBER.set(1);
            i = TRANSACTION_SEQUENCE_NUMBER.getAndIncrement();
        }
        return StringUtils.leftPad((String)String.valueOf(i), (int)6, (char)'0');
    }

    private String formatCustomerDataField(String cardNumber) {
        Calendar oneYearFromNow = Calendar.getInstance();
        oneYearFromNow.add(1, 1);
        String expirationDate = CardSmithConnector.getExpiryDateFormatter().format(oneYearFromNow.getTime());
        return cardNumber + "\u001d" + expirationDate + "\u001d00    \u001d";
    }

    private static DateFormat getExpiryDateFormatter() {
        return EXPIRY_DATE_FORMATTER;
    }

    private static DateFormat getDateFormatter() {
        return DATE_FORMATTER;
    }

    private static DateFormat getTimeFormatter() {
        return TIME_FORMATTER;
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }
}

