/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx;

import biz.papercut.pcng.domain.Group;
import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx.CardNumberEntryMode;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx.CardSmithConnector;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx.CardSmithResponse;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx.ExtnCardSmithIpsx;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import java.net.MalformedURLException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CardSmithPlugin
implements UserLinkPlugin,
SpringContextPlugin,
EnableablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(CardSmithPlugin.class);
    private static final List<String> PAGES = List.of(ExtnCardSmithIpsx.PAGE_NAME);
    private static final String CONFIG_PREFIX = "cardsmith.";
    public static final String CONFIG_ENABLED = "cardsmith.enabled";
    public static final String CONFIG_CARD_ACCEPTOR_ID = "cardsmith.merchant-id";
    public static final String CONFIG_CARD_ACCEPTOR_TERMINAL_ID = "cardsmith.terminal-id";
    public static final String CONFIG_CARD_NUMBER_ENTRY_MODE = "cardsmith.card-number-entry-mode";
    public static final String CONFIG_ERROR_WHEN_NO_CARD_NUMBER = "cardsmith.error-when-no-card-number";
    public static final String CONFIG_CURRENCY_DECIMAL_PLACES = "cardsmith.currency-decimal-places";
    public static final String CONFIG_CURRENCY_NUMBER = "cardsmith.currency-number";
    public static final String CONFIG_POST_URL = "cardsmith.post-url";
    public static final String CONFIG_TIME_ZONE_DIFFERENTIAL = "cardsmith.time-zone-differential";
    public static final String CONFIG_PAGE_TITLE = "cardsmith.page-title";
    public static final String CONFIG_PAGE_HEADING = "cardsmith.page-heading";
    public static final String CONFIG_ALLOWED_GROUPS = "cardsmith.allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "cardsmith.allowed-amounts";
    @Nullable
    private ApplicationContext _applicationContext;
    private final CardSmithConnector _cardSmithConnector = new CardSmithConnector();

    public boolean isPluginEnabled() {
        Boolean enabled = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-cardsmith");
    }

    @CheckForNull
    public String getIsConfigured() {
        String logErrorPrefix = "Invalid configuration: ";
        String displayErrorSuffix = "  Please check the payment gateway config file.";
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_CARD_ACCEPTOR_ID))) {
            EventLog.getInstance().logEvent(logErrorPrefix + "Merchant ID must not be blank.");
            return "Merchant ID must not be blank." + displayErrorSuffix;
        }
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_CARD_ACCEPTOR_TERMINAL_ID))) {
            EventLog.getInstance().logEvent(logErrorPrefix + "Terminal ID must not be blank.");
            return "Terminal ID must not be blank." + displayErrorSuffix;
        }
        try {
            this.getCardNumberEntryMode();
        }
        catch (Exception e) {
            EventLog.getInstance().logEvent(logErrorPrefix + "Card number entry mode '" + this.getGatewayConfig().getString("cardsmith.card-number-entry-mode' not valid."));
            return "Invalid card number entry mode." + displayErrorSuffix;
        }
        try {
            Integer.valueOf(this.getGatewayConfig().getString(CONFIG_CURRENCY_DECIMAL_PLACES));
        }
        catch (NumberFormatException nfe) {
            EventLog.getInstance().logEvent("Invalid number of decimal places for currency: " + this.getGatewayConfig().getString(CONFIG_CURRENCY_DECIMAL_PLACES) + ".");
            return "Invalid number of decimal places for currency." + displayErrorSuffix;
        }
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_TIME_ZONE_DIFFERENTIAL))) {
            EventLog.getInstance().logEvent("Time zone differential must not be blank.");
            return "Time zone differential must not be blank." + displayErrorSuffix;
        }
        try {
            this.getGatewayConfig().getURL(CONFIG_POST_URL);
        }
        catch (MalformedURLException murle) {
            EventLog.getInstance().logEvent("POST URL '" + this.getGatewayConfig().getString(CONFIG_POST_URL) + "' not valid.");
            return "POST URL not valid." + displayErrorSuffix;
        }
        return null;
    }

    public boolean isAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        User u = null;
        if (StringUtils.isNotBlank((String)username)) {
            u = this.getUserManager().getUser(username);
        }
        if (u == null) {
            logger.debug("Unable to find user: {}", (Object)username);
            return false;
        }
        GatewayConfig conf = GatewayConfig.getInstance();
        List<String> allowedGroups = conf.getStringList(CONFIG_ALLOWED_GROUPS);
        if (allowedGroups.isEmpty()) {
            return true;
        }
        for (Group group : u.getGroups()) {
            for (String allowedGroup : allowedGroups) {
                if (!allowedGroup.equalsIgnoreCase(group.getGroupName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_TITLE));
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    public CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)PluginManager.getInstance().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    public String createNewOrder(String username, double amount, String returnURL) {
        return this.getCreditCardGatewayPlugin().createNewOrder(username, amount);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    public GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public TransactionResponse withdrawCredit(String userName, String cardNumber, double amount, String remoteAddr) {
        CreditCardGatewayPlugin ccgp = this.getCreditCardGatewayPlugin();
        String orderId = ccgp.createNewOrder(userName, amount);
        CardSmithResponse response = null;
        try {
            response = this.getCardSmithConnector().performTransactionRequest(cardNumber, amount);
        }
        catch (Exception e) {
            String msg = "Error communicating with CardSmith POST URL: " + e.getMessage() + ".  Canceling order " + orderId + ".";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg, (Throwable)e);
            ccgp.cancelOrder(orderId);
            return new TransactionResponse(false, msg);
        }
        if (!response.isApproved()) {
            EventLog.getInstance().logEvent("CardSmith reported failed transaction for order id " + orderId + ", card number: " + cardNumber + ".  Cancelling order.  Remote address: " + remoteAddr + ", user: " + userName);
            ccgp.cancelOrder(orderId);
            return new TransactionResponse(false, null);
        }
        EventLog.getInstance().logEvent("CardSmith reported successful transaction for order id " + orderId + ", approval code: " + response.getApprovalCode() + ", card number: " + cardNumber + ".  Completing order.  Remote address: " + remoteAddr + ", user: " + userName);
        CreditCardGatewayPlugin.OrderResponse orderResponse = ccgp.confirmOrder(orderId, amount);
        if (!orderResponse.isSuccess()) {
            String msg = "Could not confirm order " + orderId + ", message: " + orderResponse.getMessage();
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            return new TransactionResponse(false, msg);
        }
        EventLog.getInstance().logEvent("Order " + orderId + " confirmed");
        return new TransactionResponse(true, null);
    }

    public CardNumberEntryMode getCardNumberEntryMode() throws IllegalArgumentException {
        return CardNumberEntryMode.valueOfCode(this.getGatewayConfig().getString(CONFIG_CARD_NUMBER_ENTRY_MODE));
    }

    private CardSmithConnector getCardSmithConnector() {
        return this._cardSmithConnector;
    }

    public static class TransactionResponse {
        private final boolean _success;
        @CheckForNull
        private final String _message;

        public TransactionResponse(boolean success, @Nullable String message) {
            this._success = success;
            this._message = message;
        }

        public boolean isSuccess() {
            return this._success;
        }

        @CheckForNull
        public String getMessage() {
            return this._message;
        }
    }
}

