/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardSmithResponse {
    private static final Logger logger = LoggerFactory.getLogger(CardSmithResponse.class);
    private static final Pattern RESPONSE_CODE_PATTERN = Pattern.compile("^(?:.+?\\x1C){3}.{7}(.{2}).+$");
    private static final Pattern APPROVAL_CODE_PATTERN = Pattern.compile("^(?:.+?\\x1C){3}.{9}(\\d{6}).+$");
    private static final String RESPONSE_CODE_APPROVED = "00";
    private boolean _approved;
    @CheckForNull
    private String _approvalCode;

    public CardSmithResponse(String responseString) throws IllegalArgumentException {
        this.parseResponseString(responseString);
    }

    private void parseResponseString(String responseString) throws IllegalArgumentException {
        Matcher m = RESPONSE_CODE_PATTERN.matcher(responseString);
        if (!m.matches() || m.groupCount() < 1) {
            throw new IllegalArgumentException("Response code could not be found in response string");
        }
        String responseCode = m.group(1);
        logger.debug("CardSmith response code: {}", (Object)responseCode);
        this._approved = RESPONSE_CODE_APPROVED.equals(responseCode);
        if (this._approved) {
            m = APPROVAL_CODE_PATTERN.matcher(responseString);
            if (!m.matches() || m.groupCount() < 1) {
                throw new IllegalArgumentException("Approval code could not be found in response string");
            }
            this._approvalCode = m.group(1);
        }
    }

    public boolean isApproved() {
        return this._approved;
    }

    @CheckForNull
    public String getApprovalCode() {
        return this._approvalCode;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this);
        tsb.append("approved", this._approved);
        tsb.append("approvalCode", (Object)this._approvalCode);
        return tsb.toString();
    }
}

