/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx.CardNumberEntryMode;
import biz.papercut.pcng.ext.paymentgateway.cardsmith.ipsx.CardSmithPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnCardSmithIpsx
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnCardSmithIpsx.class);
    public static final String PAGE_NAME = ExtnCardSmithIpsx.class.getSimpleName();

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract Double getAmount();

    @CheckForNull
    public abstract String getCardNumber();

    public abstract void setCardNumber(@Nullable String var1);

    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract UserManager getUserManager();

    public abstract AccountManager getAccountManager();

    public abstract ApplicationLogManager getApplicationLogManager();

    public abstract LicenseManager getLicenseManager();

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = this.getCardSmithPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(this.createAmountsModel());
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!this.getCardSmithPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getCardSmithPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
            CardNumberEntryMode e = this.getCardSmithPlugin().getCardNumberEntryMode();
            if (StringUtils.isBlank((String)this.getCardNumber()) && e != CardNumberEntryMode.UserEntered) {
                this.setCardNumber(this.getUser().getCardNumber());
            }
            if (!this.isShowCardNumberField() && StringUtils.isBlank((String)this.getUser().getCardNumber())) {
                this.addErrorMessage(this.getCardSmithPlugin().getGatewayConfig().getString("cardsmith.error-when-no-card-number"));
                logger.warn("Setting cardsmith.card-number-entry-mode requires users to have a card number, but user '{}' does not.  Denying access.", (Object)this.getUser().getUserName());
            }
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        ValidationDelegate delegate = (ValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            this.addErrorMessage(delegate.getFirstError().toString());
            return;
        }
        if (this.getAmount() == null || this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        String userName = this.getUser().getUserName();
        String cardNumber = this.getCardNumber();
        if (cardNumber == null) {
            this.addErrorMessage(this.getCardSmithPlugin().getGatewayConfig().getString("cardsmith.error-when-no-card-number"));
            return;
        }
        String remoteAddr = this.getRequest().getRemoteAddr();
        CardSmithPlugin.TransactionResponse response = this.getCardSmithPlugin().withdrawCredit(userName, cardNumber, this.getAmount(), remoteAddr);
        String message = response.getMessage();
        if (response.isSuccess()) {
            this.addStatusMessage("Funds have been added to your account");
            if (message != null) {
                this.addStatusMessage(message);
            }
            this.setCardNumber(null);
        } else {
            this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
            if (message != null) {
                this.addStatusMessage(message);
            }
        }
    }

    private IPropertySelectionModel createAmountsModel() {
        return GatewayUtils.createAllowedAmountsModel("cardsmith.allowed-amounts", (BasePaperCutPage)this);
    }

    public String getNoAccessMsg() {
        return GatewayConfig.getInstance().getNoAccessMessage();
    }

    public String getHeading() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String heading = conf.getString("cardsmith.page-heading");
        if (StringUtils.isBlank((String)heading)) {
            heading = "Add credit using a Credit Card";
        }
        return heading;
    }

    private CardSmithPlugin getCardSmithPlugin() {
        return (CardSmithPlugin)PluginManager.getInstance().getPluginByClass(CardSmithPlugin.class);
    }

    public boolean isAccessibleByUser() {
        return this.getCardSmithPlugin().isAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public boolean isShowCardNumberText() {
        return this.getCardSmithPlugin().getCardNumberEntryMode() == CardNumberEntryMode.DatabaseShown;
    }

    public boolean isShowCardNumberField() {
        CardNumberEntryMode e = this.getCardSmithPlugin().getCardNumberEntryMode();
        return e == CardNumberEntryMode.UserEntered || e == CardNumberEntryMode.DatabaseEditable;
    }

    public List<Double> getAllowedAmounts() {
        GatewayConfig conf = GatewayConfig.getInstance();
        return conf.getDoubleList("cardsmith.allowed-amounts");
    }

    public boolean isFatalError() {
        if (!this.isShowCardNumberField()) {
            return StringUtils.isBlank((String)this.getUser().getCardNumber());
        }
        return false;
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return this.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return this.getGatewayConfig().getPageMessageAvailable();
    }
}

