/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cashnet;

import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.PaymentGatewayRequestLogMessageBuilder;
import biz.papercut.pcng.ext.paymentgateway.cashnet.CashnetPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CashnetPOSTBackServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(CashnetPOSTBackServlet.class);
    private final PaymentGatewayRequestLogMessageBuilder logMessageBuilder = new PaymentGatewayRequestLogMessageBuilder("CASHNet Store Notification URL").withSelectedParameters(this.getParametersToLog());

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.debugLogRequest(request);
        Map<String, String> params = GatewayUtils.getHttpServletRequestParamsAsMap(request);
        this.getCashnetPlugin().validateStoreNotificationAndCompleteOrder(request.getRemoteAddr(), request.getRequestURI(), params);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.debugLogRequest(request);
        response.setContentType("text/html");
        response.getWriter().write("<html><body><h1>The CASHNet Store Notification URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. that the CASHNet server has access)</p></body></html>");
    }

    private CashnetPlugin getCashnetPlugin() {
        return (CashnetPlugin)PluginManager.getInstance().getPluginByClass(CashnetPlugin.class);
    }

    private void debugLogRequest(HttpServletRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.buildLogMessageFromRequest(request));
        }
    }

    String buildLogMessageFromRequest(HttpServletRequest request) {
        return this.logMessageBuilder.buildFrom(request);
    }

    private List<String> getParametersToLog() {
        return List.of("ref1type1", "ref1val1", "result", "respmessage");
    }
}

