/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cashnet;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ParameterMapValuesStringBuilder;
import biz.papercut.pcng.ext.paymentgateway.cashnet.CashnetOrderStatus;
import biz.papercut.pcng.ext.paymentgateway.cashnet.CashnetPOSTBackServlet;
import biz.papercut.pcng.ext.paymentgateway.cashnet.ExtnCashnet;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.ConfigManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.NotificationUtils;
import biz.papercut.pcng.service.UserManager;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CashnetPlugin
implements EnableablePlugin,
WebServerPlugin,
SpringContextPlugin,
UserLinkPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CashnetPlugin.class);
    private static final String CONFIG_PREFIX = "cashnet.";
    private static final String CONFIG_ENABLED = "cashnet.enabled";
    private static final String CONFIG_PAGE_TITLE = "cashnet.page-title";
    private static final String CONFIG_PAGE_HEADING = "cashnet.page-heading";
    private static final String CONFIG_ALLOWED_GROUPS = "cashnet.allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "cashnet.allowed-amounts";
    private static final String CONFIG_SUBMIT_URL = "cashnet.hosted-payment-page-url";
    @AESProperty
    public static final String CONFIG_SHARED_SECRET = "cashnet.shared-secret";
    private static final String CONFIG_POSTBACK_ALLOWED_IP = "cashnet.postback-allowed-ip";
    private static final String CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO = "cashnet.only-allow-accumulation-up-to";
    private static final String CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO_MESSAGE = "cashnet.only-allow-accumulation-up-to-message";
    private static final String CONFIG_ITEM_DESCRIPTION = "cashnet.item-description";
    private static final String CONFIG_ITEM_CODE = "cashnet.item-code";
    private static final String ORDERID_REF_TYPE_DEFAULT = "SESSIONID";
    private static final String CONFIG_ORDERID_REF_TYPE = "cashnet.orderid-ref-type";
    private static final String STORE_NOTIFICATION_ORDER_ID_NAME = "ref1type1";
    private static final String STORE_NOTIFICATION_ORDER_ID_VALUE = "ref1val1";
    private static final String STORE_NOTIFICATION_AMOUNT = "amount1";
    private static final String STORE_NOTIFICATION_RESULT_CODE = "result";
    private static final String STORE_NOTIFICATION_RESULT_MESSAGE = "respmessage";
    private static final String POSTBACK_URL_PATH = "/rpc/gateway/cashnet";
    private static final int MAX_ORDER_NUMBER_LENGTH = 900;
    private static final int MAX_USER_EMAIL_LENGTH = 900;
    private static final List<String> ADDITIONAL_PAGES = List.of(ExtnCashnet.PAGE_NAME);
    private volatile ApplicationContext _applicationContext;

    public boolean isPluginEnabled() {
        Boolean enabled = this.getGatewayConfig().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        if (!this.isPluginEnabled()) {
            return;
        }
        server.addServlet(CashnetPOSTBackServlet.class, "/rpc/gateway/cashnet/*");
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return ADDITIONAL_PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getIsConfigured() {
        String errorSuffix = " Please check the payment gateway config file.";
        if (this.getAllowedAmounts() == null) {
            String error = "Must specify at least one allowed payment amount.";
            GatewayUtils.LogHelper.logError(logger, error);
            return error + errorSuffix;
        }
        if (this.getItemCode() == null) {
            String error = "Must specify an item code.";
            GatewayUtils.LogHelper.logError(logger, error);
            return error + errorSuffix;
        }
        try {
            this.getGatewayConfig().getURL(CONFIG_SUBMIT_URL);
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Invalid hosted order page URL: " + this.getSubmitURL());
            return "Invalid hosted order page URL." + errorSuffix;
        }
        return null;
    }

    public String createNewOrder(String userName, double amount) {
        return this.getCreditCardGatewayPlugin().createNewOrder(userName, amount, 900);
    }

    public boolean isAccessibleByUser(String username) {
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager());
    }

    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenseManager(), "payment-gateways-cashnet");
    }

    public String getAllowedAmounts() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ALLOWED_AMOUNTS));
    }

    public String getDescription() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ITEM_DESCRIPTION));
    }

    public String getItemCode() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ITEM_CODE));
    }

    public String getOrderIdRefType() {
        String orderRefType = StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ORDERID_REF_TYPE));
        return orderRefType == null ? ORDERID_REF_TYPE_DEFAULT : orderRefType;
    }

    @CheckForNull
    public Double getOnlyAllowAccumulationUpTo() {
        try {
            return this.getGatewayConfig().getDouble(CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO);
        }
        catch (NumberFormatException e) {
            GatewayUtils.LogHelper.logError(logger, "Invalid accumulation limit");
            return null;
        }
    }

    public String getOnlyAllowAccumulationUpToMessage() {
        return this.getGatewayConfig().getString(CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO_MESSAGE);
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_TITLE));
    }

    @CheckForNull
    public String getPageHeading() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_HEADING));
    }

    public String getSubmitURL() {
        return this.getGatewayConfig().getString(CONFIG_SUBMIT_URL);
    }

    public String getReturnURL(String scheme, String serverName, int serverPort, String orderId) {
        return scheme + "://" + serverName + ":" + serverPort + "/app?service=external/" + ExtnCashnet.PAGE_NAME + "&order-id=" + orderId;
    }

    public String getUserEmail(User user) {
        String email = StringUtils.trimToEmpty((String)NotificationUtils.getUserEmailAddress((ConfigManager)this.getConfigManager(), (User)user));
        return StringUtils.left((String)email, (int)900);
    }

    public String getUserErrorMessage() {
        return this.getGatewayConfig().getUserErrorMessage();
    }

    public CashnetOrderStatus getOrderStatus(String orderId) {
        logger.debug("Checking order status of order {}", (Object)orderId);
        CreditCardGatewayPlugin ccgp = this.getCreditCardGatewayPlugin();
        if (!ccgp.isOrderExists(orderId)) {
            return CashnetOrderStatus.Unknown;
        }
        CreditCardGatewayPlugin.OrderResponse or = ccgp.getExistingOrderReponse(orderId);
        if (or == null) {
            logger.debug("Order not confirmed");
            return CashnetOrderStatus.NotConfirmed;
        }
        if (or.isSuccess()) {
            logger.debug("Order confirmed");
            return CashnetOrderStatus.Approved;
        }
        logger.debug("Order cancelled");
        return CashnetOrderStatus.NotConfirmed;
    }

    public double getOrderAmount(String orderId) {
        CreditCardGatewayPlugin ccgp = this.getCreditCardGatewayPlugin();
        CreditCardGatewayPlugin.CreditCardOrder order = ccgp.getOrderReadOnly(orderId);
        if (order != null) {
            return order.getAmount();
        }
        logger.debug("Order does not exists");
        return 0.0;
    }

    public void cancelOrder(String orderId) {
        GatewayUtils.LogHelper.logInfo(logger, "Canceling order " + orderId);
        this.getCreditCardGatewayPlugin().cancelOrder(orderId);
    }

    public void validateStoreNotificationAndCompleteOrder(String remoteAddress, String requestURI, Map<String, String> params) {
        double amount;
        int transResultCode;
        GatewayUtils.LogHelper.logInfo(logger, "Receiving Store Notification from CASHNet. IP: " + remoteAddress + ", details: " + this.buildStringFromParameters(params));
        if (!GatewayUtils.isIPAddressValid(remoteAddress, this.getGatewayConfig().getString(CONFIG_POSTBACK_ALLOWED_IP))) {
            GatewayUtils.LogHelper.logWarn(logger, "Received Store Notification from a disallowed IP address. Transaction ignored. See payment gateway log file for details.", null, this.getApplicationLogManager());
            return;
        }
        String localSecret = this.getGatewayConfig().getString(CONFIG_SHARED_SECRET);
        if (StringUtils.isBlank((String)localSecret)) {
            GatewayUtils.LogHelper.logDebug(logger, "Shared secret not configured. Skipping validation.");
        } else {
            if (!requestURI.contains(localSecret)) {
                this.warnIncorrectStoreParam("shared secret", requestURI);
                return;
            }
            GatewayUtils.LogHelper.logDebug(logger, "Shared secret confirmed on store notification");
        }
        String orderIdName = params.get(STORE_NOTIFICATION_ORDER_ID_NAME);
        if (StringUtils.isBlank((String)orderIdName)) {
            this.warnMissingStoreParam("order id name");
            return;
        }
        String orderIdValue = params.get(STORE_NOTIFICATION_ORDER_ID_VALUE);
        if (StringUtils.isBlank((String)orderIdValue)) {
            this.warnMissingStoreParam("order id value");
            return;
        }
        String transResultCodeStr = params.get(STORE_NOTIFICATION_RESULT_CODE);
        if (StringUtils.isBlank((String)transResultCodeStr)) {
            this.warnMissingStoreParam("result code");
            return;
        }
        try {
            transResultCode = Integer.parseInt(transResultCodeStr);
        }
        catch (NumberFormatException nfe) {
            this.warnIncorrectStoreParam("result code", transResultCodeStr);
            return;
        }
        GatewayUtils.LogHelper.logInfo(logger, "CASHNet reporting updated status for order id " + orderIdValue + ": " + transResultCode);
        if (transResultCode != 0) {
            String errorMsg = params.get(STORE_NOTIFICATION_RESULT_MESSAGE);
            GatewayUtils.LogHelper.logInfo(logger, "CASHNet transaction failed" + (String)(StringUtils.isNotEmpty((String)errorMsg) ? ": " + errorMsg : ""));
            return;
        }
        String amountStr = params.get(STORE_NOTIFICATION_AMOUNT);
        if (StringUtils.isBlank((String)amountStr)) {
            this.warnMissingStoreParam("payment amount");
            return;
        }
        try {
            amount = Double.parseDouble(amountStr);
        }
        catch (NumberFormatException nfe) {
            this.warnIncorrectStoreParam("payment amount", amountStr);
            return;
        }
        GatewayUtils.LogHelper.logInfo(logger, "Completing order " + orderIdValue + " for " + amountStr);
        this.getCreditCardGatewayPlugin().confirmOrder(orderIdValue, amount);
    }

    private void warnMissingStoreParam(String paramName) {
        GatewayUtils.LogHelper.logWarn(logger, "CASHNet reported a transaction (Store Notification) but it could not be processed due to missing information (missing \"" + paramName + "\"). See payment gateway log file for details.", null, this.getApplicationLogManager());
    }

    private void warnIncorrectStoreParam(String paramName, String paramValue) {
        GatewayUtils.LogHelper.logWarn(logger, "CASHNet Store Notification contains invalid " + paramName + ": \"" + paramValue + "\". Ignoring.");
        GatewayUtils.LogHelper.logWarn(logger, "CASHNet reported a transaction (Store Notification) but it could not be processed due to incorrect information (invalid payment amount). See payment gateway log file for details.", null, this.getApplicationLogManager());
    }

    private ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    private CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)PluginManager.getInstance().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private LicenseManager getLicenseManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    private ConfigManager getConfigManager() {
        return (ConfigManager)this.getApplicationContext().getBean("configManager", ConfigManager.class);
    }

    String buildStringFromParameters(Map<String, String> parameterMap) {
        ParameterMapValuesStringBuilder stringBuilder = new ParameterMapValuesStringBuilder(parameterMap);
        this.getParametersToLog().forEach(stringBuilder::add);
        return stringBuilder.build();
    }

    private List<String> getParametersToLog() {
        return List.of(STORE_NOTIFICATION_ORDER_ID_NAME, STORE_NOTIFICATION_ORDER_ID_VALUE, STORE_NOTIFICATION_RESULT_CODE, STORE_NOTIFICATION_RESULT_MESSAGE);
    }
}

