/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cashnet;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cashnet.CashnetPlugin;
import biz.papercut.pcng.ext.paymentgateway.cashnet.ExtnCashnet;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CashnetRedirect
extends BasePaperCutPage
implements PageRenderListener {
    private static final Logger logger = LoggerFactory.getLogger(CashnetRedirect.class);
    public static final String PAGE_NAME = CashnetRedirect.class.getSimpleName();

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract String getOrderId();

    public abstract void setOrderId(String var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, User user, double amount) {
        this.setUser(user);
        this.setAmount(amount);
        String orderId = this.getCashnetPlugin().createNewOrder(user.getUserName(), amount);
        this.setOrderId(orderId);
        logger.debug("Created order {} for user {}. Redirecting user to CASHNet.", (Object)orderId, (Object)user.getUserName());
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent arg0) {
        if (this.getUser() == null) {
            throw new PageRedirectException(ExtnCashnet.PAGE_NAME);
        }
    }

    public String getFormattedAmount() {
        return GatewayUtils.formatNumber(this.getAmount(), 2, Locale.US, false);
    }

    public String getReturnURL() {
        HttpServletRequest r = this.getRequest();
        return this.getCashnetPlugin().getReturnURL(r.getScheme(), r.getServerName(), r.getServerPort(), this.getOrderId());
    }

    public String getSubmitURL() {
        return this.getCashnetPlugin().getSubmitURL();
    }

    public String getUserEmail() {
        User user = this.getUser();
        if (user == null) {
            return null;
        }
        return StringUtils.trimToNull((String)this.getCashnetPlugin().getUserEmail(user));
    }

    public String getDescription() {
        return this.getCashnetPlugin().getDescription();
    }

    public String getItemCode() {
        return this.getCashnetPlugin().getItemCode();
    }

    public String getUserFullName() {
        User user = this.getUser();
        if (user == null) {
            return null;
        }
        return StringUtils.trimToNull((String)user.getFullName());
    }

    public String getOrderIdRefType() {
        return this.getCashnetPlugin().getOrderIdRefType();
    }

    private CashnetPlugin getCashnetPlugin() {
        return (CashnetPlugin)PluginManager.getInstance().getPluginByClass(CashnetPlugin.class);
    }
}

