/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cashnet;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cashnet.CashnetPlugin;
import biz.papercut.pcng.ext.paymentgateway.cashnet.CashnetRedirect;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnCashnet
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnCashnet.class);
    public static final String PAGE_NAME = ExtnCashnet.class.getSimpleName();

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract AccountManager getAccountManager();

    public abstract UserManager getUserManager();

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
        HttpServletRequest r = this.getRequest();
        String orderId = r.getParameter("order-id");
        if (StringUtils.isNotEmpty((String)orderId)) {
            switch (this.getCashnetPlugin().getOrderStatus(orderId)) {
                case Approved: {
                    double amount = this.getCashnetPlugin().getOrderAmount(orderId);
                    this.addStatusMessage(this.formatBalance(amount) + " has been added to your account.");
                    break;
                }
                case NotConfirmed: {
                    this.addWarningMessage("Your payment was canceled. " + this.getCashnetPlugin().getUserErrorMessage());
                    this.getCashnetPlugin().cancelOrder(orderId);
                    break;
                }
                case Unknown: {
                    this.addErrorMessage("Your payment was not processed due to an order problem");
                    logger.error("Order id {} could not be found in the system", (Object)orderId);
                    break;
                }
                default: {
                    this.addErrorMessage("PaperCut internal error");
                    logger.error("Bad order status");
                    break;
                }
            }
        } else {
            this.addErrorMessage("Your payment was not processed due to a protocol error");
            logger.error("Returned to Add Credit page but GET request missing the order-id parameter");
        }
    }

    public void pageBeginRender(PageEvent arg0) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("cashnet.allowed-amounts", (BasePaperCutPage)this));
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!this.getCashnetPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getCashnetPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
        }
    }

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void formSubmit(IRequestCycle cycle) {
        double totalUserBalance;
        double amount = this.getAmount();
        User user = this.getUser();
        if (amount <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        Double accumulationLimit = this.getCashnetPlugin().getOnlyAllowAccumulationUpTo();
        if (accumulationLimit != null && (totalUserBalance = GatewayUtils.getUserBalance(this.getAccountManager(), user)) + amount > accumulationLimit) {
            this.addErrorMessage(this.getCashnetPlugin().getOnlyAllowAccumulationUpToMessage());
            return;
        }
        CashnetRedirect redirectPage = (CashnetRedirect)cycle.getPage(CashnetRedirect.PAGE_NAME);
        redirectPage.activate(cycle, user, amount);
    }

    public boolean isAccessibleByUser() {
        return this.getCashnetPlugin().isAccessibleByUser(this.getUserName());
    }

    public String getNoAccessMsg() {
        return this.getGatewayConfig().getNoAccessMessage();
    }

    public String getPageTitle() {
        String title = this.getCashnetPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public String getHeading() {
        return this.getCashnetPlugin().getPageHeading();
    }

    public String getUserName() {
        return this.getUser().getUserName();
    }

    public String getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return this.formatBalance(GatewayUtils.getUserBalance(this.getAccountManager(), user));
    }

    public String getPageMessage() {
        return this.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return this.getGatewayConfig().getPageMessageAvailable();
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private CashnetPlugin getCashnetPlugin() {
        return (CashnetPlugin)PluginManager.getInstance().getPluginByClass(CashnetPlugin.class);
    }
}

