/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord;

import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDResponse;
import biz.papercut.pcng.util.ObjectUtils;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBORDConnection {
    private static final Logger logger = LoggerFactory.getLogger(CBORDConnection.class);
    private final String _hostName;
    private final int _port;
    private final String _terminalAddress;
    private final Socket _socket;
    private final byte[] _receiveBuffer;
    private int _receiveBufferByteCount;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public CBORDConnection(String hostName, int port, String terminalAddress) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Initiating CBORD connection to: {}:{}, terminal address: {}", new Object[]{hostName, port, terminalAddress});
        }
        this._hostName = hostName;
        this._port = port;
        this._terminalAddress = terminalAddress;
        this._receiveBuffer = new byte[1024];
        this._receiveBufferByteCount = 0;
        this._socket = new Socket(this._hostName, this._port);
        this._socket.setSoTimeout(10000);
        this._socket.setKeepAlive(true);
    }

    public synchronized CBORDResponse<TransactionInfo> performSale(String id, int tenderNo, double amount, String txnNo) throws IOException {
        List<String> fieldsIn = this.buildTxnFields("51", id, tenderNo, amount, txnNo);
        Message m = new Message(this._terminalAddress, Message.formatFields(fieldsIn));
        Message r = this.sendMessage(m);
        String[] fieldsOut = r.getFields();
        boolean success = "OK".equals(fieldsOut[0]);
        if (success) {
            return new CBORDResponse<TransactionInfo>(success, "", new TransactionInfo(fieldsOut));
        }
        return new CBORDResponse<TransactionInfo>(success, "Unable to deduct credit - " + fieldsOut[1], new TransactionInfo(fieldsOut));
    }

    public synchronized CBORDResponse<TransactionInfo> performVoid(String id, int tenderNo, double amount, String txnNo) throws IOException {
        List<String> fieldsIn = this.buildTxnFields("52", id, tenderNo, amount, txnNo);
        Message m = new Message(this._terminalAddress, Message.formatFields(fieldsIn));
        Message r = this.sendMessage(m);
        String[] fieldsOut = r.getFields();
        boolean success = "OK".equals(fieldsOut[0]);
        if (success) {
            return new CBORDResponse<TransactionInfo>(success, "", new TransactionInfo(fieldsOut));
        }
        return new CBORDResponse<TransactionInfo>(success, "Unable to perform void transaction - " + fieldsOut[1]);
    }

    public synchronized CBORDResponse<PatronInfo> patronInquiry(String id) throws IOException {
        List<String> fieldsIn = this.buildTxnFields("72", id, null, null, null);
        Message m = new Message(this._terminalAddress, Message.formatFields(fieldsIn));
        Message r = this.sendMessage(m);
        String[] fieldsOut = r.getFields();
        boolean success = "OK".equals(fieldsOut[0]);
        if (success) {
            return new CBORDResponse<PatronInfo>(success, "", new PatronInfo(fieldsOut));
        }
        return new CBORDResponse<PatronInfo>(success, "Unable to find user in CBORD with card/id: " + id + ", " + fieldsOut[0] + ": " + fieldsOut[1]);
    }

    private List<String> buildTxnFields(String functionCode, String id, Integer tenderNo, Double amount, String txnNo) {
        ArrayList<String> fieldsIn = new ArrayList<String>();
        fieldsIn.add(StringUtils.trimToEmpty((String)txnNo));
        fieldsIn.add("");
        fieldsIn.add(functionCode);
        fieldsIn.add(tenderNo == null ? "" : String.valueOf(tenderNo));
        String amountFormatted = "";
        if (amount != null) {
            DecimalFormat format = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
            amountFormatted = format.format(amount);
        }
        fieldsIn.add("");
        fieldsIn.add(amountFormatted);
        fieldsIn.add("");
        fieldsIn.add(id);
        fieldsIn.add("2");
        fieldsIn.add("");
        fieldsIn.add("");
        return fieldsIn;
    }

    private Message sendMessage(Message msg) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("SEND: {}", (Object)msg);
        }
        byte[] b = msg.toWireBytes();
        this._socket.getOutputStream().write(b);
        this._socket.getOutputStream().flush();
        return this.readMessage();
    }

    private Message readMessage() throws IOException {
        int responseLen = 0;
        try {
            while ((responseLen = Message.containsMessage(this._receiveBuffer, this._receiveBufferByteCount)) < 0) {
                int readLen = this._socket.getInputStream().read(this._receiveBuffer, this._receiveBufferByteCount, this._receiveBuffer.length - this._receiveBufferByteCount);
                if (readLen < 0) {
                    if (this._receiveBufferByteCount > 0) {
                        logger.error("Connection closed unexpectedly while waiting for response. {}", (Object)this.getReceiveBufferDebugState());
                    }
                    throw new CBORDProtocolException("Connection unexpectedly closed by CBORD. Please check CBORD logs.");
                }
                this._receiveBufferByteCount += readLen;
            }
        }
        catch (SocketTimeoutException ste) {
            if (this._receiveBufferByteCount > 0 && logger.isDebugEnabled()) {
                logger.debug("Timed-out waiting for a complete response. {}", (Object)this.getReceiveBufferDebugState());
            }
            throw ste;
        }
        Message m = Message.parse(this._receiveBuffer, responseLen);
        if (this._receiveBufferByteCount <= responseLen) {
            this._receiveBufferByteCount = 0;
        } else {
            int unused = this._receiveBufferByteCount - responseLen;
            System.arraycopy(this._receiveBuffer, responseLen, this._receiveBuffer, 0, unused);
            this._receiveBufferByteCount = unused;
            if (logger.isDebugEnabled()) {
                logger.debug("Receive buffer still contains data after reading response. {}", (Object)this.getReceiveBufferDebugState());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RECV: {}", (Object)m);
        }
        return m;
    }

    public synchronized void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing CBORD connection.");
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getReceiveBufferDebugState() {
        if (this._receiveBufferByteCount == 0) {
            return "Receive buffer empty.";
        }
        return "Receive buffer - Byte count: " + this._receiveBufferByteCount + " Data: " + CBORDConnection.toHexString(this._receiveBuffer, 0, this._receiveBufferByteCount);
    }

    private static String toHexString(byte[] b, int index, int len) {
        StringBuilder sb = new StringBuilder(len * 3);
        for (int i = index; i < index + len; ++i) {
            if (i != index) {
                sb.append(',');
            }
            sb.append(CBORDConnection.toHexString(b[i]));
        }
        return sb.toString();
    }

    private static String toHexString(byte b) {
        int i = CBORDConnection.unsignedByteValue(b);
        return String.valueOf(HEX_CHARS[i >> 4]) + HEX_CHARS[i & 0xF];
    }

    public static int unsignedByteValue(byte b) {
        return b & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try (CBORDConnection conn = new CBORDConnection("24.39.174.27", 3770, "81");){
            String id = "777339001";
            CBORDResponse<PatronInfo> r1 = conn.patronInquiry(id);
            CBORDResponse<TransactionInfo> sr = conn.performSale(id, 3, 999.0, "");
            CBORDResponse<PatronInfo> r2 = conn.patronInquiry(id);
            System.out.println("Before: " + String.valueOf(r1));
            System.out.println(" After: " + String.valueOf(r2));
            System.out.println("  Sale: " + String.valueOf(sr));
        }
    }

    static class Message {
        final String _terminalAddress;
        final String _data;

        private Message(String terminalAddress, String data) {
            this._terminalAddress = terminalAddress;
            this._data = data;
        }

        public String[] getFields() {
            if (this._data == null || this._data.isEmpty()) {
                return new String[0];
            }
            return this._data.split("\u001c", -1);
        }

        public static String formatFields(List<String> l) {
            return StringUtils.join(l, (char)'\u001c');
        }

        public static int containsMessage(byte[] buffer, int bufferLen) {
            if (bufferLen < 4) {
                return -1;
            }
            int msgLen = (buffer[0] << 8) + buffer[1];
            String terminalId = "" + (char)buffer[2] + (char)buffer[3];
            if (!Character.isDigit(terminalId.charAt(0)) || !Character.isDigit(terminalId.charAt(1))) {
                throw new CBORDProtocolException("Invalid terminal address: " + terminalId);
            }
            if (bufferLen < msgLen + 2) {
                return -1;
            }
            return msgLen + 2;
        }

        public static Message parse(byte[] buffer, int bufferLen) {
            if (Message.containsMessage(buffer, bufferLen) <= 0) {
                throw new CBORDProtocolException("Unable to parse CBORD message, the message is incomplete.");
            }
            int msgLen = (buffer[0] << 8) + buffer[1];
            int dataLen = msgLen - 2;
            String terminalId = "" + (char)buffer[2] + (char)buffer[3];
            String data = new String(buffer, 4, dataLen, StandardCharsets.US_ASCII);
            return new Message(terminalId, data);
        }

        public String getTerminalAddress() {
            return this._terminalAddress;
        }

        public String getData() {
            return this._data;
        }

        public byte[] toWireBytes() {
            int dataLen = this._data == null ? 0 : this._data.length();
            byte[] r = new byte[dataLen + 4];
            int msgLen = dataLen + 2;
            r[0] = (byte)(msgLen >> 8 & 0xFF);
            r[1] = (byte)(msgLen & 0xFF);
            r[2] = (byte)this._terminalAddress.charAt(0);
            r[3] = (byte)this._terminalAddress.charAt(1);
            if (dataLen > 0) {
                byte[] d = this._data.getBytes(StandardCharsets.US_ASCII);
                System.arraycopy(d, 0, r, 4, dataLen);
            }
            return r;
        }

        public String toString() {
            return "[tid=" + this._terminalAddress + ",data=" + this._data.replace('\u001c', '|') + "]";
        }
    }

    public static class TransactionInfo {
        private final double _transactionAmount;
        private final double _balance;

        public TransactionInfo(String[] fields) {
            if (fields[0].equals("OK")) {
                this._transactionAmount = Double.parseDouble(fields[2]);
                this._balance = Double.parseDouble(fields[3]);
            } else {
                this._transactionAmount = 0.0;
                this._balance = fields.length >= 3 ? this.safeParseDouble(fields[2]) : 0.0;
            }
        }

        private double safeParseDouble(String s) {
            if (s == null) {
                return 0.0;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                return 0.0;
            }
        }

        public double getTransactionAmount() {
            return this._transactionAmount;
        }

        public double getBalance() {
            return this._balance;
        }

        public String toString() {
            return ObjectUtils.createToStringBuilder((Object)this).append("amount", this._transactionAmount).append("balance", this._balance).toString();
        }
    }

    public static class PatronInfo {
        private final String _cardNumber;
        private final String _accountNumber;
        private final String _planID;
        private final String _cardStatus;
        private final String _activityGroup;
        private final String _cardLastUseDate;
        private final List<Double> _accountBalances;
        private final String _lastError;

        public PatronInfo(String[] fields) {
            if (fields.length < 18) {
                throw new CBORDProtocolException("Patron enquiry response missing fields: " + Arrays.toString(fields));
            }
            this._cardNumber = fields[2];
            this._accountNumber = fields[3];
            this._planID = fields[4];
            this._cardStatus = fields[5];
            this._activityGroup = fields[6];
            this._cardLastUseDate = fields[7];
            ArrayList<Double> bals = new ArrayList<Double>(9);
            for (int i = 8; i <= 16; ++i) {
                String balStr = StringUtils.trimToNull((String)fields[i]);
                if (balStr == null || balStr.equals("*")) {
                    bals.add(null);
                    continue;
                }
                bals.add(Double.valueOf(balStr));
            }
            this._accountBalances = Collections.unmodifiableList(bals);
            this._lastError = fields[17];
        }

        public String getCardNumber() {
            return this._cardNumber;
        }

        public String getAccountNumber() {
            return this._accountNumber;
        }

        public String getPlanID() {
            return this._planID;
        }

        public String getCardStatus() {
            return this._cardStatus;
        }

        public String getActivityGroup() {
            return this._activityGroup;
        }

        public String getCardLastUseDate() {
            return this._cardLastUseDate;
        }

        public List<Double> getAccountBalances() {
            return this._accountBalances;
        }

        public String getLastError() {
            return this._lastError;
        }

        public String toString() {
            return ObjectUtils.createToStringBuilder((Object)this).append("cardNo", (Object)this._cardNumber).append("acctNo", (Object)this._accountNumber).append("planID", (Object)this._planID).append("cardStatus", (Object)this._cardStatus).append("activityGroup", (Object)this._activityGroup).append("cardLastUseDate", (Object)this._cardLastUseDate).append("balances", this._accountBalances).append("lastError", (Object)this._lastError).toString();
        }
    }

    public static class CBORDProtocolException
    extends RuntimeException {
        public CBORDProtocolException(String message, Throwable cause) {
            super(message, cause);
        }

        public CBORDProtocolException(String message) {
            super(message);
        }
    }
}

