/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord;

import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDConnection;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBORDManagedConnection {
    private static final Logger logger = LoggerFactory.getLogger(CBORDManagedConnection.class);
    private static final int RECONNECT_DELAY_SECS = 30;
    private static final int RECONNECT_DELAY_MILLIS = 30000;
    private static final long DEFAULT_TEST_TIME_MILLIS = 300000L;
    private final String _hostName;
    private final int _port;
    private final String _terminalAddress;
    private final int _maxWaitForConnectionSecs;
    private final Object _connCheckerLock = new Object();
    private volatile CBORDConnection _conn;
    private volatile String _testPatronID;
    private volatile long _lastConnectionErrorTime;
    private volatile Throwable _lastError;
    private volatile long _lastConnectionUsedTime;
    private final ReentrantLock _callerMutex = new ReentrantLock(true);

    public CBORDManagedConnection(String hostName, int port, String terminalAddress, int maxWaitForConnectionSecs) {
        if (maxWaitForConnectionSecs <= 0) {
            throw new IllegalArgumentException("maxWaitForConnectionSecs must be greater than 0");
        }
        this._hostName = hostName;
        this._port = port;
        this._terminalAddress = terminalAddress;
        this._maxWaitForConnectionSecs = maxWaitForConnectionSecs;
        Thread t = new Thread(this::connectionChecker, "cbord-connection-checker");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectionChecker() {
        long waitTime = 0L;
        while (true) {
            try {
                while (true) {
                    Object object = this._connCheckerLock;
                    synchronized (object) {
                        if (waitTime > 0L) {
                            logger.debug("Waiting for: {} ms", (Object)waitTime);
                            this._connCheckerLock.wait(waitTime);
                        }
                        if (this._conn == null) {
                            long earliestReconnectTime = this._lastConnectionErrorTime + 30000L;
                            if (System.currentTimeMillis() < earliestReconnectTime) {
                                waitTime = earliestReconnectTime - System.currentTimeMillis();
                                logger.debug("Too early to re-estabish CBORD connection. Wait {} ms.", (Object)waitTime);
                                continue;
                            }
                            try {
                                this._conn = new CBORDConnection(this._hostName, this._port, this._terminalAddress);
                            }
                            catch (IOException connEx) {
                                this.handleConnectionError(connEx);
                                waitTime = 30000L;
                                logger.error("Failed to establish CBORD connection ({}:{}). Retrying in {}ms. Error: {}", new Object[]{this._hostName, this._port, waitTime, connEx.getMessage(), connEx});
                                continue;
                            }
                            waitTime = 300000L;
                            this._lastConnectionErrorTime = 0L;
                            this._lastError = null;
                            continue;
                        }
                    }
                    String testPatronID = this._testPatronID;
                    if (StringUtils.isBlank((String)testPatronID)) {
                        logger.debug("No test patron ID - don't test the CBORD connection.");
                        continue;
                    }
                    long nextConnectionTest = this._lastConnectionUsedTime + 300000L;
                    long timeUntilNextTest = nextConnectionTest - System.currentTimeMillis();
                    if (timeUntilNextTest > 1000L) {
                        waitTime = nextConnectionTest - System.currentTimeMillis();
                        logger.debug("Connection not idle so don't test yet, wait {} ms", (Object)waitTime);
                        continue;
                    }
                    Object object2 = this._connCheckerLock;
                    synchronized (object2) {
                        try {
                            logger.debug("Perfoming CBORD connection test");
                            this._conn.patronInquiry(testPatronID);
                            this._lastConnectionUsedTime = System.currentTimeMillis();
                            waitTime = 300000L;
                        }
                        catch (Exception e) {
                            logger.error("Error occurred testing CBORD connection. Connection will be re-established in 30 seconds. Error: {}", (Object)e.getMessage(), (Object)e);
                            this.handleConnectionError(e);
                            waitTime = 30000L;
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.error("Error occurred checking CBORD connection. {}", (Object)t.getMessage(), (Object)t);
                waitTime = 30000L;
                this.handleConnectionError(t);
                continue;
            }
            break;
        }
    }

    public CBORDResponse<CBORDConnection.PatronInfo> patronInquiry(String id) {
        return this.doWithConnection(conn -> {
            CBORDResponse<CBORDConnection.PatronInfo> r = this._conn.patronInquiry(id);
            if (r.isSuccess()) {
                this._testPatronID = id;
            }
            return r;
        });
    }

    public CBORDResponse<CBORDConnection.TransactionInfo> performSale(String id, int tenderNo, double amount, String txnNo) {
        return this.doWithConnection(conn -> {
            CBORDResponse<CBORDConnection.TransactionInfo> r = conn.performSale(id, tenderNo, amount, txnNo);
            if (r.isSuccess()) {
                this._testPatronID = id;
            }
            return r;
        });
    }

    private <T> T doWithConnection(ConnectionRunnable<T> runnable) {
        long latestConnectTime = System.currentTimeMillis() + (long)this._maxWaitForConnectionSecs * 1000L;
        this.obtainCallerLock();
        try {
            T t;
            while (this._conn == null && System.currentTimeMillis() < latestConnectTime) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            CBORDConnection conn = this._conn;
            if (conn == null) {
                throw new CBORDManagedConnectionException("Unable to obtain CBORD connection. Reconnecting soon. " + (String)(this._lastError == null ? "" : "Last error: " + this._lastError.getMessage()), this._lastError);
            }
            try {
                this._lastConnectionUsedTime = System.currentTimeMillis();
                T r = runnable.run(conn);
                this._lastConnectionUsedTime = System.currentTimeMillis();
                t = r;
            }
            catch (Throwable t2) {
                this.handleConnectionError(t2);
                throw new CBORDManagedConnectionException(t2.getMessage(), t2);
            }
            return t;
        }
        finally {
            this.releaseCallerLock();
        }
    }

    private void obtainCallerLock() {
        try {
            if (!this._callerMutex.tryLock(this._maxWaitForConnectionSecs, TimeUnit.SECONDS)) {
                throw new CBORDManagedConnectionException("Timed out waiting for use of CBORD connection. Time out: " + this._maxWaitForConnectionSecs + " seconds.");
            }
        }
        catch (InterruptedException e) {
            throw new CBORDManagedConnectionException("Unable to obtain access to the CBORD connection.");
        }
    }

    private void releaseCallerLock() {
        this._callerMutex.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectionError(Throwable t) {
        logger.debug("CBORD connection error occurred: {}", (Object)t.getMessage(), (Object)t);
        this._lastConnectionErrorTime = System.currentTimeMillis();
        this._lastError = t;
        this.closeConnection();
        Object object = this._connCheckerLock;
        synchronized (object) {
            this._connCheckerLock.notify();
        }
    }

    private void closeConnection() {
        if (this._conn != null) {
            try {
                this._conn.close();
                this._conn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) throws Exception {
        CBORDManagedConnection mc = new CBORDManagedConnection("24.39.174.27", 3770, "81", 10);
        for (int i = 0; i < 5; ++i) {
            Thread t = new Thread(() -> {
                try {
                    while (true) {
                        mc.patronInquiry("777339001");
                    }
                }
                catch (Exception e) {
                    logger.error("DIE: {}", (Object)e.getMessage(), (Object)e);
                    return;
                }
            }, "cbord-" + i);
            t.start();
            Thread.sleep(100L);
        }
    }

    private static interface ConnectionRunnable<T> {
        public T run(CBORDConnection var1) throws IOException;
    }

    private static final class CBORDManagedConnectionException
    extends RuntimeException {
        private CBORDManagedConnectionException(String message, Throwable cause) {
            super(message, cause);
        }

        private CBORDManagedConnectionException(String message) {
            super(message);
        }
    }
}

