/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDConnection;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDManagedConnection;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDResponse;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDUserIDLookup;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.CreditUtilities;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CBORDPlugin
implements SpringContextPlugin,
EnableablePlugin,
UserLinkPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CBORDPlugin.class);
    private static final String CONFIG_PREFIX = "cbord.";
    public static final String CONFIG_ENABLED = "cbord.enabled";
    public static final String CONFIG_MODE = "cbord.mode";
    public static final String CONFIG_PAGE_TITLE = "cbord.manual.page-title";
    public static final String CONFIG_PAGE_HEADING = "cbord.manual.page-heading";
    public static final String CONFIG_TRANSACTION_COMMENT = "cbord.manual.transaction-comment";
    public static final String CONFIG_AVAILABLE_CREDIT_LABEL = "cbord.manual.available-credit-label";
    public static final String CONFIG_ALLOWED_AMOUNTS = "cbord.manual.allowed-amounts";
    public static final String CONFIG_MANUAL_ALLOWED_GROUPS = "cbord.manual.allowed-groups";
    public static final String CONFIG_USER_ERROR = "cbord.user-error-message";
    public static final String CONFIG_SERVER = "cbord.server.hostname";
    public static final String CONFIG_PORT = "cbord.server.port";
    public static final String CONFIG_TERMINAL_ADDRESS = "cbord.server.terminal-address";
    public static final String CONFIG_TENDER_NUMBER = "cbord.server.tender-number";
    public static final String MODE_MANUAL = "MANUAL";
    public static final String MODE_ON_DEMAND = "ON_DEMAND";
    public static final String MODE_BOTH = "BOTH";
    private ApplicationContext _ctx;
    private final CBORDUserIDLookup _idLookup = new CBORDUserIDLookup();
    private volatile CBORDManagedConnection _conn;

    public String isConfigured() {
        int i;
        GatewayConfig conf = GatewayConfig.getInstance();
        String errorSuffix = "  Please check the payment gateway config file.";
        if (StringUtils.isBlank((String)conf.getString(CONFIG_SERVER))) {
            EventLog.getInstance().logEvent("CBORD server address not provided.");
            return "Configuration problem - CBORD server address not provided." + errorSuffix;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_TERMINAL_ADDRESS))) {
            EventLog.getInstance().logEvent("CBORD terminal address not provided.");
            return "Configuration problem - CBORD terminal address not provided." + errorSuffix;
        }
        String s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_PORT));
        try {
            Integer.parseInt(s);
        }
        catch (Exception nfe) {
            EventLog.getInstance().logEvent("CBORD port not valid.");
            return "Configuration problem - CBORD port not valid." + errorSuffix;
        }
        s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_MODE)).toUpperCase(Locale.US);
        if (StringUtils.isBlank((String)s) || !s.equals(MODE_ON_DEMAND) && !s.equals(MODE_MANUAL) && !s.equals(MODE_BOTH)) {
            String msg = "Invalid CBORD module mode.  Must be MANUAL, ON_DEMAND or BOTH";
            EventLog.getInstance().logEvent(msg);
            return "Configuration problem - " + msg + errorSuffix;
        }
        s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_TENDER_NUMBER));
        try {
            i = Integer.parseInt(s);
        }
        catch (Exception nfe) {
            i = -1;
        }
        if (i < 1 || i > 9) {
            EventLog.getInstance().logEvent("CBORD tender number '" + s + "' not valid (must be a number between 1 and 9).");
            return "Configuration problem - CBORD tender number '" + s + "' not valid (must be a number between 1 and 9)." + errorSuffix;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_ALLOWED_AMOUNTS))) {
            EventLog.getInstance().logEvent("Must specify at least one allowed payment amount.");
            return "Configuration problem. Must specify at least one allowed payment amount." + errorSuffix;
        }
        s = this._idLookup.isConfigured();
        if (s != null) {
            EventLog.getInstance().logEvent(s);
            return s + errorSuffix;
        }
        return null;
    }

    private synchronized void connectIfRequired() {
        if (this._conn == null) {
            GatewayConfig conf = GatewayConfig.getInstance();
            this._conn = new CBORDManagedConnection(conf.getString(CONFIG_SERVER), conf.getInteger(CONFIG_PORT), conf.getString(CONFIG_TERMINAL_ADDRESS), 10);
        }
    }

    public CBORDResponse<CBORDConnection.TransactionInfo> deductCredit(String userName, double amount) {
        User user;
        String configError = this.isConfigured();
        if (configError != null) {
            return new CBORDResponse<CBORDConnection.TransactionInfo>(false, configError);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CBORD transaction - username: {}, amount: {}", (Object)userName, (Object)amount);
        }
        if ((user = this.getUserManager().getUser(userName)) == null) {
            return new CBORDResponse<CBORDConnection.TransactionInfo>(false, "Cannot find user with username: " + userName);
        }
        try {
            String cardId = this._idLookup.getCBORDCardIdNumber(user, this.getAppLogManager());
            if (StringUtils.isBlank((String)cardId)) {
                return new CBORDResponse<CBORDConnection.TransactionInfo>(false, "Unable to determine user's CBORD CARD/ID number.");
            }
            this.connectIfRequired();
            int tn = GatewayConfig.getInstance().getInteger(CONFIG_TENDER_NUMBER);
            CBORDResponse<CBORDConnection.TransactionInfo> r = this._conn.performSale(cardId, tn, amount, "");
            if (r.isSuccess()) {
                EventLog.getInstance().logTransaction(userName, "", amount, "CBORD");
            } else {
                String errMsg = "Unable to deduct credit from CBORD for user: " + userName + ", amount: " + this.formatBalance(amount) + ". Message: " + r.getErrorMessage();
                EventLog.getInstance().logEvent(errMsg);
                this.getAppLogManager().logRaw("", ApplicationLogLevelEnum.WARNING, errMsg);
            }
            return r;
        }
        catch (Exception e) {
            String errMsg = "Unable to deduct credit from CBORD for: " + user.getUserName() + ", amount: " + this.formatBalance(amount) + ". " + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            EventLog.getInstance().logEvent(errMsg);
            this.getAppLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, errMsg);
            return new CBORDResponse<CBORDConnection.TransactionInfo>(false, "Error occured performing CBORD transaction: " + e.getMessage());
        }
    }

    public CBORDResponse<CBORDConnection.PatronInfo> patronInquiry(User user) {
        String configError = this.isConfigured();
        if (configError != null) {
            return new CBORDResponse<CBORDConnection.PatronInfo>(false, configError);
        }
        try {
            String cardId = this._idLookup.getCBORDCardIdNumber(user, this.getAppLogManager());
            logger.debug("Card/id for user {} resolved to: {}", (Object)user.getUserName(), (Object)cardId);
            if (StringUtils.isBlank((String)cardId)) {
                return new CBORDResponse<CBORDConnection.PatronInfo>(false, "Unable to determine user's CBORD CARD/ID number.");
            }
            this.connectIfRequired();
            return this._conn.patronInquiry(cardId);
        }
        catch (Exception e) {
            EventLog.getInstance().logEvent("Unable to determine CBORD info for user " + user.getUserName() + " Error: " + e.getMessage());
            logger.error("Unable to lookup user: {} in CBORD. {}", new Object[]{user.getUserName(), e.getMessage(), e});
            return new CBORDResponse<CBORDConnection.PatronInfo>(false, "Error occured retrieving user info: " + e.getMessage());
        }
    }

    public Double getAvailableBalance(CBORDConnection.PatronInfo info) {
        if (info == null) {
            return null;
        }
        int tn = GatewayConfig.getInstance().getInteger(CONFIG_TENDER_NUMBER);
        return info.getAccountBalances().get(tn - 1);
    }

    public boolean isPluginEnabled() {
        Boolean enabled = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isManualTransferEnabled() {
        String modeStr = StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_MODE)).toUpperCase(Locale.US);
        return modeStr.equals(MODE_MANUAL) || modeStr.equals(MODE_BOTH);
    }

    public boolean isOnDemandTransferEnabled() {
        String modeStr = StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_MODE)).toUpperCase(Locale.US);
        return modeStr.equals(MODE_ON_DEMAND) || modeStr.equals(MODE_BOTH);
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isManualTransferEnabled() && this.isManualTransferAccessibleByUser(username)) {
            return List.of("ExtnCBORD");
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_PAGE_TITLE));
    }

    public boolean isManualTransferAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_MANUAL_ALLOWED_GROUPS, this.getUserManager());
    }

    private String formatBalance(double amount) {
        CreditUtilities cu = (CreditUtilities)this.getApplicationContext().getBean("creditUtilities", CreditUtilities.class);
        return cu.formatBalance(amount, null);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    private ApplicationLogManager getAppLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-cbord");
    }

    public String getUserErrorMessage() {
        String userError = StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_USER_ERROR));
        if (StringUtils.isNotBlank((String)userError)) {
            return userError;
        }
        return "An error has occurred, please try again. If you continue to receive this error please contact the network administrator.";
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }
}

