/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDConnection;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDPlugin;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.service.UserManager;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CBORDTopupAccountOnDemandPlugin
implements TopupAccountOnDemandPlugin3,
SpringContextPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CBORDTopupAccountOnDemandPlugin.class);
    private static final String PREFIX = "cbord.add-credit-on-demand.";
    private static final String CONFIG_DEFAULT_TRANSFER_AMOUNT = "cbord.add-credit-on-demand.default-transfer-amount";
    private static final String CONFIG_MAX_TRANSFER_AMOUNT = "cbord.add-credit-on-demand.max-transfer-amount";
    private static final String CONFIG_TRANSACTION_COMMENT = "cbord.add-credit-on-demand.transaction-comment";
    private static final String CONFIG_ALLOWED_GROUPS = "cbord.add-credit-on-demand.allowed-groups";
    private ApplicationContext _ctx;

    @Nullable
    public TopupAccountOnDemandPlugin3.AvailableCredit getAvailableCreditForTopUp(String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged) {
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            return null;
        }
        CBORDPlugin p = this.getCBORDPlugin();
        if (!p.isPluginEnabled()) {
            return null;
        }
        if (!GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager())) {
            logger.debug("CBORD topup on demand plugin is not enabled for user");
            return null;
        }
        User u = this.getUserManager().getUser(username);
        if (u == null) {
            logger.debug("Unknown user: {}", (Object)username);
            return null;
        }
        logger.debug("Fetching CBORD available credit for user {}", (Object)username);
        CBORDResponse<CBORDConnection.PatronInfo> r = p.patronInquiry(u);
        if (!r.isSuccess()) {
            logger.debug("Cannot lookup user in CBORD. User: {} Error: {}", (Object)username, (Object)r.getErrorMessage());
            return null;
        }
        CBORDConnection.PatronInfo pi = r.getResult();
        Double cbordBalance = p.getAvailableBalance(pi);
        if (cbordBalance == null) {
            logger.debug("Patron has no balance defined {}", (Object)pi);
            return null;
        }
        logger.debug("CBORD available credit for user {}: {}", (Object)username, (Object)cbordBalance);
        return new TopupAccountOnDemandPlugin3.AvailableCredit(false, cbordBalance < 0.0 ? 0.0 : cbordBalance);
    }

    public TopupAccountOnDemandPlugin.TopupResponse getTopup(double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails) {
        CBORDPlugin p;
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            logger.debug("CBORD topup on demand does not support does not support shared accounts");
            return null;
        }
        double topupAmount = this.calcTopUpAmount(amountRequired);
        if (topupAmount <= 0.0) {
            return null;
        }
        if (!this.isPluginEnabled()) {
            logger.debug("CBORD topup on demand plugin is not enabled");
            return null;
        }
        if (!GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager())) {
            logger.debug("CBORD topup on demand plugin is not enabled for user");
            return null;
        }
        Object txnComment = GatewayConfig.getInstance().getString(CONFIG_TRANSACTION_COMMENT);
        if (StringUtils.isBlank((String)txnComment)) {
            txnComment = "Automatic transfer from CBORD";
        }
        if (!(p = this.getCBORDPlugin()).isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return GatewayUtils.performTopupDebit(this, amount -> {
            CBORDResponse<CBORDConnection.TransactionInfo> r = p.deductCredit(username, amount);
            logger.debug("Result: {}", r);
            return r.isSuccess() ? Double.valueOf(r.getResult().getTransactionAmount()) : null;
        }, topupAmount, amountRequired, username, sharedAccount, accountCharged, usageDetails, (String)txnComment);
    }

    private boolean isCBORDLowBalanceError(CBORDResponse<CBORDConnection.TransactionInfo> r) {
        if (r.isSuccess()) {
            return false;
        }
        String err = StringUtils.trimToEmpty((String)r.getErrorMessage());
        return err.contains("LOW BALANCE") || err.contains("OVER ") && err.contains("LIMIT");
    }

    private double calcTopUpAmount(double amountRequired) {
        if (amountRequired <= 0.0) {
            return 0.0;
        }
        double defaultAmount = 0.0;
        double maxAmount = 0.0;
        GatewayConfig conf = GatewayConfig.getInstance();
        String s = null;
        try {
            s = conf.getString(CONFIG_DEFAULT_TRANSFER_AMOUNT);
            if (StringUtils.isNotBlank((String)s)) {
                defaultAmount = Math.max(0.0, Double.parseDouble(s));
            }
        }
        catch (Exception e) {
            logger.error("Invalid CBORD default transfer amount: {}", (Object)s);
            EventLog.getInstance().logEvent("Invalid CBORD default transfer amount: " + s + ".");
        }
        try {
            s = conf.getString(CONFIG_MAX_TRANSFER_AMOUNT);
            if (StringUtils.isNotBlank((String)s)) {
                maxAmount = Math.max(0.0, Double.parseDouble(s));
            }
        }
        catch (Exception e) {
            logger.error("Invalid CBORD max transfer amount: {}", (Object)s);
            EventLog.getInstance().logEvent("Invalid CBORD max transfer amount: " + s + ".");
        }
        if (maxAmount > 0.0 && defaultAmount > maxAmount) {
            logger.warn("CBORD default transfer amount is greater than max transfer amount.  Using default transfer amount as max amount.");
            maxAmount = defaultAmount;
        }
        double r = amountRequired;
        if (defaultAmount > 0.0 && amountRequired < defaultAmount) {
            logger.debug("Using default transfer amount");
            r = defaultAmount;
        }
        if (maxAmount > 0.0 && r > maxAmount) {
            logger.debug("Transfer amount exceeds maximum.");
            r = 0.0;
        }
        return r;
    }

    public boolean isPluginEnabled() {
        CBORDPlugin p = this.getCBORDPlugin();
        return p.isPluginEnabled() && p.isOnDemandTransferEnabled();
    }

    private CBORDPlugin getCBORDPlugin() {
        return (CBORDPlugin)PluginManager.getInstance().getPluginByClass(CBORDPlugin.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this._ctx.getBean("userManager", UserManager.class);
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }
}

