/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.service.ApplicationLogManager;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBORDUserIDLookup {
    private static final Logger logger = LoggerFactory.getLogger(CBORDUserIDLookup.class);
    public static final String CONFIG_ID_LOOKUP_PREFIX = "cbord.id-lookup.";
    public static final String CONFIG_ID_LOOKUP_MODE = "cbord.id-lookup.mode";
    public static final String CONFIG_ID_LOOKUP_DB_SQL = "cbord.id-lookup.db-sql";
    public static final String CONFIG_ID_LOOKUP_DB_DRIVER = "cbord.id-lookup.db-driver";
    public static final String CONFIG_ID_LOOKUP_DB_URL = "cbord.id-lookup.db-url";
    public static final String CONFIG_ID_LOOKUP_DB_USERNAME = "cbord.id-lookup.db-username";
    public static final String CONFIG_ID_LOOKUP_DB_PASSWORD = "cbord.id-lookup.db-password";
    private ComboPooledDataSource _dataSource;

    private boolean isDBLookupEnabled() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_ID_LOOKUP_MODE)).toUpperCase(Locale.US);
        return s.equals("EXTERNAL_DATABASE");
    }

    public String isConfigured() {
        GatewayConfig conf = GatewayConfig.getInstance();
        if (this.isDBLookupEnabled()) {
            String s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_ID_LOOKUP_DB_DRIVER));
            if (StringUtils.isBlank((String)s)) {
                EventLog.getInstance().logEvent("Configuration problem. No database driver specified (cbord.id-lookup.db-driver).");
                return "Configuration problem. No database driver specified (cbord.id-lookup.db-driver).";
            }
            s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_ID_LOOKUP_DB_URL));
            if (StringUtils.isBlank((String)s)) {
                EventLog.getInstance().logEvent("Configuration problem. No database connection URL specified (cbord.id-lookup.db-url).");
                return "Configuration problem. No database connection URL specified (cbord.id-lookup.db-url).";
            }
            s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_ID_LOOKUP_DB_USERNAME));
            if (StringUtils.isBlank((String)s)) {
                EventLog.getInstance().logEvent("Configuration problem. No database username specified (cbord.id-lookup.db-username).");
                return "Configuration problem. No database username specified (cbord.id-lookup.db-username).";
            }
            s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_ID_LOOKUP_DB_SQL));
            if (StringUtils.isBlank((String)s)) {
                return "Configuration problem. No database lookup SQL specified (cbord.id-lookup.db-sql).";
            }
        }
        return null;
    }

    public String getCBORDCardIdNumber(User user, ApplicationLogManager appLogMgr) {
        String cardId;
        if (this.isDBLookupEnabled()) {
            cardId = this.lookupCBORDIDInDatabase(user, appLogMgr);
            if (StringUtils.isBlank((String)cardId) && StringUtils.isNotBlank((String)user.getCardNumber())) {
                logger.debug("Unable to determine card number for user '{}' in external database. Using internal card/id number: {}", (Object)user.getUserName(), (Object)user.getCardNumber());
                cardId = user.getCardNumber();
            }
        } else {
            logger.debug("Using the user's card number.");
            cardId = user.getCardNumber();
        }
        if (StringUtils.isBlank((String)cardId)) {
            EventLog.getInstance().logEvent("Cannot determine CBORD card/id number for user: " + user.getUserName());
            return null;
        }
        return cardId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String lookupCBORDIDInDatabase(User user, ApplicationLogManager appLogMgr) {
        PreparedStatement stmt;
        ResultSet rs;
        Connection conn;
        block6: {
            String nextId2;
            logger.debug("Lookup CBORD ID in database.");
            conn = null;
            rs = null;
            stmt = null;
            try {
                conn = this.openDBConnection();
                stmt = this.createLookupSQLStatement(conn, user);
                rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                String id = rs.getString(1);
                if (rs.next()) {
                    String nextId2 = rs.getString(1);
                    throw new RuntimeException("Found multiple matches when performing CBORD ID/CARD lookup for user: " + user.getUserName() + ". Match 1: " + id + " Match 2: " + nextId2 + " More matches: " + rs.next());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Found CBORD ID: {} for user: {} in lookup DB.", (Object)id, (Object)user.getUserName());
                }
                nextId2 = id;
            }
            catch (Exception e) {
                block7: {
                    try {
                        String msg = "Error occurred looking up CBORD ID number in external database for user: " + user.getUserName() + ". " + e.getMessage();
                        EventLog.getInstance().logEvent(msg);
                        logger.error(msg, (Throwable)e);
                        if (appLogMgr == null) break block7;
                        appLogMgr.logRaw("", ApplicationLogLevelEnum.ERROR, msg);
                    }
                    catch (Throwable throwable) {
                        DbUtils.closeQuietly(rs);
                        DbUtils.closeQuietly(stmt);
                        DbUtils.closeQuietly((Connection)conn);
                        throw throwable;
                    }
                }
                DbUtils.closeQuietly((ResultSet)rs);
                DbUtils.closeQuietly((Statement)stmt);
                DbUtils.closeQuietly((Connection)conn);
            }
            DbUtils.closeQuietly((ResultSet)rs);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((Connection)conn);
            return nextId2;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        return null;
    }

    private PreparedStatement createLookupSQLStatement(Connection conn, User user) throws SQLException {
        String sqlTemplate = GatewayConfig.getInstance().getString(CONFIG_ID_LOOKUP_DB_SQL);
        Matcher m = Pattern.compile("\\{\\s*(\\p{Alpha}+)\\s*\\}").matcher(sqlTemplate);
        if (logger.isDebugEnabled()) {
            logger.debug("SQL template: {}", (Object)sqlTemplate);
        }
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        while (m.find()) {
            String key;
            switch (key = m.group(1).trim().toLowerCase()) {
                case "username": {
                    params.add(user.getUserName());
                    break;
                }
                case "idnumber": {
                    params.add(user.getCardNumber());
                    break;
                }
                case "fullname": {
                    params.add(user.getFullName());
                    break;
                }
                default: {
                    throw new RuntimeException("Configuration error - unexpected replacement in SQL: " + key);
                }
            }
            m.appendReplacement(sql, "?");
        }
        m.appendTail(sql);
        if (params.isEmpty()) {
            throw new RuntimeException("Configuration error - CBORD lookup SQL does not contain any parameters/replacements. SQL: " + sqlTemplate);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Parsed SQL: {} Params: {}", (Object)sql, params);
        }
        PreparedStatement stmt = conn.prepareStatement(sql.toString());
        for (int i = 0; i < params.size(); ++i) {
            stmt.setString(i + 1, (String)params.get(i));
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Connection openDBConnection() throws SQLException {
        CBORDUserIDLookup cBORDUserIDLookup = this;
        synchronized (cBORDUserIDLookup) {
            if (this._dataSource == null) {
                GatewayConfig conf = GatewayConfig.getInstance();
                this._dataSource = new ComboPooledDataSource();
                try {
                    this._dataSource.setDriverClass(StringUtils.trimToEmpty((String)conf.getString(CONFIG_ID_LOOKUP_DB_DRIVER)));
                }
                catch (PropertyVetoException ve) {
                    throw new RuntimeException("Unable to configure database driver: " + conf.getString(CONFIG_ID_LOOKUP_DB_DRIVER) + ". " + ve.getMessage(), ve);
                }
                this._dataSource.setJdbcUrl(StringUtils.trimToEmpty((String)conf.getString(CONFIG_ID_LOOKUP_DB_URL)));
                this._dataSource.setUser(StringUtils.trimToEmpty((String)conf.getString(CONFIG_ID_LOOKUP_DB_USERNAME)));
                this._dataSource.setPassword(StringUtils.trimToEmpty((String)conf.getString(CONFIG_ID_LOOKUP_DB_PASSWORD)));
                this._dataSource.setInitialPoolSize(0);
                this._dataSource.setMinPoolSize(1);
                this._dataSource.setMaxPoolSize(50);
                this._dataSource.setMaxIdleTime(300);
                this._dataSource.setCheckoutTimeout(10000);
                this._dataSource.setAcquireIncrement(1);
                this._dataSource.setAcquireRetryAttempts(2);
                this._dataSource.setAcquireRetryDelay(500);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Getting DB connection from: {}", (Object)this._dataSource);
        }
        try {
            return this._dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new SQLException(StringUtils.trimToEmpty((String)e.getMessage()) + " - Please check database is available, and CBORD payment gateway ID lookup database settings are correct.");
        }
    }
}

