/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDConnection;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDPlugin;
import biz.papercut.pcng.ext.paymentgateway.cbord.CBORDResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnCBORD
extends BasePaperCutPage
implements PageRenderListener {
    private static final Logger logger = LoggerFactory.getLogger(ExtnCBORD.class);

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract void setCBORDUserInfo(CBORDConnection.PatronInfo var1);

    public abstract CBORDConnection.PatronInfo getCBORDUserInfo();

    public abstract UserManager getUserManager();

    public abstract AccountManager getAccountManager();

    public abstract CreditSourceManager getCreditSourceManager();

    public abstract ApplicationLogManager getApplicationLogManager();

    public abstract LicenseManager getLicenseManager();

    public String getPageTitle() {
        String title = this.getPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("cbord.manual.allowed-amounts", (BasePaperCutPage)this));
        }
        if (!this.getRequestCycle().isRewinding()) {
            if (!this.getPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if (!this.userCanUse()) {
                return;
            }
            CBORDResponse<CBORDConnection.PatronInfo> r = this.getPlugin().patronInquiry(this.getUser());
            if (r.isSuccess()) {
                this.setCBORDUserInfo(r.getResult());
            } else {
                this.addErrorMessage(this.appendUserError(r.getErrorMessage()));
                logger.error("Error displaying CBORD add credit page to user: {}. {}", (Object)this.getUser().getUserName(), (Object)r.getErrorMessage());
                this.setCBORDUserInfo(null);
            }
        }
    }

    private String appendUserError(String baseError) {
        String s = StringUtils.trimToEmpty((String)this.getPlugin().getUserErrorMessage());
        if (s.endsWith(".")) {
            return s + " (" + StringUtils.trimToEmpty((String)baseError) + ")";
        }
        return s + ". (" + StringUtils.trimToEmpty((String)baseError) + ")";
    }

    public String getHeading() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String heading = conf.getString("cbord.manual.page-heading");
        if (StringUtils.isBlank((String)heading)) {
            heading = "Add credit using CBORD";
        }
        return heading;
    }

    public String getAvailableCreditLabel() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String heading = conf.getString("cbord.manual.available-credit-label");
        if (StringUtils.isBlank((String)heading)) {
            heading = "Available credit in CBORD";
        }
        return heading;
    }

    public boolean userCanUse() {
        CBORDPlugin p = this.getPlugin();
        return p.isManualTransferEnabled() && p.isManualTransferAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public boolean isReady() {
        return this.getCBORDUserInfo() != null;
    }

    public Double getAvailableCredit() {
        return this.getPlugin().getAvailableBalance(this.getCBORDUserInfo());
    }

    public void doTransaction(IRequestCycle cycle) {
        ValidationDelegate delegate = (ValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            this.addErrorMessage(delegate.getFirstError().toString());
            return;
        }
        if (!this.userCanUse()) {
            this.addErrorMessage("You do not have permission to access this feature.");
            return;
        }
        if (this.getAmount() == null || this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select an amount to add to your account.");
            return;
        }
        double amount = this.getAmount();
        Double availableCredit = this.getPlugin().getAvailableBalance(this.getCBORDUserInfo());
        if (availableCredit != null && amount > availableCredit) {
            this.addErrorMessage("Cannot transfer more than the available credit - " + this.formatBalance(availableCredit));
            return;
        }
        boolean success = false;
        try {
            CBORDResponse<CBORDConnection.TransactionInfo> r = this.getPlugin().deductCredit(this.getUser().getUserName(), amount);
            if (r.isSuccess()) {
                String txnComment = GatewayConfig.getInstance().getString("cbord.manual.transaction-comment");
                if (StringUtils.isBlank((String)txnComment)) {
                    txnComment = "Funds added from CBORD";
                }
                GatewayUtils.addCreditToUser(this.getAccountManager(), this.getCreditSourceManager(), this.getUser(), amount, txnComment);
                this.addStatusMessage(this.formatBalance(amount) + " was successfully added to your account.");
                cycle.activate("UserSummary");
                success = true;
            }
        }
        catch (Exception e) {
            logger.error("Error performing CBORD add credit transaction on user: {}", (Object)this.getUser().getUserName(), (Object)e);
        }
        if (!success) {
            this.addErrorMessage(this.getPlugin().getUserErrorMessage());
        }
    }

    public String getNoAccessMsg() {
        return GatewayConfig.getInstance().getNoAccessMessage();
    }

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    private CBORDPlugin getPlugin() {
        return (CBORDPlugin)PluginManager.getInstance().getPluginByClass(CBORDPlugin.class);
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return this.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return this.getGatewayConfig().getPageMessageAvailable();
    }
}

