/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord.dx;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXPlugin;
import biz.papercut.pcng.service.ApplicationLogManager;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CBORDDXCardLookup {
    private static final Logger logger = LoggerFactory.getLogger(CBORDDXCardLookup.class);
    private static final String CONFIG_PREFIX = "cbord-dx.";
    private static final String CONFIG_CARD_ID_LOOKUP_PREFIX = "cbord-dx.card-id-lookup.";
    private static final String CONFIG_CARD_ID_LOOKUP_MODE = "cbord-dx.card-id-lookup.mode";
    private static final String CONFIG_CARD_ID_LOOKUP_DB_DRIVER = "cbord-dx.card-id-lookup.db-driver";
    private static final String CONFIG_CARD_ID_LOOKUP_DB_URL = "cbord-dx.card-id-lookup.db-url";
    private static final String CONFIG_CARD_ID_LOOKUP_DB_USERNAME = "cbord-dx.card-id-lookup.db-username";
    static final String CONFIG_CARD_ID_LOOKUP_DB_PASSWORD = "cbord-dx.card-id-lookup.db-password";
    private static final String CONFIG_CARD_ID_LOOKUP_DB_SQL = "cbord-dx.card-id-lookup.db-sql";
    @Nullable
    private volatile ApplicationContext _ctx;
    @Nullable
    private final CBORDDXPlugin _plugin;
    @Nullable
    @GuardedBy(value="this")
    private ComboPooledDataSource _dataSource;

    public CBORDDXCardLookup(CBORDDXPlugin plugin) {
        this._plugin = plugin;
    }

    public void checkConfiguration() throws ConfigurationException {
        String errorPrefix = "Configuration problem: ";
        String errorSuffix = "  Please check the payment gateway config file.";
        GatewayConfig conf = GatewayConfig.getInstance();
        if (this.isDBLookupEnabled()) {
            if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_CARD_ID_LOOKUP_DB_DRIVER))) {
                throw new ConfigurationException(errorPrefix + "No database driver specified (cbord-dx.card-id-lookup.db-driver)." + errorSuffix);
            }
            if (StringUtils.isBlank((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_URL))) {
                throw new ConfigurationException(errorPrefix + "No database connection URL specified (cbord-dx.card-id-lookup.db-url)." + errorSuffix);
            }
            if (StringUtils.isBlank((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_USERNAME))) {
                throw new ConfigurationException(errorPrefix + "No database username specified (cbord-dx.card-id-lookup.db-username)." + errorSuffix);
            }
            if (StringUtils.isBlank((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_SQL))) {
                throw new ConfigurationException(errorPrefix + "No database lookup SQL specified (cbord-dx.card-id-lookup.db-sql)." + errorSuffix);
            }
        }
    }

    public String visibleCardId(String cardId) {
        return this._plugin.visibleCardId(cardId);
    }

    @CheckForNull
    public String getCBORDCardNumber(User user) {
        String cardId;
        if (this.isDBLookupEnabled()) {
            cardId = this.lookUpCBORDCardInDatabase(user);
            if (StringUtils.isBlank((String)cardId) && StringUtils.isNotBlank((String)user.getCardNumber())) {
                cardId = user.getCardNumber();
                logger.debug("Unable to determine card number for user '{}' in external database. Using internal card/id number: {}", (Object)user.getUserName(), (Object)this.visibleCardId(cardId));
            }
        } else {
            String s = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_CARD_ID_LOOKUP_MODE)).toUpperCase(Locale.US);
            if (s.equals("USERNAME")) {
                cardId = user.getUserName();
                logger.debug("Using username: {}", (Object)cardId);
            } else {
                cardId = user.getCardNumber();
                logger.debug("Using internal card/id number: {}", (Object)this.visibleCardId(cardId));
            }
        }
        if (StringUtils.isBlank((String)cardId)) {
            this.getEventLog().logEvent("Cannot determine CBORD card number for user: " + user.getUserName());
            return null;
        }
        return cardId;
    }

    private boolean isDBLookupEnabled() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_CARD_ID_LOOKUP_MODE)).toUpperCase(Locale.US);
        return s.equals("EXTERNAL_DATABASE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private String lookUpCBORDCardInDatabase(User user) {
        PreparedStatement stmt;
        ResultSet rs;
        Connection conn;
        block6: {
            String nextId;
            logger.debug("Looking up CBORD card number in database.");
            conn = null;
            rs = null;
            stmt = null;
            try {
                conn = this.openDBConnection();
                stmt = this.createLookupSQLStatement(conn, user);
                rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                String card = rs.getString(1);
                if (logger.isDebugEnabled() && rs.next()) {
                    nextId = rs.getString(1);
                    logger.debug("CBORD card lookup returned more than one result for user: {}. Match 1: {} Match 2: {} More matches: {}. Using first match.", new Object[]{user.getUserName(), this.visibleCardId(card), this.visibleCardId(nextId), rs.next()});
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Found CBORD card: {} for user: {} in lookup DB.", (Object)this.visibleCardId(card), (Object)user.getUserName());
                }
                nextId = card;
            }
            catch (Exception e) {
                try {
                    String msg = "Error occurred looking up CBORD card number in external database for user: " + user.getUserName() + ". " + e.getMessage();
                    EventLog.getInstance().logEvent(msg);
                    logger.error(msg, (Throwable)e);
                    this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(rs);
                    DbUtils.closeQuietly(stmt);
                    DbUtils.closeQuietly((Connection)conn);
                    throw throwable;
                }
                DbUtils.closeQuietly((ResultSet)rs);
                DbUtils.closeQuietly((Statement)stmt);
                DbUtils.closeQuietly((Connection)conn);
            }
            DbUtils.closeQuietly((ResultSet)rs);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((Connection)conn);
            return nextId;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        return null;
    }

    private PreparedStatement createLookupSQLStatement(Connection conn, User user) throws SQLException {
        PreparedStatement stmt;
        String sqlTemplate = this.getGatewayConfig().getString(CONFIG_CARD_ID_LOOKUP_DB_SQL);
        Matcher m = Pattern.compile("\\{\\s*(\\p{Alpha}+)\\s*\\}").matcher(sqlTemplate);
        if (logger.isDebugEnabled()) {
            logger.debug("SQL template: {}", (Object)sqlTemplate);
        }
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        while (m.find()) {
            String key;
            switch (key = m.group(1).trim().toLowerCase()) {
                case "username": {
                    params.add(user.getUserName());
                    break;
                }
                case "idnumber": {
                    params.add(user.getCardNumber());
                    break;
                }
                case "fullname": {
                    params.add(user.getFullName());
                    break;
                }
                default: {
                    throw new RuntimeException("Configuration error - unexpected replacement in SQL: " + key);
                }
            }
            m.appendReplacement(sql, "?");
        }
        m.appendTail(sql);
        if (params.isEmpty()) {
            throw new RuntimeException("Configuration error - CBORD lookup SQL does not contain any parameters/replacements. SQL: " + sqlTemplate);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Parsed SQL: \"{}\", params: {}", (Object)sql, params);
        }
        if ((stmt = conn.prepareStatement(sql.toString())).getParameterMetaData().getParameterCount() != params.size()) {
            throw new SQLException("Problem with replacements in card lookup SQL (cbord-dx.card-id-lookup.db-sql). Ensure replacements are not quoted.");
        }
        for (int i = 0; i < params.size(); ++i) {
            stmt.setString(i + 1, (String)params.get(i));
        }
        return stmt;
    }

    private synchronized Connection openDBConnection() throws SQLException {
        if (this._dataSource == null) {
            this._dataSource = this.createDataSource();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Getting DB connection from: {}", (Object)this._dataSource);
        }
        try {
            return this._dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new SQLException(StringUtils.trimToEmpty((String)e.getMessage()) + " - Please check database is available and CBORD payment gateway card lookup database settings are correct.");
        }
    }

    private synchronized ComboPooledDataSource createDataSource() {
        GatewayConfig conf = this.getGatewayConfig();
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        try {
            dataSource.setDriverClass(StringUtils.trimToEmpty((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_DRIVER)));
        }
        catch (PropertyVetoException ve) {
            throw new RuntimeException("Unable to configure database driver: " + conf.getString(CONFIG_CARD_ID_LOOKUP_DB_DRIVER) + ". " + ve.getMessage(), ve);
        }
        dataSource.setJdbcUrl(StringUtils.trimToEmpty((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_URL)));
        dataSource.setUser(StringUtils.trimToEmpty((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_USERNAME)));
        dataSource.setPassword(StringUtils.trimToEmpty((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_PASSWORD)));
        dataSource.setInitialPoolSize(0);
        dataSource.setMinPoolSize(1);
        dataSource.setMaxPoolSize(50);
        dataSource.setMaxIdleTime(300);
        dataSource.setCheckoutTimeout(10000);
        dataSource.setAcquireIncrement(1);
        dataSource.setAcquireRetryAttempts(2);
        dataSource.setAcquireRetryDelay(500);
        return dataSource;
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    private EventLog getEventLog() {
        return EventLog.getInstance();
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }
}

