/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord.dx;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXConnectionConfig;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.DebitResponse;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.ProtocolException;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.RequestMessage;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.ResponseMessage;
import biz.papercut.pcng.util.NetworkUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBORDDXConnection {
    private static final Logger logger = LoggerFactory.getLogger(CBORDDXConnection.class);
    private final CBORDDXConnectionConfig _connectionConfig;
    private final Socket _socket;
    private final Reader _reader;
    private final Writer _writer;

    private static String[] intersectStrings(List<String> l1, String[] l2) {
        return (String[])l1.stream().distinct().filter(s -> Arrays.asList(l2).contains(s)).toArray(String[]::new);
    }

    private static void setCipherSuite(CBORDDXConnectionConfig config, SSLSocket socket) {
        if (config.getCiphers() == null || config.getCiphers().isEmpty()) {
            return;
        }
        String[] ciphers = CBORDDXConnection.intersectStrings(config.getCiphers(), socket.getEnabledCipherSuites());
        if (ciphers.length == 0) {
            logger.error("No viable ciphers in properties: {}. Reverting to defaults.", config.getCiphers());
        } else {
            logger.debug("Using ciphers: {} for config: {}", (Object)ciphers, (Object)config);
            socket.setEnabledCipherSuites(ciphers);
        }
    }

    private static void setProtocols(CBORDDXConnectionConfig config, SSLSocket socket) {
        if (config.getProtocols() == null || config.getProtocols().isEmpty()) {
            return;
        }
        String[] protocols = CBORDDXConnection.intersectStrings(config.getProtocols(), socket.getEnabledProtocols());
        if (protocols.length == 0) {
            logger.error("No viable protocols in properties: {}. Reverting to defaults.", config.getProtocols());
        } else {
            logger.debug("Using protocols: {} for config: {}", (Object)protocols, (Object)config);
            socket.setEnabledProtocols(protocols);
        }
    }

    public CBORDDXConnection(CBORDDXConnectionConfig connectionConfig) throws IOException {
        SocketFactory socketFactory;
        logger.debug("Opening connection to CBORD server using: {}", (Object)connectionConfig);
        this._connectionConfig = connectionConfig;
        if (connectionConfig.isSsl()) {
            try {
                socketFactory = NetworkUtils.getTrustAllSSLSocketFactory();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            socketFactory = SocketFactory.getDefault();
        }
        this._socket = socketFactory.createSocket();
        this._socket.setSoTimeout(connectionConfig.getSocketReadTimeoutMS());
        this._socket.setKeepAlive(true);
        if (this._socket instanceof SSLSocket) {
            CBORDDXConnection.setCipherSuite(connectionConfig, (SSLSocket)this._socket);
            CBORDDXConnection.setProtocols(connectionConfig, (SSLSocket)this._socket);
        }
        this._socket.connect(new InetSocketAddress(connectionConfig.getServerHost(), connectionConfig.getServerPort()), connectionConfig.getSocketConnectTimeoutMS());
        if (this._socket instanceof SSLSocket) {
            ((SSLSocket)this._socket).startHandshake();
        }
        this._reader = new InputStreamReader(this._socket.getInputStream(), StandardCharsets.UTF_8);
        this._writer = new BufferedWriter(new OutputStreamWriter(this._socket.getOutputStream(), StandardCharsets.UTF_8));
    }

    public synchronized BalanceResponse getBalance(String provider, String cardOrId, RequestMessage.CardOrIdType cardOrIdType, String location, String codeMap, int sequenceNumber, String operator) throws IOException, ProtocolException {
        String status;
        boolean success;
        RequestMessage.TransactionType transactionType = RequestMessage.TransactionType.BalanceInquiry;
        RequestMessage req = new RequestMessage(this._connectionConfig.getServerType(), transactionType, provider, cardOrId, cardOrIdType, location, codeMap, sequenceNumber, null, -1, null, new Date(), null, operator);
        ResponseMessage res = this.sendAndReceive(req);
        Integer balanceCents = res.getNewBalanceCents();
        double balanceDollars = balanceCents == null ? -1.0 : (double)balanceCents.intValue() / 100.0;
        Integer availableCreditCents = res.getNewAvailableCreditCents();
        double availableCreditDollars = availableCreditCents == null ? -1.0 : (double)availableCreditCents.intValue() / 100.0;
        String statusMessage = res.getStatusMessage();
        String transactionId = res.getTransactionId();
        switch (res.getStatus()) {
            case Approved: {
                success = true;
                status = "SUCCESS";
                break;
            }
            case Denied: 
            case SystemError: {
                if (res.getStatus() == ResponseMessage.Status.Denied && statusMessage.contains("LOW BALANCE")) {
                    success = true;
                    status = "SUCCESS";
                    balanceDollars = 0.0;
                    availableCreditDollars = 0.0;
                    statusMessage = "";
                    if (transactionId != null && !transactionId.isEmpty()) break;
                    transactionId = "<zero balance>";
                    break;
                }
                if (statusMessage.contains("BAD ISSUE NUMBER")) {
                    statusMessage = "BAD ISSUE NUMBER - attempt to use old card which has been replaced";
                }
                success = false;
                status = "ERROR";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected response status: " + String.valueOf((Object)res.getStatus()));
            }
        }
        return new BalanceResponse(success, status, statusMessage, res.getPatron(), transactionId, balanceDollars, availableCreditDollars);
    }

    public synchronized DebitResponse performDebit(String provider, String cardOrId, RequestMessage.CardOrIdType cardOrIdType, String location, String codeMap, int sequenceNumber, @Nullable String currency, int amountCents, String orderId, @Nullable String operator) throws IOException, ProtocolException {
        RequestMessage req = new RequestMessage(this._connectionConfig.getServerType(), RequestMessage.TransactionType.Sale, provider, cardOrId, cardOrIdType, location, codeMap, sequenceNumber, currency, amountCents, orderId, new Date(), null, operator);
        ResponseMessage res = this.sendAndReceive(req);
        double amountDollars = (double)amountCents / 100.0;
        String msg = "Order " + orderId + " status: " + String.valueOf((Object)res.getStatus());
        if (logger.isDebugEnabled()) {
            String debugMsg = msg + " " + String.valueOf(res);
            logger.debug(debugMsg);
            CBORDDXConnection.getEventLog().logEvent(debugMsg);
        } else {
            logger.info(msg);
            CBORDDXConnection.getEventLog().logEvent(msg);
        }
        if (res.getStatus() == ResponseMessage.Status.Approved) {
            msg = "Order " + orderId + ": committing...";
            logger.debug(msg);
            CBORDDXConnection.getEventLog().logEvent(msg);
            RequestMessage commitReq = new RequestMessage(this._connectionConfig.getServerType(), RequestMessage.TransactionType.Commit, provider, null, null, null, null, sequenceNumber, null, null, null, null, res.getTransactionId(), operator);
            try {
                this.send(commitReq.toXML());
            }
            catch (IOException ioe) {
                String msg2 = "Order " + orderId + ": commit failed! Transaction will be rolled back.";
                logger.error(msg2);
                CBORDDXConnection.getEventLog().logEvent("ERROR: " + msg2);
                throw ioe;
            }
            String msg3 = "Order " + orderId + ": commit succeeded.";
            logger.debug(msg3);
            CBORDDXConnection.getEventLog().logEvent(msg3);
        }
        return switch (res.getStatus()) {
            default -> throw new MatchException(null, null);
            case ResponseMessage.Status.Approved -> new DebitResponse(true, "SUCCESS", res.getStatusMessage(), res.getReceipt(), res.getPatron(), res.getTransactionId(), amountDollars);
            case ResponseMessage.Status.Denied, ResponseMessage.Status.PartialAmountApproved -> new DebitResponse(false, "NO_CREDIT", res.getStatusMessage(), res.getReceipt(), res.getPatron(), res.getTransactionId(), 0.0);
            case ResponseMessage.Status.SystemError -> new DebitResponse(false, "ERROR", res.getStatusMessage(), res.getReceipt(), res.getPatron(), res.getTransactionId(), 0.0);
        };
    }

    private synchronized ResponseMessage sendAndReceive(RequestMessage requestMessage) throws IOException, ProtocolException {
        String responseXML;
        String requestXML = requestMessage.toXML();
        try {
            this.send(requestXML);
            responseXML = this.receive();
        }
        catch (SocketTimeoutException ste) {
            throw new IOException("Timed out reading response from CBORD.");
        }
        if (responseXML == null) {
            throw new IOException("Received empty response from CBORD.");
        }
        if (!responseXML.endsWith("</Message>")) {
            throw new IOException("Received incomplete message from CBORD.");
        }
        ResponseMessage responseMessage = ResponseMessage.valueOf(responseXML);
        if (responseMessage.getSequenceNumber() != requestMessage.getSequenceNumber()) {
            String msg = "Out of order response. Request: " + String.valueOf(requestMessage) + ", response: " + String.valueOf(responseMessage);
            logger.error(msg);
            CBORDDXConnection.getEventLog().logEvent("ERROR: " + msg);
            throw new ProtocolException("Out of order response");
        }
        return responseMessage;
    }

    private synchronized void send(String requestMessage) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("> {}", (Object)requestMessage);
        }
        IOUtils.write((String)requestMessage, (Writer)this._writer);
        this._writer.flush();
    }

    @CheckForNull
    private synchronized String receive() throws IOException {
        StringBuilder response = new StringBuilder();
        int i = -1;
        long startTime = System.currentTimeMillis();
        do {
            if (startTime + (long)this._connectionConfig.getMessageReceiveTimeoutMS() < System.currentTimeMillis()) {
                logger.warn("Timed out while reading a response from CBORD. Read so far: {}", (Object)response);
                throw new IOException("CBORD message receive timeout");
            }
            i = this._reader.read();
            if (i == -1) {
                logger.warn("CBORD closed connection before reading a full message. Read so far: {}", (Object)response);
                throw new IOException("CBORD connection closed while reading message");
            }
            if (response.isEmpty() && i != 60) continue;
            response.append((char)i);
        } while (!response.toString().endsWith("</Message>"));
        if (logger.isDebugEnabled()) {
            logger.debug("< {}", (Object)response);
        }
        return response.toString();
    }

    public synchronized void close() {
        logger.debug("Closing connection to CBORD server.");
        biz.papercut.pcng.util.io.IOUtils.closeQuietly((Socket)this._socket);
    }

    private static EventLog getEventLog() {
        return EventLog.getInstance();
    }
}

