/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord.dx;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXConnection;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXConnectionConfig;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.DebitResponse;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.ProtocolException;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.RequestMessage;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBORDDXConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(CBORDDXConnectionManager.class);
    private static final int CONNECT_ATTEMPTS = 2;
    private static final int MAX_SEQUENCE_NUMBER = 999999;
    private static final int RECONNECT_WAIT_MS = 1000;
    private static final int TIMEOUT_MS = 10000;
    private static final int MESSAGE_RESEND_ATTEMPTS = 3;
    private final CBORDDXConnectionConfig _connectionConfig;
    private final String _provider;
    @CheckForNull
    private final String _currency;
    @CheckForNull
    private final String _operator;
    @Nullable
    @GuardedBy(value="this")
    private CBORDDXConnection _connection;
    @GuardedBy(value="this")
    private int _sequenceNumber = 1;
    @GuardedBy(value="this")
    private long _lastConnectAttempt = System.currentTimeMillis() - 1000L;

    public CBORDDXConnectionManager(CBORDDXConnectionConfig connectionConfig, String provider, @Nullable String currency, @Nullable String operator) {
        this._connectionConfig = connectionConfig;
        this._provider = provider;
        this._currency = currency;
        this._operator = operator;
        this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BalanceResponse getBalance(String cardOrId, RequestMessage.CardOrIdType cardOrIdType, String location, String codeMap) {
        if (StringUtils.isBlank((String)cardOrId)) {
            return new BalanceResponse(false, "NO_ID", "Card/id not defined", null, null, 0.0, 0.0);
        }
        long startTime = System.currentTimeMillis();
        CBORDDXConnectionManager cBORDDXConnectionManager = this;
        synchronized (cBORDDXConnectionManager) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                return new BalanceResponse(false, "TIMED_OUT", "Timed out waiting to connect to CBORD", null, null, 0.0, 0.0);
            }
            BalanceResponse response = this.doWithConnection(connection -> connection.getBalance(this.getProvider(), cardOrId, cardOrIdType, location, codeMap, this.getNextSequenceNumber(), this.getOperator()));
            return Objects.requireNonNullElseGet(response, () -> new BalanceResponse(false, "CONNECT_FAILED", "Unable to connect to CBORD", null, null, 0.0, 0.0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebitResponse performDebit(String cardOrId, RequestMessage.CardOrIdType cardOrIdType, String location, String codeMap, int amountCents, String orderId) {
        if (StringUtils.isBlank((String)cardOrId)) {
            return new DebitResponse(false, "NO_ID", "Card/id not defined", null, null, null, 0.0);
        }
        long startTime = System.currentTimeMillis();
        CBORDDXConnectionManager cBORDDXConnectionManager = this;
        synchronized (cBORDDXConnectionManager) {
            if (System.currentTimeMillis() - startTime > 10000L) {
                return new DebitResponse(false, "TIMED_OUT", "Timed out waiting to connect to CBORD", null, null, null, 0.0);
            }
            DebitResponse response = this.doWithConnection(connection -> connection.performDebit(this.getProvider(), cardOrId, cardOrIdType, location, codeMap, this.getNextSequenceNumber(), this.getCurrency(), amountCents, orderId, this.getOperator()));
            return Objects.requireNonNullElseGet(response, () -> new DebitResponse(false, "CONNECT_FAILED", "Unable to connect to CBORD", null, null, null, 0.0));
        }
    }

    private synchronized void disconnect() {
        CBORDDXConnection connection = this.getConnection();
        if (connection != null) {
            connection.close();
            this.setConnection(null);
        }
    }

    @CheckForNull
    private synchronized CBORDDXConnection getConnection() {
        if (this._connection == null) {
            long tryAgainTime = System.currentTimeMillis() - this._lastConnectAttempt - 1000L;
            if (tryAgainTime < 0L) {
                String msg = "CBORD connection down, will try again in " + Math.abs(tryAgainTime) + "ms";
                if (logger.isDebugEnabled()) {
                    logger.debug(msg);
                }
                EventLog.getInstance().logEvent(msg);
                return null;
            }
            int connectAttempt = 0;
            do {
                if (++connectAttempt != 1) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                this._lastConnectAttempt = System.currentTimeMillis();
                try {
                    this.setConnection(new CBORDDXConnection(this._connectionConfig));
                }
                catch (Exception e) {
                    String msg = "Unable to connect to CBORD: " + String.valueOf(e);
                    logger.debug(msg);
                    EventLog.getInstance().logEvent(msg);
                }
            } while (this._connection == null && connectAttempt < 2);
            if (this._connection == null) {
                String msg = "Unable to connect to CBORD at " + this._connectionConfig.getServerHost() + ":" + this._connectionConfig.getServerPort() + " after " + connectAttempt + " attempts.";
                logger.error(msg);
                EventLog.getInstance().logEvent(msg);
            }
        }
        return this._connection;
    }

    private void setConnection(@Nullable CBORDDXConnection connection) {
        this._connection = connection;
    }

    @CheckForNull
    private <T> T doWithConnection(ConnectionRunnable<T> runnable) {
        T result = null;
        int sendAttempt = 0;
        while (result == null && sendAttempt++ < 3) {
            CBORDDXConnection connection = this.getConnection();
            if (connection == null) {
                return null;
            }
            try {
                result = runnable.run(connection);
            }
            catch (Exception e) {
                String msg = "Error sending message to CBORD (attempt " + sendAttempt + " of 2): " + e.getMessage() + ". ";
                logger.debug(msg);
                EventLog.getInstance().logEvent(msg);
                this.disconnect();
            }
        }
        return result;
    }

    @CheckForNull
    public String getCurrency() {
        return this._currency;
    }

    protected String getProvider() {
        return this._provider;
    }

    @CheckForNull
    private String getOperator() {
        return this._operator;
    }

    protected synchronized int getNextSequenceNumber() {
        int sequenceNumber = this._sequenceNumber++;
        if (this._sequenceNumber > 999999) {
            this._sequenceNumber = 1;
        }
        return sequenceNumber;
    }

    private static interface ConnectionRunnable<T> {
        public T run(CBORDDXConnection var1) throws ProtocolException, IOException;
    }
}

