/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.cbord.dx;

import biz.papercut.pcng.domain.Printer;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.BalanceResponse;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.CBORDDXPlugin;
import biz.papercut.pcng.ext.paymentgateway.cbord.dx.DebitResponse;
import biz.papercut.pcng.plugin.ExtDevicePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.service.PrinterManager;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CBORDDXExtDevicePlugin
implements ExtDevicePlugin,
SpringContextPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CBORDDXExtDevicePlugin.class);
    private static final String EXT_DEVICE_PLUGIN_ID = "cbord-dx";
    @Nullable
    @GuardedBy(value="this")
    private ApplicationContext _ctx;

    public String getId() {
        return EXT_DEVICE_PLUGIN_ID;
    }

    public Hashtable<String, Object> call(Map<String, Object> args) {
        String action = (String)args.get("action");
        String id = (String)args.get("id");
        String cardNumber = (String)args.get("cardNumber");
        String location = (String)args.get("location");
        String codeMap = (String)args.get("codeMap");
        String serverName = (String)args.get("serverName");
        String printerName = (String)args.get("printerName");
        Printer printer = null;
        if (StringUtils.isNotBlank((String)serverName) && StringUtils.isNotBlank((String)printerName)) {
            printer = this.getPrinterManager().findPrinter(serverName, printerName);
            if (printer == null) {
                logger.error("Printer not found: {}\\{}", (Object)serverName, (Object)printerName);
            }
        } else {
            logger.debug("Printer name not provided - will not be used to look up overrides.");
        }
        if (printer != null) {
            String cmo;
            String lo = CBORDDXPlugin.getPrinterLocationOverride(printer);
            if (StringUtils.isNotBlank((String)lo)) {
                location = lo;
                logger.debug("Using printer-level location override: {}", (Object)lo);
            }
            if (StringUtils.isNotBlank((String)(cmo = CBORDDXPlugin.getPrinterCodeMapOverride(printer)))) {
                codeMap = cmo;
                logger.debug("Using printer-level code map override: {}", (Object)cmo);
            }
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>(5);
        if ("balance".equals(action)) {
            BalanceResponse response = CBORDDXExtDevicePlugin.getCBORDDXPlugin().getBalance(id, cardNumber, location, codeMap);
            result.put("success", response.isSuccess());
            result.put("status", response.getStatus());
            result.put("statusMessage", StringUtils.trimToEmpty((String)response.getStatusMessage()));
            result.put("balance", response.getBalance());
            result.put("availableCredit", response.getAvailableCredit());
        } else if ("debit".equals(action)) {
            double amount = (Double)args.get("amount");
            DebitResponse response = CBORDDXExtDevicePlugin.getCBORDDXPlugin().performDebit(id, cardNumber, amount, location, codeMap);
            result.put("success", response.isSuccess());
            result.put("status", response.getStatus());
            result.put("statusMessage", StringUtils.trimToEmpty((String)response.getStatusMessage()));
            result.put("amount", response.getAmount());
        }
        return result;
    }

    public boolean isPluginEnabled() {
        CBORDDXPlugin cp = CBORDDXExtDevicePlugin.getCBORDDXPlugin();
        return cp.isPluginEnabled();
    }

    private synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private static CBORDDXPlugin getCBORDDXPlugin() {
        return (CBORDDXPlugin)PluginManager.getInstance().getPluginByClass(CBORDDXPlugin.class);
    }

    private PrinterManager getPrinterManager() {
        return (PrinterManager)this.getApplicationContext().getBean("printerManager", PrinterManager.class);
    }
}

